/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTestCases;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;

abstract class NativeNonUniqueIndexPopulatorTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulatorTests<KEY, VALUE> {
    private final NativeIndexPopulatorTestCases.PopulatorFactory<KEY, VALUE> populatorFactory;
    private final ValueType[] typesOfGroup;
    private final IndexLayoutFactory<KEY, VALUE> indexLayoutFactory;
    private static final IndexDescriptor nonUniqueDescriptor = TestIndexDescriptorFactory.forLabel(42, 666);

    NativeNonUniqueIndexPopulatorTest(NativeIndexPopulatorTestCases.PopulatorFactory<KEY, VALUE> populatorFactory, ValueType[] typesOfGroup, IndexLayoutFactory<KEY, VALUE> indexLayoutFactory) {
        this.populatorFactory = populatorFactory;
        this.typesOfGroup = typesOfGroup;
        this.indexLayoutFactory = indexLayoutFactory;
    }

    private static Value[] asValues(IndexEntryUpdate<IndexDescriptor>[] updates) {
        Value[] values = new Value[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            values[i] = updates[i].values()[0];
        }
        return values;
    }

    @Override
    NativeIndexPopulator<KEY, VALUE> createPopulator() throws IOException {
        return this.populatorFactory.create(this.pageCache, (FileSystemAbstraction)this.fs, this.indexFiles, this.layout, this.monitor, this.indexDescriptor, this.tokenNameLookup);
    }

    @Override
    ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
        return new ValueCreatorUtil(nonUniqueDescriptor, this.typesOfGroup, 0.1);
    }

    @Override
    IndexLayout<KEY, VALUE> createLayout() {
        return this.indexLayoutFactory.create();
    }

    @Test
    void addShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        this.populator.add(Arrays.asList(updates));
        this.populator.scanCompleted(PhaseTracker.nullInstance);
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    void updaterShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance);
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSampleUpdatesIfConfiguredForOnlineSampling() throws Exception {
        try {
            Value[] updates;
            this.populator.create();
            IndexEntryUpdate<IndexDescriptor>[] scanUpdates = this.valueCreatorUtil.someUpdates(this.random);
            this.populator.add(Arrays.asList(scanUpdates));
            Iterator<IndexEntryUpdate<IndexDescriptor>> generator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
            updates = new Value[]{generator.next().values()[0], generator.next().values()[0], updates[1], generator.next().values()[0], updates[3]};
            try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
                long nodeId = 1000L;
                for (Value value : updates) {
                    IndexEntryUpdate<IndexDescriptor> update = this.valueCreatorUtil.add(nodeId++, value);
                    updater.process(update);
                }
            }
            this.populator.scanCompleted(PhaseTracker.nullInstance);
            IndexSample sample = this.populator.sampleResult();
            Value[] allValues = Arrays.copyOf(updates, updates.length + scanUpdates.length);
            System.arraycopy(NativeNonUniqueIndexPopulatorTest.asValues(scanUpdates), 0, allValues, updates.length, scanUpdates.length);
            Assertions.assertEquals((long)(updates.length + scanUpdates.length), (long)sample.sampleSize());
            Assertions.assertEquals((long)ValueCreatorUtil.countUniqueValues(allValues), (long)sample.uniqueValues());
            Assertions.assertEquals((long)(updates.length + scanUpdates.length), (long)sample.indexSize());
        }
        finally {
            this.populator.close(true);
        }
    }
}

