/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

abstract class CloseCompatibility
extends LockCompatibilityTestSupport {
    CloseCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void shouldNotBeAbleToHandOutClientsIfClosed() {
        try (Locks.Client client = this.locks.newClient();){
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{0L});
        }
        this.locks.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((Locks)this.locks).newClient());
    }

    @Test
    void closeShouldWaitAllOperationToFinish() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        this.clientB.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.acquireShared(this.clientC, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 2L);
        this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.acquireExclusive(this.clientC, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientB.close();
        this.clientC.close();
        this.clientA.close();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assertions.assertEquals((int)0, (int)lockCountVisitor.getLockCount());
    }

    @Test
    void shouldNotBeAbleToAcquireSharedLockFromClosedClient() {
        this.clientA.close();
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L}));
    }

    @Test
    void shouldNotBeAbleToAcquireExclusiveLockFromClosedClient() {
        this.clientA.close();
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L}));
    }

    @Test
    void shouldNotBeAbleToTryAcquireSharedLockFromClosedClient() {
        this.clientA.close();
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.clientA.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    void shouldNotBeAbleToTryAcquireExclusiveLockFromClosedClient() {
        this.clientA.close();
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    void releaseTryLocksOnClose() {
        Assertions.assertTrue((boolean)this.clientA.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        Assertions.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 2L));
        this.clientA.close();
        this.clientB.close();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assertions.assertEquals((int)0, (int)lockCountVisitor.getLockCount());
    }
}

