/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsDeepStubs;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.values.virtual.VirtualValues;

class Neo4jTransactionalContextTest {
    private GraphDatabaseQueryService queryService;
    private KernelStatement statement;
    private ConfiguredExecutionStatistics statistics;
    private final GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
    private final KernelTransactionFactory transactionFactory = (KernelTransactionFactory)Mockito.mock(KernelTransactionFactory.class);
    private final NamedDatabaseId namedDatabaseId = TestDatabaseIdRepository.randomNamedDatabaseId();

    Neo4jTransactionalContextTest() {
    }

    @BeforeEach
    void setUp() {
        this.setUpMocks();
    }

    @Test
    void contextRollbackClosesAndRollbackTransaction() {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction kernelTransaction = this.mockTransaction((Statement)this.statement);
        Mockito.when((Object)internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(null, internalTransaction, this.statement, executingQuery, this.transactionFactory);
        transactionalContext.rollback();
        ((InternalTransaction)Mockito.verify((Object)internalTransaction)).rollback();
        Assertions.assertFalse((boolean)transactionalContext.isOpen());
    }

    @Test
    void checkKernelStatementOnCheck() {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        Mockito.when((Object)executingQuery.databaseId()).thenReturn((Object)this.namedDatabaseId);
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction kernelTransaction = this.mockTransaction((Statement)this.statement);
        Mockito.when((Object)initialTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(null, initialTransaction, this.statement, executingQuery, this.transactionFactory);
        transactionalContext.check();
        ((KernelTransaction)Mockito.verify((Object)kernelTransaction)).assertOpen();
    }

    @Test
    void neverStopsExecutingQueryDuringCommitAndRestartTx() throws TransactionFailureException {
        KernelTransaction initialKTX = this.mockTransaction((Statement)this.statement);
        InternalTransaction userTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction.Type transactionType = KernelTransaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        ClientConnectionInfo connectionInfo = ClientConnectionInfo.EMBEDDED_CONNECTION;
        Mockito.when((Object)userTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)userTransaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)userTransaction.terminationReason()).thenReturn(Optional.empty());
        Mockito.when((Object)userTransaction.clientInfo()).thenReturn((Object)connectionInfo);
        QueryRegistry initialQueryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        KernelStatement secondStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        KernelTransaction secondKTX = this.mockTransaction((Statement)secondStatement);
        QueryRegistry secondQueryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        Mockito.when((Object)this.transactionFactory.beginKernelTransaction(transactionType, (LoginContext)securityContext, connectionInfo)).thenReturn((Object)secondKTX);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.databaseId()).thenReturn((Object)this.namedDatabaseId);
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn((Object)VirtualValues.EMPTY_MAP);
        Mockito.when((Object)this.statement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)userTransaction.kernelTransaction()).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{initialKTX, secondKTX});
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(this.queryService, userTransaction, this.statement, executingQuery, this.transactionFactory);
        context.commitAndRestartTx();
        Object[] mocks = new Object[]{userTransaction, initialKTX, initialQueryRegistry, secondQueryRegistry, secondKTX};
        InOrder order = Mockito.inOrder((Object[])mocks);
        ((InternalTransaction)order.verify((Object)userTransaction)).transactionType();
        ((InternalTransaction)order.verify((Object)userTransaction)).securityContext();
        ((InternalTransaction)order.verify((Object)userTransaction)).clientInfo();
        ((InternalTransaction)order.verify((Object)userTransaction)).terminationReason();
        ((KernelTransaction)order.verify((Object)initialKTX)).executionStatistics();
        ((KernelTransaction)order.verify((Object)secondKTX)).acquireStatement();
        ((QueryRegistry)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
        ((QueryRegistry)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
        ((KernelTransaction)order.verify((Object)initialKTX)).commit();
    }

    @Test
    void rollsBackNewlyCreatedTransactionIfTerminationDetectedOnCloseDuringPeriodicCommit() throws TransactionFailureException {
        InternalTransaction userTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction.Type transactionType = KernelTransaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        ClientConnectionInfo connectionInfo = ClientConnectionInfo.EMBEDDED_CONNECTION;
        Mockito.when((Object)userTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)userTransaction.clientInfo()).thenReturn((Object)connectionInfo);
        Mockito.when((Object)userTransaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)userTransaction.terminationReason()).thenReturn(Optional.empty());
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        KernelStatement initialStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        KernelTransaction initialKTX = this.mockTransaction((Statement)initialStatement);
        QueryRegistry initialQueryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        KernelStatement secondStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        KernelTransaction secondKTX = this.mockTransaction((Statement)secondStatement);
        QueryRegistry secondQueryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        Mockito.when((Object)this.transactionFactory.beginKernelTransaction(transactionType, (LoginContext)securityContext, connectionInfo)).thenReturn((Object)secondKTX);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.databaseId()).thenReturn((Object)this.namedDatabaseId);
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn((Object)VirtualValues.EMPTY_MAP);
        ((KernelTransaction)Mockito.doThrow(RuntimeException.class).when((Object)initialKTX)).commit();
        Mockito.when((Object)initialStatement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)userTransaction.kernelTransaction()).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{initialKTX, secondKTX});
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(queryService, userTransaction, initialStatement, executingQuery, this.transactionFactory);
        Assertions.assertThrows(RuntimeException.class, () -> ((Neo4jTransactionalContext)context).commitAndRestartTx());
        Object[] mocks = new Object[]{userTransaction, initialQueryRegistry, initialKTX, secondQueryRegistry, secondKTX};
        InOrder order = Mockito.inOrder((Object[])mocks);
        ((InternalTransaction)order.verify((Object)userTransaction)).transactionType();
        ((InternalTransaction)order.verify((Object)userTransaction)).securityContext();
        ((InternalTransaction)order.verify((Object)userTransaction)).clientInfo();
        ((InternalTransaction)order.verify((Object)userTransaction)).terminationReason();
        ((KernelTransaction)order.verify((Object)initialKTX)).executionStatistics();
        ((KernelTransaction)order.verify((Object)secondKTX)).acquireStatement();
        ((QueryRegistry)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
        ((QueryRegistry)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
        ((InternalTransaction)order.verify((Object)userTransaction)).rollback();
    }

    @Test
    void accumulateExecutionStatisticOverCommitAndRestart() {
        InternalTransaction userTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)userTransaction.terminationReason()).thenReturn(Optional.empty());
        KernelStatement statementMock = (KernelStatement)Mockito.mock(KernelStatement.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction transaction = this.mockTransaction((Statement)statementMock);
        Mockito.when((Object)userTransaction.kernelTransaction()).thenReturn((Object)transaction);
        Mockito.when((Object)this.transactionFactory.beginKernelTransaction((KernelTransaction.Type)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)transaction);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        Mockito.when((Object)executingQuery.databaseId()).thenReturn((Object)this.namedDatabaseId);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(this.queryService, userTransaction, this.statement, executingQuery, this.transactionFactory);
        this.statistics.setFaults(2L);
        this.statistics.setHits(5L);
        transactionalContext.commitAndRestartTx();
        this.statistics.setFaults(2L);
        this.statistics.setHits(5L);
        transactionalContext.commitAndRestartTx();
        this.statistics.setFaults(2L);
        this.statistics.setHits(5L);
        StatisticProvider statisticProvider = transactionalContext.kernelStatisticProvider();
        Assertions.assertEquals((long)6L, (long)statisticProvider.getPageCacheMisses(), (String)"Expect to see accumulated number of page cache misses.");
        Assertions.assertEquals((long)15L, (long)statisticProvider.getPageCacheHits(), (String)"Expected to see accumulated number of page cache hits.");
    }

    @Test
    void shouldBeOpenAfterCreation() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assertions.assertTrue((boolean)context.isOpen());
    }

    @Test
    void shouldBeTopLevelWithImplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assertions.assertTrue((boolean)context.isTopLevelTx());
    }

    @Test
    void shouldNotBeTopLevelWithExplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.explicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assertions.assertFalse((boolean)context.isTopLevelTx());
    }

    @Test
    void shouldNotCloseTransactionDuringTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
    }

    @Test
    void shouldBePossibleToCloseAfterTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
        context.close();
    }

    @Test
    void shouldBePossibleToTerminateWithoutActiveTransaction() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.close();
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).terminate();
    }

    @Test
    void shouldThrowWhenRestartedAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable((Status)terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        Assertions.assertThrows(TransactionTerminatedException.class, () -> ((Neo4jTransactionalContext)context).commitAndRestartTx());
    }

    @Test
    void shouldThrowWhenGettingTxAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable((Status)terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        Assertions.assertThrows(TransactionTerminatedException.class, () -> ((Neo4jTransactionalContext)context).getOrBeginNewIfClosed());
    }

    @Test
    void shouldNotBePossibleToCloseMultipleTimes() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.close();
        context.close();
        context.close();
    }

    private void setUpMocks() {
        this.queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        this.statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        this.statistics = new ConfiguredExecutionStatistics();
        QueryRegistry queryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)internalTransaction.terminationReason()).thenReturn(Optional.empty());
        Mockito.when((Object)this.statement.queryRegistration()).thenReturn((Object)queryRegistry);
        Mockito.when((Object)this.queryService.getDependencyResolver()).thenReturn((Object)resolver);
        Mockito.when((Object)this.queryService.beginTransaction((KernelTransaction.Type)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)internalTransaction);
        KernelTransaction mockTransaction = this.mockTransaction((Statement)this.statement);
    }

    private Neo4jTransactionalContext newContext(InternalTransaction initialTx) {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        Mockito.when((Object)executingQuery.databaseId()).thenReturn((Object)this.namedDatabaseId);
        return new Neo4jTransactionalContext(this.queryService, initialTx, this.statement, executingQuery, this.transactionFactory);
    }

    private KernelTransaction mockTransaction(Statement statement) {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)kernelTransaction.executionStatistics()).thenReturn((Object)this.statistics);
        Mockito.when((Object)kernelTransaction.acquireStatement()).thenReturn((Object)statement);
        return kernelTransaction;
    }

    private static class ConfiguredExecutionStatistics
    implements ExecutionStatistics {
        private long hits;
        private long faults;

        private ConfiguredExecutionStatistics() {
        }

        public long pageHits() {
            return this.hits;
        }

        public long pageFaults() {
            return this.faults;
        }

        void setHits(long hits) {
            this.hits = hits;
        }

        void setFaults(long faults) {
            this.faults = faults;
        }
    }
}

