/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.IoPrimitiveUtils;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
class LogHeaderReaderTest {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private RandomRule random;
    private long expectedLogVersion;
    private long expectedTxId;
    private StoreId expectedStoreId;

    LogHeaderReaderTest() {
    }

    @BeforeEach
    void setUp() {
        this.expectedLogVersion = this.random.nextLong(0L, 0xFFFFFFFFFFFFFFL);
        this.expectedTxId = this.random.nextLong();
        this.expectedStoreId = new StoreId(this.random.nextLong(), this.random.nextLong(), this.random.nextLong(), this.random.nextLong(), this.random.nextLong());
    }

    @Test
    void shouldReadAnOldLogHeaderFromAByteChannel() throws IOException {
        final ByteBuffer buffer = ByteBuffers.allocate((int)64);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        final byte oldVersion = 6;
        Mockito.when((Object)channel.read(buffer)).thenAnswer((Answer)new Answer<Object>(){
            private int count;

            public Integer answer(InvocationOnMock invocation) {
                ++this.count;
                if (this.count == 1) {
                    buffer.putLong(LogHeaderWriter.encodeLogVersion((long)LogHeaderReaderTest.this.expectedLogVersion, (long)oldVersion));
                    return 8;
                }
                if (this.count == 2) {
                    buffer.putLong(LogHeaderReaderTest.this.expectedTxId);
                    return 8;
                }
                throw new AssertionError((Object)"Should only be called twice");
            }
        });
        LogHeader result = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true, null);
        Assertions.assertEquals((Object)new LogHeader(oldVersion, this.expectedLogVersion, this.expectedTxId, 16L), (Object)result);
    }

    @Test
    void shouldReadALogHeaderFromAByteChannel() throws IOException {
        final ByteBuffer buffer = ByteBuffers.allocate((int)64);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.read(buffer)).thenAnswer((Answer)new Answer<Object>(){
            private int count;

            public Integer answer(InvocationOnMock invocation) {
                ++this.count;
                if (this.count == 1) {
                    buffer.putLong(LogHeaderWriter.encodeLogVersion((long)LogHeaderReaderTest.this.expectedLogVersion, (long)7L));
                    return 8;
                }
                if (this.count == 2) {
                    buffer.putLong(LogHeaderReaderTest.this.expectedTxId);
                    buffer.putLong(LogHeaderReaderTest.this.expectedStoreId.getCreationTime());
                    buffer.putLong(LogHeaderReaderTest.this.expectedStoreId.getRandomId());
                    buffer.putLong(LogHeaderReaderTest.this.expectedStoreId.getStoreVersion());
                    buffer.putLong(LogHeaderReaderTest.this.expectedStoreId.getUpgradeTime());
                    buffer.putLong(LogHeaderReaderTest.this.expectedStoreId.getUpgradeTxId());
                    buffer.putLong(0L);
                    return 56;
                }
                throw new AssertionError((Object)"Should only be called 3 times");
            }
        });
        LogHeader result = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true, null);
        Assertions.assertEquals((Object)new LogHeader(7, this.expectedLogVersion, this.expectedTxId, this.expectedStoreId, 64L), (Object)result);
    }

    @Test
    void shouldFailWhenUnableToReadALogHeaderFromAChannel() throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate((int)64);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.read(buffer)).thenReturn((Object)1);
        Assertions.assertThrows(IncompleteLogHeaderException.class, () -> LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true, null));
    }

    @Test
    void shouldReadALogHeaderFromAFile() throws IOException {
        File file = this.testDirectory.file("ReadLogHeader", new String[0]);
        ByteBuffer buffer = ByteBuffers.allocate((int)64);
        buffer.putLong(LogHeaderWriter.encodeLogVersion((long)this.expectedLogVersion, (long)7L));
        buffer.putLong(this.expectedTxId);
        buffer.putLong(this.expectedStoreId.getCreationTime());
        buffer.putLong(this.expectedStoreId.getRandomId());
        buffer.putLong(this.expectedStoreId.getStoreVersion());
        buffer.putLong(this.expectedStoreId.getUpgradeTime());
        buffer.putLong(this.expectedStoreId.getUpgradeTxId());
        try (OutputStream stream = this.fileSystem.openAsOutputStream(file, false);){
            stream.write(buffer.array());
        }
        LogHeader result = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (File)file);
        Assertions.assertEquals((Object)new LogHeader(7, this.expectedLogVersion, this.expectedTxId, this.expectedStoreId, 64L), (Object)result);
    }

    @Test
    void shouldFailWhenUnableToReadALogHeaderFromAFile() throws IOException {
        File file = this.testDirectory.file("ReadLogHeader", new String[0]);
        this.fileSystem.write(file).close();
        IncompleteLogHeaderException exception = (IncompleteLogHeaderException)Assertions.assertThrows(IncompleteLogHeaderException.class, () -> LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (File)file));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)file.getName()));
    }

    @Test
    void shouldReadALongString() throws IOException {
        int stringSize = (int)(ByteUnit.kibiBytes((long)32L) + 1L);
        String lengthyString = "x".repeat(stringSize);
        InMemoryClosableChannel channel = new InMemoryClosableChannel(stringSize + 3);
        IoPrimitiveUtils.write3bLengthAndString((WritableChannel)channel, (String)lengthyString);
        String stringFromChannel = IoPrimitiveUtils.read3bLengthAndString((ReadableChannel)channel);
        Assertions.assertEquals((Object)lengthyString, (Object)stringFromChannel);
    }

    @Test
    void readEmptyPreallocatedFileHeaderAsNoHeader() throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate((int)64);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.read(buffer)).thenAnswer(invocation -> {
            buffer.putLong(0L);
            return 8;
        });
        LogHeader result = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true, null);
        Assertions.assertNull((Object)result);
        ((ReadableByteChannel)Mockito.verify((Object)channel)).read(buffer);
    }
}

