/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ConvertersTest {
    @Inject
    private TestDirectory directory;

    ConvertersTest() {
    }

    @Test
    void shouldSortFilesByNumberCleverly() throws Exception {
        File file1 = this.existenceOfFile("file1");
        File file123 = this.existenceOfFile("file123");
        File file12 = this.existenceOfFile("file12");
        File file2 = this.existenceOfFile("file2");
        File file32 = this.existenceOfFile("file32");
        Object[] files = (File[])Converters.regexFiles((boolean)true).apply(this.directory.file("file.*", new String[0]).getAbsolutePath());
        Assertions.assertArrayEquals((Object[])new File[]{file1, file2, file12, file32, file123}, (Object[])files);
    }

    @Test
    void shouldConvertFullHostnamePortToSocketAddress() {
        HostnamePort hostnamePort = new HostnamePort("neo4j.com", 7474);
        SocketAddress address = Converters.toSocketAddress((HostnamePort)hostnamePort, (String)"", (int)-1);
        Assertions.assertEquals((Object)new SocketAddress("neo4j.com", 7474), (Object)address);
    }

    @Test
    void shouldConvertFullIpV6HostnamePortToSocketAddress() {
        HostnamePort hostnamePort = new HostnamePort("[fe80:1:2:3:4::5:123]", 7687);
        SocketAddress address = Converters.toSocketAddress((HostnamePort)hostnamePort, (String)"", (int)-1);
        Assertions.assertEquals((Object)new SocketAddress("fe80:1:2:3:4::5:123", 7687), (Object)address);
    }

    @Test
    void shouldConvertHostnamePortWithOnlyHostnameToSocketAddress() {
        HostnamePort hostnamePort = new HostnamePort("hostname.neo4j.org");
        SocketAddress address = Converters.toSocketAddress((HostnamePort)hostnamePort, (String)"", (int)4242);
        Assertions.assertEquals((Object)new SocketAddress("hostname.neo4j.org", 4242), (Object)address);
    }

    @Test
    void shouldConvertHostnamePortWithOnlyIpV6HostnameToSocketAddress() {
        HostnamePort hostnamePort = new HostnamePort("[fe80:1:2:3:4::5]");
        SocketAddress address = Converters.toSocketAddress((HostnamePort)hostnamePort, (String)"", (int)1234);
        Assertions.assertEquals((Object)new SocketAddress("fe80:1:2:3:4::5", 1234), (Object)address);
    }

    @Test
    void shouldConvertHostnamePortWithOnlyPortToSocketAddress() {
        HostnamePort hostnamePort = new HostnamePort(":7687");
        SocketAddress address = Converters.toSocketAddress((HostnamePort)hostnamePort, (String)"neo4j.com", (int)-1);
        Assertions.assertEquals((Object)new SocketAddress("neo4j.com", 7687), (Object)address);
    }

    @Test
    void shouldParseFile() throws IOException {
        File file = this.existenceOfFile("file");
        File[] files = (File[])Converters.regexFiles((boolean)true).apply(file.getPath());
        Assertions.assertEquals(List.of(file), List.of(files));
    }

    @Test
    void shouldParseRegexFileWithDashes() throws IOException {
        Assumptions.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        File file1 = this.existenceOfFile("file_1");
        File file3 = this.existenceOfFile("file_3");
        File file12 = this.existenceOfFile("file_12");
        File[] files = (File[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\d+");
        File[] files2 = (File[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\d{1,5}");
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files));
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files2));
    }

    @Test
    void shouldParseRegexFileWithDoubleDashes() throws IOException {
        File file1 = this.existenceOfFile("file_1");
        File file3 = this.existenceOfFile("file_3");
        File file12 = this.existenceOfFile("file_12");
        File[] files = (File[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\\\d+");
        File[] files2 = (File[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\\\d{1,5}");
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files));
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files2));
    }

    @Test
    void shouldConsiderInnerQuotationWhenSplittingMultipleFiles() throws IOException {
        File header = this.existenceOfFile("header.csv");
        File file1 = this.existenceOfFile("file_1.csv");
        File file3 = this.existenceOfFile("file_3.csv");
        File file12 = this.existenceOfFile("file_12.csv");
        Function regexMatcher = Converters.regexFiles((boolean)true);
        Function converter = Converters.toFiles((String)",", (Function)regexMatcher);
        File[] files = (File[])converter.apply(header.getPath() + ",'" + header.getParent() + File.separator + "file_\\\\d{1,5}.csv'");
        Assertions.assertEquals(List.of(header, file1, file3, file12), List.of(files));
    }

    @Test
    void shouldFailWithProperErrorMessageOnMissingEndQuote() {
        Function<String, File[]> regexMatcher = s -> {
            throw new UnsupportedOperationException("Should not required");
        };
        Function converter = Converters.toFiles((String)",", regexMatcher);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> converter.apply("thing1,'thing2,test,thing3"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"no matching end quote"));
    }

    private File existenceOfFile(String name) throws IOException {
        File file = this.directory.file(name, new String[0]);
        Assertions.assertTrue((boolean)file.createNewFile());
        return file;
    }
}

