/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ValidatorsTest {
    @Inject
    private TestDirectory directory;

    ValidatorsTest() {
    }

    @Test
    void shouldFindFilesByRegex() throws Exception {
        this.existenceOfFile("abc");
        this.existenceOfFile("bcd");
        this.assertValid("abc");
        this.assertValid("bcd");
        this.assertValid("ab.");
        this.assertValid(".*bc");
        this.assertNotValid("abcd");
        this.assertNotValid(".*de.*");
    }

    private void assertNotValid(String string) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.validate(string));
    }

    private void assertValid(String fileByName) {
        this.validate(fileByName);
    }

    private void validate(String fileByName) {
        Validators.REGEX_FILE_EXISTS.validate((Object)this.directory.file(fileByName, new String[0]).getAbsolutePath());
    }

    private void existenceOfFile(String name) throws IOException {
        this.directory.file(name, new String[0]).createNewFile();
    }
}

