/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import java.nio.file.WatchKey;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.fs.watcher.resource.WatchedFile;
import org.neo4j.io.fs.watcher.resource.WatchedResource;
import org.neo4j.kernel.impl.util.watcher.DefaultFileDeletionEventListener;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;

class DefaultFileDeletionEventListenerTest {
    private final WatchKey key = (WatchKey)Mockito.mock(WatchKey.class);
    private final WatchedResource watchedResource = new WatchedFile(this.key);

    DefaultFileDeletionEventListenerTest() {
    }

    @Test
    void notificationInLogAboutFileDeletion() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted(this.key, "testFile");
        listener.fileDeleted(this.key, "anotherDirectory");
        internalLogProvider.formattedMessageMatcher().assertContains("'testFile' which belongs to the 'testdatabase' database was deleted while it was running.");
        internalLogProvider.formattedMessageMatcher().assertContains("'anotherDirectory' which belongs to the 'testdatabase' database was deleted while it was running.");
    }

    @Test
    void noNotificationForTransactionLogs() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted(this.key, "neostore.transaction.db.0");
        listener.fileDeleted(this.key, "neostore.transaction.db.1");
        internalLogProvider.assertNoLoggingOccurred();
    }

    private DefaultFileDeletionEventListener buildListener(AssertableLogProvider internalLogProvider) {
        NormalizedDatabaseName databaseName = new NormalizedDatabaseName("testDatabase");
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)internalLogProvider);
        return new DefaultFileDeletionEventListener(databaseName, Iterators.asSet((Object[])new WatchedResource[]{this.watchedResource}), (LogService)logService, filename -> filename.startsWith("neostore.transaction.db"));
    }
}

