/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.IOException;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.DatabasePanicEventGenerator;

class DatabaseHealthTest {
    DatabaseHealthTest() {
    }

    @Test
    void shouldGenerateDatabasePanicEvents() {
        DatabasePanicEventGenerator generator = (DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class);
        DatabaseHealth databaseHealth = new DatabaseHealth(generator, NullLogProvider.getInstance().getLog(DatabaseHealth.class));
        databaseHealth.healed();
        Exception cause = new Exception("My own fault");
        databaseHealth.panic((Throwable)cause);
        databaseHealth.panic((Throwable)cause);
        ((DatabasePanicEventGenerator)Mockito.verify((Object)generator)).panic();
    }

    @Test
    void shouldLogDatabasePanicEvent() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), logProvider.getLog(DatabaseHealth.class));
        databaseHealth.healed();
        String message = "Listen everybody... panic!";
        Exception exception = new Exception(message);
        databaseHealth.panic((Throwable)exception);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(DatabaseHealth.class).error(Is.is((Object)"Database panic: The database has encountered a critical error, and needs to be restarted. Please see database logs for more details."), Matchers.sameInstance((Object)exception))});
    }

    @Test
    void healDatabaseWithoutCriticalErrors() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), logProvider.getLog(DatabaseHealth.class));
        Assertions.assertTrue((boolean)databaseHealth.isHealthy());
        databaseHealth.panic((Throwable)new IOException("Space exception."));
        Assertions.assertFalse((boolean)databaseHealth.isHealthy());
        Assertions.assertTrue((boolean)databaseHealth.healed());
        logProvider.rawMessageMatcher().assertContains("Database health set to OK");
        logProvider.rawMessageMatcher().assertNotContains("Database encountered a critical error and can't be healed. Restart required.");
    }

    @Test
    void databaseWithCriticalErrorsCanNotBeHealed() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), logProvider.getLog(DatabaseHealth.class));
        Assertions.assertTrue((boolean)databaseHealth.isHealthy());
        IOException criticalException = new IOException("Space exception.", new OutOfMemoryError("Out of memory."));
        databaseHealth.panic((Throwable)criticalException);
        Assertions.assertFalse((boolean)databaseHealth.isHealthy());
        Assertions.assertFalse((boolean)databaseHealth.healed());
        logProvider.rawMessageMatcher().assertNotContains("Database health set to OK");
        logProvider.rawMessageMatcher().assertContains("Database encountered a critical error and can't be healed. Restart required.");
    }
}

