/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.common.ProgressReporter;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionLogsRecovery;

class RecoveryProgressIndicatorTest {
    RecoveryProgressIndicatorTest() {
    }

    @Test
    void reportProgressOnRecovery() throws Throwable {
        RecoveryService recoveryService = (RecoveryService)Mockito.mock(RecoveryService.class, (Answer)Answers.RETURNS_MOCKS);
        CorruptedLogsTruncator logsTruncator = (CorruptedLogsTruncator)Mockito.mock(CorruptedLogsTruncator.class);
        RecoveryMonitor recoveryMonitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        TransactionCursor reverseTransactionCursor = (TransactionCursor)Mockito.mock(TransactionCursor.class);
        TransactionCursor transactionCursor = (TransactionCursor)Mockito.mock(TransactionCursor.class);
        CommittedTransactionRepresentation transactionRepresentation = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        int transactionsToRecover = 5;
        int expectedMax = transactionsToRecover * 2;
        int lastCommittedTransactionId = 14;
        LogPosition recoveryStartPosition = new LogPosition(0L, 64L);
        int firstTxIdAfterLastCheckPoint = 10;
        RecoveryStartInformation startInformation = new RecoveryStartInformation(recoveryStartPosition, (long)firstTxIdAfterLastCheckPoint);
        Mockito.when((Object)reverseTransactionCursor.next()).thenAnswer((Answer)new NextTransactionAnswer(transactionsToRecover));
        Mockito.when((Object)transactionCursor.next()).thenAnswer((Answer)new NextTransactionAnswer(transactionsToRecover));
        Mockito.when((Object)((CommittedTransactionRepresentation)reverseTransactionCursor.get())).thenReturn((Object)transactionRepresentation);
        Mockito.when((Object)((CommittedTransactionRepresentation)transactionCursor.get())).thenReturn((Object)transactionRepresentation);
        Mockito.when((Object)transactionRepresentation.getCommitEntry()).thenReturn((Object)new LogEntryCommit((long)lastCommittedTransactionId, 1L, -559063315));
        Mockito.when((Object)recoveryService.getRecoveryStartInformation()).thenReturn((Object)startInformation);
        Mockito.when((Object)recoveryService.getTransactionsInReverseOrder(recoveryStartPosition)).thenReturn((Object)reverseTransactionCursor);
        Mockito.when((Object)recoveryService.getTransactions(recoveryStartPosition)).thenReturn((Object)transactionCursor);
        AssertableProgressReporter progressReporter = new AssertableProgressReporter(expectedMax);
        TransactionLogsRecovery recovery = new TransactionLogsRecovery(recoveryService, logsTruncator, (Lifecycle)new LifecycleAdapter(), recoveryMonitor, (ProgressReporter)progressReporter, true, RecoveryStartupChecker.EMPTY_CHECKER);
        recovery.init();
        progressReporter.verify();
    }

    private static class NextTransactionAnswer
    implements Answer<Boolean> {
        private final int expectedTransactionsToRecover;
        private int invocations;

        NextTransactionAnswer(int expectedTransactionsToRecover) {
            this.expectedTransactionsToRecover = expectedTransactionsToRecover;
        }

        public Boolean answer(InvocationOnMock invocationOnMock) {
            ++this.invocations;
            return this.invocations <= this.expectedTransactionsToRecover;
        }
    }

    private static class AssertableProgressReporter
    implements ProgressReporter {
        private final int expectedMax;
        private int recoveredTransactions;
        private long max;
        private boolean completed;

        AssertableProgressReporter(int expectedMax) {
            this.expectedMax = expectedMax;
        }

        public void start(long max) {
            this.max = max;
        }

        public void progress(long add) {
            this.recoveredTransactions = (int)((long)this.recoveredTransactions + add);
        }

        public void completed() {
            this.completed = true;
        }

        public void verify() {
            Assertions.assertTrue((boolean)this.completed, (String)"Progress reporting was not completed.");
            Assertions.assertEquals((long)this.expectedMax, (long)this.max, (String)"Number of max recovered transactions is different.");
            Assertions.assertEquals((int)this.expectedMax, (int)this.recoveredTransactions, (String)"Number of recovered transactions is different.");
        }
    }
}

