/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Predicate;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;

public class LogTestUtils {
    private LogTestUtils() {
    }

    public static File[] filterNeostoreLogicalLog(LogFiles logFiles, FileSystemAbstraction fileSystem, LogHook<LogEntry> filter) throws IOException {
        File[] files;
        for (File file : files = logFiles.logFiles()) {
            LogTestUtils.filterTransactionLogFile(fileSystem, file, filter, logFiles.getChannelNativeAccessor());
        }
        return files;
    }

    private static void filterTransactionLogFile(FileSystemAbstraction fileSystem, File file, LogHook<LogEntry> filter, LogFileChannelNativeAccessor channelNativeAccessor) throws IOException {
        filter.file(file);
        try (StoreChannel in = fileSystem.read(file);){
            LogEntry entry;
            LogHeader logHeader = LogHeaderReader.readLogHeader((ByteBuffer)ByteBuffers.allocate((int)64), (ReadableByteChannel)in, (boolean)true, (File)file);
            assert (logHeader != null) : "Looks like we tried to read a log header of an empty pre-allocated file.";
            PhysicalLogVersionedStoreChannel inChannel = new PhysicalLogVersionedStoreChannel(in, logHeader.getLogVersion(), logHeader.getLogFormatVersion(), file, (ChannelNativeAccessor)channelNativeAccessor);
            ReadAheadLogChannel inBuffer = new ReadAheadLogChannel((LogVersionedStoreChannel)inChannel);
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader();
            while ((entry = entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)inBuffer)) != null) {
                filter.test(entry);
            }
        }
    }

    public static class CountingLogHook<RECORD>
    extends LogHookAdapter<RECORD> {
        private int count;

        @Override
        public boolean test(RECORD item) {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static abstract class LogHookAdapter<RECORD>
    implements LogHook<RECORD> {
        @Override
        public void file(File file) {
        }

        @Override
        public void done(File file) {
        }
    }

    public static interface LogHook<RECORD>
    extends Predicate<RECORD> {
        public void file(File var1);

        public void done(File var1);
    }
}

