/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.kernel.api.query.CompilerInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.WaitStrategy;
import org.neo4j.memory.OptionalMemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.test.FakeCpuClock;
import org.neo4j.test.FakeMemoryTracker;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class ExecutingQueryTest {
    private final FakeClock clock = Clocks.fakeClock((TemporalAccessor)ZonedDateTime.parse("2016-12-03T15:10:00+01:00"));
    private final FakeCpuClock cpuClock = new FakeCpuClock().add(ExecutingQueryTest.randomLong(0x100000000L));
    private final PageCursorCountersStub page = new PageCursorCountersStub();
    private final ExecutingQuery query = this.createExecutingQuery(1, "hello world", this.page, this.clock, this.cpuClock);
    private final ExecutingQuery subQuery = this.createExecutingQuery(2, "goodbye world", this.page, this.clock, this.cpuClock);
    private long lockCount;

    ExecutingQueryTest() {
    }

    @Test
    void shouldReportElapsedTime() {
        this.clock.forward(10L, TimeUnit.MILLISECONDS);
        long elapsedTime = this.query.snapshot().elapsedTimeMicros();
        Assertions.assertEquals((long)10000L, (long)elapsedTime);
    }

    @Test
    void shouldTransitionBetweenStates() {
        Assertions.assertEquals((Object)"planning", (Object)this.query.snapshot().status());
        this.query.onCompilationCompleted(new CompilerInfo("the-planner", "the-runtime", Collections.emptyList()), QueryExecutionType.QueryType.READ_ONLY, null);
        Assertions.assertEquals((Object)"planned", (Object)this.query.snapshot().status());
        this.query.onExecutionStarted((OptionalMemoryTracker)new FakeMemoryTracker());
        Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        try (LockWaitEvent ignored = this.lock("NODE", 17L);){
            Assertions.assertEquals((Object)"waiting", (Object)this.query.snapshot().status());
        }
        Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
    }

    @Test
    void shouldReportPlanningTime() {
        this.clock.forward(124L, TimeUnit.MICROSECONDS);
        QuerySnapshot snapshot = this.query.snapshot();
        Assertions.assertEquals((long)snapshot.compilationTimeMicros(), (long)snapshot.elapsedTimeMicros());
        this.clock.forward(16L, TimeUnit.MICROSECONDS);
        this.query.onCompilationCompleted(new CompilerInfo("the-planner", "the-runtime", Collections.emptyList()), QueryExecutionType.QueryType.READ_ONLY, null);
        this.clock.forward(200L, TimeUnit.MICROSECONDS);
        snapshot = this.query.snapshot();
        Assertions.assertEquals((long)140L, (long)snapshot.compilationTimeMicros());
        Assertions.assertEquals((long)340L, (long)snapshot.elapsedTimeMicros());
    }

    @Test
    void shouldReportWaitTime() {
        QuerySnapshot snapshot;
        this.query.onCompilationCompleted(new CompilerInfo("the-planner", "the-runtime", Collections.emptyList()), QueryExecutionType.QueryType.READ_ONLY, null);
        this.query.onExecutionStarted((OptionalMemoryTracker)new FakeMemoryTracker());
        Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        this.clock.forward(10L, TimeUnit.SECONDS);
        try (LockWaitEvent ignored = this.lock("NODE", 17L);){
            this.clock.forward(5L, TimeUnit.SECONDS);
            snapshot = this.query.snapshot();
            Assertions.assertEquals((Object)"waiting", (Object)snapshot.status());
            MatcherAssert.assertThat((Object)snapshot.resourceInformation(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"waitTimeMillis", (Object)5000L), Matchers.hasEntry((Object)"resourceType", (Object)"NODE"), Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"resourceIds"), ExecutingQueryTest.longArray(17L))}));
            Assertions.assertEquals((long)5000000L, (long)snapshot.waitTimeMicros());
        }
        QuerySnapshot snapshot2 = this.query.snapshot();
        Assertions.assertEquals((Object)"running", (Object)snapshot2.status());
        Assertions.assertEquals((long)5000000L, (long)snapshot2.waitTimeMicros());
        this.clock.forward(2L, TimeUnit.SECONDS);
        ignored = this.lock("RELATIONSHIP", 612L);
        try {
            this.clock.forward(1L, TimeUnit.SECONDS);
            snapshot = this.query.snapshot();
            Assertions.assertEquals((Object)"waiting", (Object)snapshot.status());
            MatcherAssert.assertThat((Object)snapshot.resourceInformation(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"waitTimeMillis", (Object)1000L), Matchers.hasEntry((Object)"resourceType", (Object)"RELATIONSHIP"), Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"resourceIds"), ExecutingQueryTest.longArray(612L))}));
            Assertions.assertEquals((long)6000000L, (long)snapshot.waitTimeMicros());
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        snapshot2 = this.query.snapshot();
        Assertions.assertEquals((Object)"running", (Object)snapshot2.status());
        Assertions.assertEquals((long)6000000L, (long)snapshot2.waitTimeMicros());
    }

    @Test
    void shouldReportCpuTime() {
        this.cpuClock.add(60L, TimeUnit.MICROSECONDS);
        long cpuTime = this.query.snapshot().cpuTimeMicros();
        Assertions.assertEquals((long)60L, (long)cpuTime);
    }

    @Test
    void shouldNotReportCpuTimeIfUnavailable() {
        ExecutingQuery query = new ExecutingQuery(17L, ClientConnectionInfo.EMBEDDED_CONNECTION, TestDatabaseIdRepository.randomNamedDatabaseId(), "neo4j", "hello world", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, () -> 0L, () -> 1L, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE);
        QuerySnapshot snapshot = query.snapshot();
        Assertions.assertNull((Object)snapshot.cpuTimeMicros());
        Assertions.assertNull((Object)snapshot.idleTimeMicros());
    }

    @Test
    void shouldNotReportHeapAllocationIfUnavailable() {
        ExecutingQuery query = new ExecutingQuery(17L, ClientConnectionInfo.EMBEDDED_CONNECTION, TestDatabaseIdRepository.randomNamedDatabaseId(), "neo4j", "hello world", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, () -> 0L, () -> 1L, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE);
        QuerySnapshot snapshot = query.snapshot();
        Assertions.assertTrue((boolean)snapshot.allocatedBytes().isEmpty());
    }

    @Test
    void shouldReportLockCount() {
        this.lockCount = 11L;
        Assertions.assertEquals((long)11L, (long)this.query.snapshot().activeLockCount());
        this.lockCount = 2L;
        Assertions.assertEquals((long)2L, (long)this.query.snapshot().activeLockCount());
    }

    @Test
    void shouldReportPageHitsAndFaults() {
        this.page.hits(7L);
        this.page.faults(3L);
        QuerySnapshot snapshot = this.query.snapshot();
        Assertions.assertEquals((long)7L, (long)snapshot.pageHits());
        Assertions.assertEquals((long)3L, (long)snapshot.pageFaults());
        this.page.hits(2L);
        this.page.faults(5L);
        snapshot = this.query.snapshot();
        Assertions.assertEquals((long)9L, (long)snapshot.pageHits());
        Assertions.assertEquals((long)8L, (long)snapshot.pageFaults());
    }

    @Test
    void includeQueryExecutorThreadName() {
        String queryDescription = this.query.toString();
        Assertions.assertTrue((boolean)queryDescription.contains("threadExecutingTheQueryName=" + Thread.currentThread().getName()));
    }

    @Test
    void shouldObfuscateCreateUser() {
        this.testPasswordObfuscation("create USER foo SET PaSsWoRd ");
    }

    @Test
    void shouldObfuscateCreateOrReplaceUser() {
        this.testPasswordObfuscation("create OR replace USER foo SET PaSsWoRd ");
    }

    @Test
    void shouldObfuscateCreateUserIfNotExits() {
        this.testPasswordObfuscation("create USER foo IF not EXisTS SET PaSsWoRd ");
    }

    @Test
    void shouldObfuscateAlterUser() {
        this.testPasswordObfuscation("alter USER foo SET PaSsWoRd ");
    }

    @Test
    void shouldObfuscateAlterCurrentUser() {
        String queryPart = "alter CuRRenT USER foo SET PaSsWoRd FROM ";
        ExecutingQuery exeQuery = this.createExecutingQuery(1, queryPart + "'bar' TO 'baz'", this.page, this.clock, this.cpuClock, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, VirtualValues.EMPTY_MAP);
        MatcherAssert.assertThat((Object)exeQuery.queryText(), (Matcher)CoreMatchers.equalTo((Object)(queryPart + "'******' TO '******'")));
        MatcherAssert.assertThat((Object)exeQuery.queryParameters().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MapValue params2 = VirtualValues.map((String[])new String[]{"old", "new"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"bar"), Values.stringValue((String)"baz")});
        MapValue obfuscatedParams2 = VirtualValues.map((String[])new String[]{"old", "new"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"******"), Values.stringValue((String)"******")});
        ExecutingQuery exeQuery2 = this.createExecutingQuery(1, queryPart + "$old TO $new", this.page, this.clock, this.cpuClock, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, params2);
        MatcherAssert.assertThat((Object)exeQuery2.queryText(), (Matcher)CoreMatchers.equalTo((Object)(queryPart + "$old TO $new")));
        MatcherAssert.assertThat((Object)exeQuery2.queryParameters(), (Matcher)CoreMatchers.equalTo((Object)obfuscatedParams2));
        MapValue params3 = VirtualValues.map((String[])new String[]{"old"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"bar")});
        MapValue obfuscatedParams3 = VirtualValues.map((String[])new String[]{"old"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"******")});
        ExecutingQuery exeQuery3 = this.createExecutingQuery(1, queryPart + "$old TO 'baz'", this.page, this.clock, this.cpuClock, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, params3);
        MatcherAssert.assertThat((Object)exeQuery3.queryText(), (Matcher)CoreMatchers.equalTo((Object)(queryPart + "$old TO '******'")));
        MatcherAssert.assertThat((Object)exeQuery3.queryParameters(), (Matcher)CoreMatchers.equalTo((Object)obfuscatedParams3));
    }

    @Test
    void shouldNotAllowCompletingCompilationMultipleTimes() {
        this.query.onCompilationCompleted(null, null, null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.query.onCompilationCompleted(null, null, null));
    }

    @Test
    void shouldNotAllowStartingExecutionWithoutCompilation() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.query.onExecutionStarted(null));
    }

    @Test
    void shouldAllowRetryingAfterStartingExecutiong() {
        Assertions.assertEquals((Object)"planning", (Object)this.query.snapshot().status());
        this.query.onCompilationCompleted(null, null, null);
        Assertions.assertEquals((Object)"planned", (Object)this.query.snapshot().status());
        this.query.onExecutionStarted((OptionalMemoryTracker)new FakeMemoryTracker());
        Assertions.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        this.query.onRetryAttempted();
        Assertions.assertEquals((Object)"planning", (Object)this.query.snapshot().status());
    }

    @Test
    void shouldNotAllowRetryingWithoutStartingExecuting() {
        this.query.onCompilationCompleted(null, null, null);
        Assertions.assertThrows(IllegalStateException.class, () -> ((ExecutingQuery)this.query).onRetryAttempted());
    }

    private void testPasswordObfuscation(String startOfQuery) {
        ExecutingQuery exeQuery1 = this.createExecutingQuery(1, startOfQuery + "'bar'", this.page, this.clock, this.cpuClock, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, VirtualValues.EMPTY_MAP);
        MatcherAssert.assertThat((Object)exeQuery1.queryText(), (Matcher)CoreMatchers.equalTo((Object)(startOfQuery + "'******'")));
        MatcherAssert.assertThat((Object)exeQuery1.queryParameters().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MapValue params = VirtualValues.map((String[])new String[]{"password"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"bar")});
        MapValue obfuscatedParams = VirtualValues.map((String[])new String[]{"password"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"******")});
        ExecutingQuery exeQuery2 = this.createExecutingQuery(1, startOfQuery + "$password", this.page, this.clock, this.cpuClock, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, params);
        MatcherAssert.assertThat((Object)exeQuery2.queryText(), (Matcher)CoreMatchers.equalTo((Object)(startOfQuery + "$password")));
        MatcherAssert.assertThat((Object)exeQuery2.queryParameters(), (Matcher)CoreMatchers.equalTo((Object)obfuscatedParams));
    }

    private LockWaitEvent lock(String resourceType, long resourceId) {
        return this.query.lockTracer().waitForLock(false, ExecutingQueryTest.resourceType(resourceType), new long[]{resourceId});
    }

    static ResourceType resourceType(final String name) {
        return new ResourceType(){

            public String toString() {
                return this.name();
            }

            public int typeId() {
                throw new UnsupportedOperationException("not used");
            }

            public WaitStrategy waitStrategy() {
                throw new UnsupportedOperationException("not used");
            }

            public String name() {
                return name;
            }
        };
    }

    private static Matcher<Object> longArray(final long ... expected) {
        return new TypeSafeMatcher<long[]>(){

            protected boolean matchesSafely(long[] item) {
                return Arrays.equals(expected, item);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expected);
            }
        };
    }

    private static long randomLong(long bound) {
        return ThreadLocalRandom.current().nextLong(bound);
    }

    private ExecutingQuery createExecutingQuery(int queryId, String hello_world, PageCursorCountersStub page, FakeClock clock, FakeCpuClock cpuClock) {
        return this.createExecutingQuery(queryId, hello_world, page, clock, cpuClock, TestDatabaseIdRepository.randomNamedDatabaseId(), VirtualValues.EMPTY_MAP);
    }

    private ExecutingQuery createExecutingQuery(int queryId, String hello_world, PageCursorCountersStub page, FakeClock clock, FakeCpuClock cpuClock, NamedDatabaseId dbID, MapValue params) {
        return new ExecutingQuery((long)queryId, ClientConnectionInfo.EMBEDDED_CONNECTION, dbID, "neo4j", hello_world, params, Collections.emptyMap(), () -> this.lockCount, page::hits, page::faults, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)clock, (CpuClock)cpuClock);
    }

    private static class PageCursorCountersStub
    implements PageCursorCounters {
        private long faults;
        private long pins;
        private long unpins;
        private long hits;
        private long bytesRead;
        private long evictions;
        private long evictionExceptions;
        private long bytesWritten;
        private long flushes;

        private PageCursorCountersStub() {
        }

        public long faults() {
            return this.faults;
        }

        public void faults(long increment) {
            this.faults += increment;
        }

        public long pins() {
            return this.pins;
        }

        public void pins(long increment) {
            this.pins += increment;
        }

        public long unpins() {
            return this.unpins;
        }

        public void unpins(long increment) {
            this.unpins += increment;
        }

        public long hits() {
            return this.hits;
        }

        public void hits(long increment) {
            this.hits += increment;
        }

        public long bytesRead() {
            return this.bytesRead;
        }

        public void bytesRead(long increment) {
            this.bytesRead += increment;
        }

        public long evictions() {
            return this.evictions;
        }

        public void evictions(long increment) {
            this.evictions += increment;
        }

        public long evictionExceptions() {
            return this.evictionExceptions;
        }

        public void evictionExceptions(long increment) {
            this.evictionExceptions += increment;
        }

        public long bytesWritten() {
            return this.bytesWritten;
        }

        public void bytesWritten(long increment) {
            this.bytesWritten += increment;
        }

        public long flushes() {
            return this.flushes;
        }

        public void flushes(long increment) {
            this.flushes += increment;
        }

        public double hitRatio() {
            return MathUtil.portion((double[])new double[]{this.hits(), this.faults()});
        }
    }
}

