/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;

class SchemaIndexDescriptorFactoryTest {
    private static final int LABEL_ID = 0;

    SchemaIndexDescriptorFactoryTest() {
    }

    @Test
    void shouldCreateIndexDescriptors() {
        IndexDescriptor desc = TestIndexDescriptorFactory.forLabel(0, 1);
        Assertions.assertFalse((boolean)desc.isUnique());
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    void shouldCreateUniqueIndexDescriptors() {
        IndexDescriptor desc = TestIndexDescriptorFactory.uniqueForLabel(0, 1);
        Assertions.assertTrue((boolean)desc.isUnique());
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    void shouldCreateIndexDescriptorsFromSchema() {
        IndexDescriptor desc = TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        Assertions.assertFalse((boolean)desc.isUnique());
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
        desc = TestIndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        Assertions.assertTrue((boolean)desc.isUnique());
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    void shouldCreateEqualDescriptors() {
        IndexDescriptor desc1 = TestIndexDescriptorFactory.forLabel(0, 1);
        IndexDescriptor desc2 = TestIndexDescriptorFactory.forLabel(0, 1);
        SchemaTestUtil.assertEquality(desc1.schema(), desc2.schema());
        SchemaTestUtil.assertEquality(desc1.isUnique(), desc2.isUnique());
        desc1 = TestIndexDescriptorFactory.uniqueForLabel(0, 1);
        desc2 = TestIndexDescriptorFactory.uniqueForLabel(0, 1);
        SchemaTestUtil.assertEquality(desc1.schema(), desc2.schema());
        SchemaTestUtil.assertEquality(desc1.isUnique(), desc2.isUnique());
    }

    @Test
    void shouldGiveNiceUserDescriptions() {
        IndexDescriptor forLabel = TestIndexDescriptorFactory.forLabel(1, 2);
        long forLabelId = forLabel.getId();
        IndexDescriptor uniqueForLabel = TestIndexDescriptorFactory.uniqueForLabel(2, 4);
        String providerName = forLabel.getIndexProvider().name();
        long uniqueForLabelId = uniqueForLabel.getId();
        MatcherAssert.assertThat((Object)forLabel.userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP), (Matcher)Matchers.equalTo((Object)("Index( " + forLabelId + ", 'index_" + forLabelId + "', GENERAL BTREE, :Label1(property2), " + providerName + " )")));
        MatcherAssert.assertThat((Object)uniqueForLabel.userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP), (Matcher)Matchers.equalTo((Object)("Index( " + uniqueForLabelId + ", 'index_" + uniqueForLabelId + "', UNIQUE BTREE, :Label2(property4), " + providerName + " )")));
    }
}

