/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.string.UTF8;

class AuthTokenTest {
    AuthTokenTest() {
    }

    @Test
    void shouldMakeBasicAuthToken() {
        Map token = AuthToken.newBasicAuthToken((String)"me", (String)"my secret");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)UTF8.encode((String)"my secret")));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"basic"));
        MatcherAssert.assertThat((String)"Should have no realm", token.get("realm"), (Matcher)Matchers.nullValue());
    }

    @Test
    void shouldMakeBasicAuthTokenWithRealm() {
        Map token = AuthToken.newBasicAuthToken((String)"me", (String)"my secret", (String)"my realm");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)UTF8.encode((String)"my secret")));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"basic"));
        MatcherAssert.assertThat((String)"Should have correct realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
    }

    @Test
    void shouldMakeCustomAuthTokenAndBasicScheme() {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"basic");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)UTF8.encode((String)"my secret")));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"basic"));
        MatcherAssert.assertThat((String)"Should have correctno realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
    }

    @Test
    void shouldMakeCustomAuthTokenAndCustomcScheme() {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"my scheme");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)UTF8.encode((String)"my secret")));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"my scheme"));
        MatcherAssert.assertThat((String)"Should have correct realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
    }

    @Test
    void shouldMakeCustomAuthTokenAndCustomcSchemeWithParameters() {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"my scheme", (Map)MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"}));
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)UTF8.encode((String)"my secret")));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"my scheme"));
        MatcherAssert.assertThat((String)"Should have correct realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
        MatcherAssert.assertThat((String)"Should have correct parameters", token.get("parameters"), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"})));
    }
}

