/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class})
@Neo4jLayoutExtension
class KernelDiagnosticsTest {
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;

    KernelDiagnosticsTest() {
    }

    @Test
    void shouldPrintDiskUsage() throws IOException {
        File storeDir = (File)Mockito.spy((Object)new File("storeDir"));
        DatabaseLayout layout = (DatabaseLayout)Mockito.mock(DatabaseLayout.class);
        Mockito.when((Object)layout.databaseDirectory()).thenReturn((Object)storeDir);
        Mockito.when((Object)storeDir.getTotalSpace()).thenReturn((Object)100L);
        Mockito.when((Object)storeDir.getFreeSpace()).thenReturn((Object)40L);
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        Mockito.when((Object)storageEngineFactory.listStorageFiles((FileSystemAbstraction)ArgumentMatchers.any(), (DatabaseLayout)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, (FileSystemAbstraction)this.fs, layout);
        storeFiles.dump(logProvider.getLog(this.getClass()).debugLogger());
        logProvider.rawMessageMatcher().assertContains("100 / 40 / 40");
    }

    @Test
    void printDatabaseFileStoreType() {
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, (FileSystemAbstraction)this.fs, this.databaseLayout);
        storeFiles.dump(logProvider.getLog(this.getClass()).debugLogger());
        logProvider.rawMessageMatcher().assertContains("Storage files stored on file store: ");
    }

    @Test
    void shouldCountFileSizeRecursively() throws IOException {
        File storeDir = this.testDirectory.directory("storedir", new String[0]);
        DatabaseLayout layout = DatabaseLayout.ofFlat((File)storeDir);
        File indexDir = this.directory(storeDir, "indexDir");
        this.file(indexDir, "indexFile", (int)ByteUnit.kibiBytes((long)1L));
        this.file(storeDir, layout.metadataStore().getName(), (int)ByteUnit.kibiBytes((long)3L));
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        Mockito.when((Object)storageEngineFactory.listStorageFiles((FileSystemAbstraction)ArgumentMatchers.any(), (DatabaseLayout)ArgumentMatchers.any())).thenReturn(Arrays.asList(layout.metadataStore()));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, (FileSystemAbstraction)this.fs, layout);
        storeFiles.dump(logProvider.getLog(this.getClass()).debugLogger());
        logProvider.rawMessageMatcher().assertContains("Total size of store: 4.000KiB");
        logProvider.rawMessageMatcher().assertContains("Total size of mapped files: 3.000KiB");
    }

    private File directory(File parent, String name) throws IOException {
        File dir = new File(parent, name);
        this.fs.mkdirs(dir);
        return dir;
    }

    private File file(File parent, String name, int size) throws IOException {
        File file = new File(parent, name);
        try (StoreFileChannel channel = this.fs.write(file);){
            ByteBuffer buffer = ByteBuffers.allocate((int)size);
            buffer.position(size).flip();
            channel.write(buffer);
        }
        return file;
    }
}

