/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.factory.StatementLocksFactorySelector;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;

class StatementLocksFactorySelectorTest {
    StatementLocksFactorySelectorTest() {
    }

    @Test
    void loadSimpleStatementLocksFactoryWhenNoServices() {
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)locksClient);
        TestStatementLocksFactorySelector loader = StatementLocksFactorySelectorTest.newLoader(locks, new StatementLocksFactory[0]);
        StatementLocksFactory factory = loader.select();
        StatementLocks statementLocks = factory.newInstance();
        MatcherAssert.assertThat((Object)factory, (Matcher)Matchers.instanceOf(SimpleStatementLocksFactory.class));
        MatcherAssert.assertThat((Object)statementLocks, (Matcher)Matchers.instanceOf(SimpleStatementLocks.class));
        Assertions.assertSame((Object)locksClient, (Object)statementLocks.optimistic());
        Assertions.assertSame((Object)locksClient, (Object)statementLocks.pessimistic());
    }

    @Test
    void loadSingleAvailableFactory() {
        Locks locks = (Locks)Mockito.mock(Locks.class);
        StatementLocksFactory factory = (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class);
        TestStatementLocksFactorySelector loader = StatementLocksFactorySelectorTest.newLoader(locks, factory);
        StatementLocksFactory loadedFactory = loader.select();
        Assertions.assertSame((Object)factory, (Object)loadedFactory);
        ((StatementLocksFactory)Mockito.verify((Object)factory)).initialize((Locks)ArgumentMatchers.same((Object)locks), (Config)Mockito.any(Config.class));
    }

    @Test
    void throwWhenMultipleFactoriesLoaded() {
        TestStatementLocksFactorySelector loader = StatementLocksFactorySelectorTest.newLoader((Locks)Mockito.mock(Locks.class), (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class), (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class), (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class));
        try {
            loader.select();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    private static TestStatementLocksFactorySelector newLoader(Locks locks, StatementLocksFactory ... factories) {
        return new TestStatementLocksFactorySelector(locks, Config.defaults(), (LogService)NullLogService.getInstance(), factories);
    }

    private static class TestStatementLocksFactorySelector
    extends StatementLocksFactorySelector {
        private final List<StatementLocksFactory> factories;

        TestStatementLocksFactorySelector(Locks locks, Config config, LogService logService, StatementLocksFactory ... factories) {
            super(locks, config, logService);
            this.factories = Arrays.asList(factories);
        }

        List<StatementLocksFactory> serviceLoadFactories() {
            return this.factories;
        }
    }
}

