/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.GatheringNodeValueClient;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeDistinctValuesProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class NativeDistinctValuesProgressorTest {
    private static final Config config = Config.defaults();
    private static final IndexSpecificSpaceFillingCurveSettings specificSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
    private final GenericLayout layout = new GenericLayout(1, specificSettings);
    @Inject
    private RandomRule random;

    NativeDistinctValuesProgressorTest() {
    }

    @Test
    void shouldCountDistinctValues() {
        Value[] strings = this.generateRandomStrings();
        DataCursor source = new DataCursor(this.asHitData(strings));
        GatheringNodeValueClient client = new GatheringNodeValueClient();
        NativeDistinctValuesProgressor progressor = new NativeDistinctValuesProgressor((Seeker)source, (IndexProgressor.EntityValueClient)client, (IndexLayout)this.layout, (arg_0, arg_1) -> ((GenericLayout)this.layout).compareValue(arg_0, arg_1));
        client.initialize(null, (IndexProgressor)progressor, new IndexQuery[0], IndexOrder.NONE, true, false);
        Map<Value, MutableInt> expectedCounts = NativeDistinctValuesProgressorTest.asDistinctCounts(strings);
        int uniqueValues = 0;
        int nonUniqueValues = 0;
        while (progressor.next()) {
            Value string = client.values[0];
            MutableInt expectedCount = expectedCounts.remove(string);
            Assertions.assertNotNull((Object)expectedCount);
            Assertions.assertEquals((long)expectedCount.intValue(), (long)client.reference);
            if (expectedCount.intValue() > 1) {
                ++nonUniqueValues;
                continue;
            }
            ++uniqueValues;
        }
        Assertions.assertTrue((boolean)expectedCounts.isEmpty());
        Assertions.assertTrue((uniqueValues > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((nonUniqueValues > 0 ? 1 : 0) != 0);
    }

    private static Map<Value, MutableInt> asDistinctCounts(Value[] strings) {
        HashMap<Value, MutableInt> map = new HashMap<Value, MutableInt>();
        for (Value string : strings) {
            map.computeIfAbsent(string, s -> new MutableInt(0)).increment();
        }
        return map;
    }

    private Value[] generateRandomStrings() {
        Value[] strings = new Value[1000];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Values.stringValue((String)String.valueOf(this.random.nextInt(1000)));
        }
        Arrays.sort(strings, Values.COMPARATOR);
        return strings;
    }

    private Collection<Pair<GenericKey, NativeIndexValue>> asHitData(Value[] strings) {
        ArrayList<Pair<GenericKey, NativeIndexValue>> data = new ArrayList<Pair<GenericKey, NativeIndexValue>>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            GenericKey key = this.layout.newKey();
            key.initialize((long)i);
            key.initFromValue(0, strings[i], NativeIndexKey.Inclusion.NEUTRAL);
            data.add((Pair<GenericKey, NativeIndexValue>)Pair.of((Object)key, (Object)NativeIndexValue.INSTANCE));
        }
        return data;
    }

    private static class DataCursor
    implements Seeker<GenericKey, NativeIndexValue> {
        private final Iterator<Pair<GenericKey, NativeIndexValue>> iterator;
        private Pair<GenericKey, NativeIndexValue> current;

        DataCursor(Collection<Pair<GenericKey, NativeIndexValue>> data) {
            this.iterator = data.iterator();
        }

        public boolean next() throws RuntimeException {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.current = this.iterator.next();
            return true;
        }

        public void close() throws RuntimeException {
        }

        public GenericKey key() {
            return (GenericKey)this.current.getKey();
        }

        public NativeIndexValue value() {
            return (NativeIndexValue)this.current.getValue();
        }
    }
}

