/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class NativeIndexAccessorTests<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexTestUtil<KEY, VALUE> {
    private NativeIndexAccessor<KEY, VALUE> accessor;

    NativeIndexAccessorTests() {
    }

    @BeforeEach
    void setupAccessor() throws IOException {
        this.accessor = this.makeAccessor();
    }

    abstract NativeIndexAccessor<KEY, VALUE> makeAccessor() throws IOException;

    abstract IndexCapability indexCapability();

    @AfterEach
    void closeAccessor() {
        this.accessor.close();
    }

    @Test
    void shouldHandleCloseWithoutCallsToProcess() throws Exception {
        NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
    }

    @Test
    void processMustThrowAfterClose() throws Exception {
        NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.lambda$processMustThrowAfterClose$0((IndexUpdater)updater));
    }

    @Test
    void shouldIndexAdd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            NativeIndexAccessorTests.processAll((IndexUpdater)updater, updates);
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    void shouldIndexChange() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        Iterator generator = Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random));
        for (int i = 0; i < updates.length; ++i) {
            IndexEntryUpdate<IndexDescriptor> update = updates[i];
            Value newValue = ((IndexEntryUpdate)generator.next()).values()[0];
            updates[i] = IndexEntryUpdate.change((long)update.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value)update.values()[0], (Value)newValue);
        }
        this.processAll(updates);
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    void shouldIndexRemove() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        for (int i = 0; i < updates.length; ++i) {
            IndexEntryUpdate<IndexDescriptor> update = updates[i];
            IndexEntryUpdate remove = IndexEntryUpdate.remove((long)update.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])update.values());
            this.processAll(remove);
            this.forceAndCloseAccessor();
            this.verifyUpdates(Arrays.copyOfRange(updates, i + 1, updates.length));
            this.setupAccessor();
        }
    }

    @Test
    void shouldHandleRandomUpdates() throws Exception {
        HashSet<IndexEntryUpdate<IndexDescriptor>> expectedData = new HashSet<IndexEntryUpdate<IndexDescriptor>>();
        Iterator<IndexEntryUpdate<IndexDescriptor>> newDataGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        int rounds = 50;
        for (int round = 0; round < rounds; ++round) {
            IndexEntryUpdate<IndexDescriptor>[] batch = this.generateRandomUpdates(expectedData, newDataGenerator, this.random.nextInt(5, 20), (float)round / (float)rounds * 2.0f);
            this.processAll(batch);
            this.applyUpdatesToExpectedData(expectedData, batch);
            this.forceAndCloseAccessor();
            this.verifyUpdates(expectedData.toArray(new IndexEntryUpdate[0]));
            this.setupAccessor();
        }
    }

    @Test
    void shouldReturnZeroCountForEmptyIndex() {
        try (IndexReader reader = this.accessor.newReader();){
            IndexEntryUpdate<IndexDescriptor> update = this.valueCreatorUtil.randomUpdateGenerator(this.random).next();
            long count = reader.countIndexedNodes(123L, this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds(), new Value[]{update.values()[0]});
            Assertions.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    void shouldReturnCountOneForExistingData() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                long count = reader.countIndexedNodes(update.getEntityId(), this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds(), update.values());
                Assertions.assertEquals((long)1L, (long)count);
            }
            Iterator generator = Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random));
            long count = reader.countIndexedNodes(123L, this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds(), new Value[]{((IndexEntryUpdate)generator.next()).values()[0]});
            Assertions.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    void shouldReturnCountZeroForMismatchingData() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            int[] propKeys = this.valueCreatorUtil.indexDescriptor.schema().getPropertyIds();
            long countWithMismatchingData = reader.countIndexedNodes(update.getEntityId() + 1L, propKeys, update.values());
            long countWithNonExistentEntityId = reader.countIndexedNodes(1000000000L, propKeys, update.values());
            long countWithNonExistentValue = reader.countIndexedNodes(update.getEntityId(), propKeys, new Value[]{this.generateUniqueValue(updates)});
            Assertions.assertEquals((long)0L, (long)countWithMismatchingData);
            Assertions.assertEquals((long)0L, (long)countWithNonExistentEntityId);
            Assertions.assertEquals((long)0L, (long)countWithNonExistentValue);
        }
    }

    @Test
    void shouldReturnAllEntriesForExistsPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, (IndexQuery)IndexQuery.exists((int)0));){
            NativeIndexAccessorTests.assertEntityIdHits(NativeIndexAccessorTests.extractEntityIds(updates, Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnNoEntriesForExistsPredicateForEmptyIndex() throws Exception {
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, (IndexQuery)IndexQuery.exists((int)0));){
            long[] actual = PrimitiveLongCollections.asArray((LongIterator)result);
            Assertions.assertEquals((int)0, (int)actual.length);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForExactPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            Value value = update.values()[0];
            try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, (IndexQuery)IndexQuery.exact((int)0, (Object)value));){
                NativeIndexAccessorTests.assertEntityIdHits(NativeIndexAccessorTests.extractEntityIds(updates, Predicates.in((Object[])new Value[]{value})), (LongIterator)result);
            }
        }
    }

    @Test
    void shouldReturnNoEntriesForMismatchingExactPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        Value value = this.generateUniqueValue(updates);
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, (IndexQuery)IndexQuery.exact((int)0, (Object)value));){
            NativeIndexAccessorTests.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[0]), true, NativeIndexAccessorTests.valueOf(updates[updates.length - 1]), false));){
            NativeIndexAccessorTests.assertEntityIdHits(NativeIndexAccessorTests.extractEntityIds(Arrays.copyOf(updates, updates.length - 1), Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd(updates);
    }

    private void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd(IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException, IndexNotApplicableKernelException {
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[0]), true, NativeIndexAccessorTests.valueOf(updates[updates.length - 1]), true));){
            NativeIndexAccessorTests.assertEntityIdHits(NativeIndexAccessorTests.extractEntityIds(updates, Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[0]), false, NativeIndexAccessorTests.valueOf(updates[updates.length - 1]), false));){
            NativeIndexAccessorTests.assertEntityIdHits(NativeIndexAccessorTests.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length - 1), Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[0]), false, NativeIndexAccessorTests.valueOf(updates[updates.length - 1]), true));){
            NativeIndexAccessorTests.assertEntityIdHits(NativeIndexAccessorTests.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length), Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnNoEntriesForRangePredicateOutsideAnyMatch() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.valueCreatorUtil.sort(updates);
        this.processAll(updates[0], updates[1], updates[updates.length - 1], updates[updates.length - 2]);
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator result = NativeIndexAccessorTests.query(reader, this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[2]), true, NativeIndexAccessorTests.valueOf(updates[updates.length - 3]), true));){
            NativeIndexAccessorTests.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, (LongIterator)result);
        }
    }

    @Test
    void mustHandleNestedQueries() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.mustHandleNestedQueries(updates);
    }

    private void mustHandleNestedQueries(IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException, IndexNotApplicableKernelException {
        ArrayList<Long> outerResult;
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery outerQuery = this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[2]), true, NativeIndexAccessorTests.valueOf(updates[3]), true);
        IndexQuery innerQuery = this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[0]), true, NativeIndexAccessorTests.valueOf(updates[1]), true);
        long[] expectedOuter = new long[]{NativeIndexAccessorTests.entityIdOf(updates[2]), NativeIndexAccessorTests.entityIdOf(updates[3])};
        long[] expectedInner = new long[]{NativeIndexAccessorTests.entityIdOf(updates[0]), NativeIndexAccessorTests.entityIdOf(updates[1])};
        try (NodeValueIterator outerIter = NativeIndexAccessorTests.query(reader, outerQuery);){
            outerResult = new ArrayList<Long>();
            while (outerIter.hasNext()) {
                outerResult.add(outerIter.next());
                NodeValueIterator innerIter = NativeIndexAccessorTests.query(reader, innerQuery);
                try {
                    NativeIndexAccessorTests.assertEntityIdHits(expectedInner, (LongIterator)innerIter);
                }
                finally {
                    if (innerIter == null) continue;
                    innerIter.close();
                }
            }
        }
        NativeIndexAccessorTests.assertEntityIdHits(expectedOuter, outerResult);
    }

    @Test
    void mustHandleMultipleNestedQueries() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.mustHandleMultipleNestedQueries(updates);
    }

    private void mustHandleMultipleNestedQueries(IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException, IndexNotApplicableKernelException {
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery query1 = this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[4]), true, NativeIndexAccessorTests.valueOf(updates[5]), true);
        IndexQuery query2 = this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[2]), true, NativeIndexAccessorTests.valueOf(updates[3]), true);
        IndexQuery query3 = this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[0]), true, NativeIndexAccessorTests.valueOf(updates[1]), true);
        long[] expected1 = new long[]{NativeIndexAccessorTests.entityIdOf(updates[4]), NativeIndexAccessorTests.entityIdOf(updates[5])};
        long[] expected2 = new long[]{NativeIndexAccessorTests.entityIdOf(updates[2]), NativeIndexAccessorTests.entityIdOf(updates[3])};
        long[] expected3 = new long[]{NativeIndexAccessorTests.entityIdOf(updates[0]), NativeIndexAccessorTests.entityIdOf(updates[1])};
        ArrayList<Long> result1 = new ArrayList<Long>();
        try (NodeValueIterator iter1 = NativeIndexAccessorTests.query(reader, query1);){
            while (iter1.hasNext()) {
                result1.add(iter1.next());
                ArrayList<Long> result2 = new ArrayList<Long>();
                try (NodeValueIterator iter2 = NativeIndexAccessorTests.query(reader, query2);){
                    while (iter2.hasNext()) {
                        result2.add(iter2.next());
                        ArrayList<Long> result3 = new ArrayList<Long>();
                        try (NodeValueIterator iter3 = NativeIndexAccessorTests.query(reader, query3);){
                            while (iter3.hasNext()) {
                                result3.add(iter3.next());
                            }
                        }
                        NativeIndexAccessorTests.assertEntityIdHits(expected3, result3);
                    }
                }
                NativeIndexAccessorTests.assertEntityIdHits(expected2, result2);
            }
        }
        NativeIndexAccessorTests.assertEntityIdHits(expected1, result1);
    }

    private static long entityIdOf(IndexEntryUpdate<IndexDescriptor> update) {
        return update.getEntityId();
    }

    @Test
    void shouldHandleMultipleConsecutiveUpdaters() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates;
        for (IndexEntryUpdate<IndexDescriptor> update : updates = this.someUpdatesSingleType()) {
            try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
                updater.process(update);
            }
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    void requestForSecondUpdaterMustThrow() throws Exception {
        try (NativeIndexUpdater ignored = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newUpdater(IndexUpdateMode.ONLINE));
        }
    }

    @Test
    void dropShouldDeleteAndCloseIndex() {
        this.assertFilePresent();
        this.accessor.drop();
        this.assertFileNotPresent();
    }

    @Test
    void forceShouldCheckpointTree() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] data = this.someUpdatesSingleType();
        this.processAll(data);
        this.accessor.force(IOLimiter.UNLIMITED);
        this.accessor.close();
        this.verifyUpdates(data);
    }

    @Test
    void closeShouldCloseTreeWithoutCheckpoint() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] data = this.someUpdatesSingleType();
        this.processAll(data);
        this.accessor.close();
        this.verifyUpdates(new IndexEntryUpdate[0]);
    }

    @Test
    void snapshotFilesShouldReturnIndexFile() {
        ResourceIterator files = this.accessor.snapshotFiles();
        Assertions.assertTrue((boolean)files.hasNext());
        Assertions.assertEquals((Object)this.indexFiles.getStoreFile(), (Object)files.next());
        Assertions.assertFalse((boolean)files.hasNext());
    }

    @Test
    void shouldSampleIndex() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();
             IndexSampler sampler = reader.createSampler();){
            IndexSample sample = sampler.sampleIndex();
            Assertions.assertEquals((long)updates.length, (long)sample.indexSize());
            Assertions.assertEquals((long)updates.length, (long)sample.sampleSize());
            Assertions.assertEquals((long)ValueCreatorUtil.countUniqueValues(updates), (long)sample.uniqueValues());
        }
    }

    @Test
    void readingAfterDropShouldThrow() {
        this.accessor.drop();
        Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newReader());
    }

    @Test
    void writingAfterDropShouldThrow() {
        this.accessor.drop();
        Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newUpdater(IndexUpdateMode.ONLINE));
    }

    @Test
    void readingAfterCloseShouldThrow() {
        this.accessor.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newReader());
    }

    @Test
    void writingAfterCloseShouldThrow() {
        this.accessor.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newUpdater(IndexUpdateMode.ONLINE));
    }

    @Test
    void shouldSeeAllEntriesInAllEntriesReader() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Stream.of(updates).map(IndexEntryUpdate::getEntityId).collect(Collectors.toCollection(HashSet::new));
        Assertions.assertEquals((Object)expectedIds, (Object)ids);
    }

    @Test
    void shouldSeeNoEntriesInAllEntriesReaderOnEmptyIndex() {
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Collections.emptySet();
        Assertions.assertEquals(expectedIds, (Object)ids);
    }

    @Test
    void shouldNotSeeFilteredEntries() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        this.valueCreatorUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        try (NodeValueIterator iter = new NodeValueIterator();){
            IndexQuery.ExactPredicate filter = IndexQuery.exact((int)0, (Object)NativeIndexAccessorTests.valueOf(updates[1]));
            IndexQuery rangeQuery = this.valueCreatorUtil.rangeQuery(NativeIndexAccessorTests.valueOf(updates[0]), true, NativeIndexAccessorTests.valueOf(updates[2]), true);
            IndexProgressor.EntityValueClient filterClient = NativeIndexAccessorTests.filterClient(iter, (IndexQuery)filter);
            reader.query(QueryContext.NULL_CONTEXT, filterClient, IndexOrder.NONE, false, new IndexQuery[]{rangeQuery});
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((long)NativeIndexAccessorTests.entityIdOf(updates[1]), (long)iter.next());
            Assertions.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    void respectIndexOrder() throws Exception {
        int nUpdates = 10000;
        ValueType[] types = this.supportedTypesExcludingNonOrderable();
        Iterator<IndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random, types);
        IndexEntryUpdate[] someUpdates = new IndexEntryUpdate[nUpdates];
        for (int i = 0; i < nUpdates; ++i) {
            someUpdates[i] = randomUpdateGenerator.next();
        }
        this.processAll(someUpdates);
        Object[] allValues = this.valueCreatorUtil.extractValuesFromUpdates(someUpdates);
        try (IndexReader reader = this.accessor.newReader();){
            IndexOrder[] supportedOrders;
            ValueGroup valueGroup = ((Value)this.random.among(allValues)).valueGroup();
            IndexQuery.RangePredicate supportedQuery = IndexQuery.range((int)0, (ValueGroup)valueGroup);
            for (IndexOrder supportedOrder : supportedOrders = this.indexCapability().orderCapability(new ValueCategory[]{valueGroup.category()})) {
                if (supportedOrder == IndexOrder.NONE) continue;
                Value[] expectedValues = (Value[])Arrays.stream(allValues).filter(v -> v.valueGroup() == valueGroup).toArray(Value[]::new);
                if (supportedOrder == IndexOrder.ASCENDING) {
                    Arrays.sort(expectedValues, Values.COMPARATOR);
                }
                if (supportedOrder == IndexOrder.DESCENDING) {
                    Arrays.sort(expectedValues, Values.COMPARATOR.reversed());
                }
                SimpleNodeValueClient client = new SimpleNodeValueClient();
                reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)client, supportedOrder, true, new IndexQuery[]{supportedQuery});
                int i = 0;
                while (client.next()) {
                    Assertions.assertEquals((Object)expectedValues[i++], (Object)client.values[0], (String)"values in order");
                }
                Assertions.assertEquals((int)i, (int)expectedValues.length, (String)"found all values");
            }
        }
    }

    @Test
    void throwForUnsupportedIndexOrder() {
        try (IndexReader reader = this.accessor.newReader();){
            IndexOrder unsupportedOrder = IndexOrder.DESCENDING;
            IndexQuery.ExactPredicate unsupportedQuery = IndexQuery.exact((int)0, (Object)PointValue.MAX_VALUE);
            UnsupportedOperationException e = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)new SimpleNodeValueClient(), unsupportedOrder, false, new IndexQuery[]{unsupportedQuery}));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"unsupported order"), CoreMatchers.containsString((String)unsupportedOrder.toString()), CoreMatchers.containsString((String)unsupportedQuery.toString())}));
        }
    }

    @Test
    void getValues() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        List expectedValues;
        IndexQuery.RangePredicate supportedQuery;
        int nUpdates = 10000;
        Iterator<IndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
        IndexEntryUpdate[] someUpdates = new IndexEntryUpdate[nUpdates];
        for (int i = 0; i < nUpdates; ++i) {
            someUpdates[i] = randomUpdateGenerator.next();
        }
        this.processAll(someUpdates);
        Object[] allValues = this.valueCreatorUtil.extractValuesFromUpdates(someUpdates);
        Value value = (Value)this.random.among(allValues);
        ValueGroup valueGroup = value.valueGroup();
        IndexValueCapability valueCapability = this.indexCapability().valueCapability(new ValueCategory[]{valueGroup.category()});
        if (!valueCapability.equals((Object)IndexValueCapability.YES)) {
            return;
        }
        if (Values.isGeometryValue((Value)value)) {
            CoordinateReferenceSystem crs = ((PointValue)value).getCoordinateReferenceSystem();
            supportedQuery = IndexQuery.range((int)0, (CoordinateReferenceSystem)crs);
            expectedValues = Arrays.stream(allValues).filter(v -> v.valueGroup() == ValueGroup.GEOMETRY).filter(v -> ((PointValue)v).getCoordinateReferenceSystem() == crs).collect(Collectors.toList());
        } else {
            supportedQuery = IndexQuery.range((int)0, (ValueGroup)valueGroup);
            expectedValues = Arrays.stream(allValues).filter(v -> v.valueGroup() == valueGroup).collect(Collectors.toList());
        }
        try (IndexReader reader = this.accessor.newReader();){
            SimpleNodeValueClient client = new SimpleNodeValueClient();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)client, IndexOrder.NONE, true, new IndexQuery[]{supportedQuery});
            while (client.next()) {
                Value foundValue = client.values[0];
                Assertions.assertTrue((boolean)expectedValues.remove(foundValue), (String)("found value that was not expected " + foundValue));
            }
            MatcherAssert.assertThat((String)"did not find all expected values", (Object)expectedValues.size(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    private Value generateUniqueValue(IndexEntryUpdate<IndexDescriptor>[] updates) {
        return ((IndexEntryUpdate)Iterators.filter(NativeIndexAccessorTests.skipExisting(updates), this.valueCreatorUtil.randomUpdateGenerator(this.random)).next()).values()[0];
    }

    private static Predicate<IndexEntryUpdate<IndexDescriptor>> skipExisting(IndexEntryUpdate<IndexDescriptor>[] existing) {
        return update -> {
            for (IndexEntryUpdate e : existing) {
                if (!Arrays.equals(e.values(), update.values())) continue;
                return false;
            }
            return true;
        };
    }

    private static Value valueOf(IndexEntryUpdate<IndexDescriptor> update) {
        return update.values()[0];
    }

    private static IndexProgressor.EntityValueClient filterClient(final NodeValueIterator iter, final IndexQuery filter) {
        return new IndexProgressor.EntityValueClient(){

            public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues, boolean indexIncludesTransactionState) {
                iter.initialize(descriptor, progressor, query, indexOrder, needsValues, indexIncludesTransactionState);
            }

            public boolean acceptEntity(long reference, float score, Value ... values) {
                if (values.length > 1) {
                    return false;
                }
                return filter.acceptsValue(values[0]) && iter.acceptEntity(reference, score, values);
            }

            public boolean needsValues() {
                return true;
            }
        };
    }

    private static NodeValueIterator query(IndexReader reader, IndexQuery query) throws IndexNotApplicableKernelException {
        NodeValueIterator client = new NodeValueIterator();
        reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)client, IndexOrder.NONE, false, new IndexQuery[]{query});
        return client;
    }

    private static void assertEntityIdHits(long[] expected, LongIterator result) {
        long[] actual = PrimitiveLongCollections.asArray((LongIterator)result);
        NativeIndexAccessorTests.assertSameContent(expected, actual);
    }

    private static void assertEntityIdHits(long[] expected, Collection<Long> result) {
        long[] actual = new long[result.size()];
        int index = 0;
        for (Long aLong : result) {
            actual[index++] = aLong;
        }
        NativeIndexAccessorTests.assertSameContent(expected, actual);
    }

    private static void assertSameContent(long[] expected, long[] actual) {
        Arrays.sort(actual);
        Arrays.sort(expected);
        Assertions.assertArrayEquals((long[])expected, (long[])actual, (String)String.format("Expected arrays to be equal but wasn't.%nexpected:%s%n  actual:%s%n", Arrays.toString(expected), Arrays.toString(actual)));
    }

    private static long[] extractEntityIds(IndexEntryUpdate<?>[] updates, Predicate<Value> valueFilter) {
        long[] entityIds = new long[updates.length];
        int cursor = 0;
        for (IndexEntryUpdate<?> update : updates) {
            if (!valueFilter.test(update.values()[0])) continue;
            entityIds[cursor++] = update.getEntityId();
        }
        return Arrays.copyOf(entityIds, cursor);
    }

    private void applyUpdatesToExpectedData(Set<IndexEntryUpdate<IndexDescriptor>> expectedData, IndexEntryUpdate<IndexDescriptor>[] batch) {
        for (IndexEntryUpdate<IndexDescriptor> update : batch) {
            IndexEntryUpdate<IndexDescriptor> addition = null;
            IndexEntryUpdate<IndexDescriptor> removal = null;
            switch (update.updateMode()) {
                case ADDED: {
                    addition = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                case CHANGED: {
                    addition = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    removal = this.valueCreatorUtil.add(update.getEntityId(), update.beforeValues()[0]);
                    break;
                }
                case REMOVED: {
                    removal = this.valueCreatorUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(update.updateMode().name());
                }
            }
            if (removal != null) {
                expectedData.remove(removal);
            }
            if (addition == null) continue;
            expectedData.add(addition);
        }
    }

    private IndexEntryUpdate<IndexDescriptor>[] generateRandomUpdates(Set<IndexEntryUpdate<IndexDescriptor>> expectedData, Iterator<IndexEntryUpdate<IndexDescriptor>> newDataGenerator, int count, float removeFactor) {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[count];
        float addChangeRatio = 0.5f;
        for (int i = 0; i < count; ++i) {
            float factor = this.random.nextFloat();
            if (!expectedData.isEmpty() && factor < removeFactor) {
                IndexEntryUpdate<IndexDescriptor> toRemove = this.selectRandomItem(expectedData);
                updates[i] = IndexEntryUpdate.remove((long)toRemove.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])toRemove.values());
                continue;
            }
            if (!expectedData.isEmpty() && factor < (1.0f - removeFactor) * addChangeRatio) {
                IndexEntryUpdate<IndexDescriptor> toChange = this.selectRandomItem(expectedData);
                IndexEntryUpdate<IndexDescriptor> updateContainingValue = newDataGenerator.next();
                updates[i] = IndexEntryUpdate.change((long)toChange.getEntityId(), (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])toChange.values(), (Value[])updateContainingValue.values());
                continue;
            }
            updates[i] = newDataGenerator.next();
        }
        return updates;
    }

    private IndexEntryUpdate<IndexDescriptor> selectRandomItem(Set<IndexEntryUpdate<IndexDescriptor>> expectedData) {
        return expectedData.toArray(new IndexEntryUpdate[0])[this.random.nextInt(expectedData.size())];
    }

    @SafeVarargs
    private void processAll(IndexEntryUpdate<IndexDescriptor> ... updates) throws IndexEntryConflictException {
        try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
    }

    private void forceAndCloseAccessor() {
        this.accessor.force(IOLimiter.UNLIMITED);
        this.closeAccessor();
    }

    private static void processAll(IndexUpdater updater, IndexEntryUpdate<IndexDescriptor>[] updates) throws IndexEntryConflictException {
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            updater.process(update);
        }
    }

    private IndexEntryUpdate<IndexDescriptor> simpleUpdate() {
        return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)0)});
    }

    private IndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleType() {
        ValueType type = (ValueType)this.random.randomValues().among((Object[])this.valueCreatorUtil.supportedTypes());
        return this.valueCreatorUtil.someUpdates(this.random, new ValueType[]{type}, true);
    }

    private IndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleTypeNoDuplicates() {
        return this.someUpdatesSingleTypeNoDuplicates(this.valueCreatorUtil.supportedTypes());
    }

    private IndexEntryUpdate<IndexDescriptor>[] someUpdatesSingleTypeNoDuplicates(ValueType[] types) {
        ValueType type;
        while ((type = (ValueType)this.random.randomValues().among((Object[])types)) == ValueType.BOOLEAN) {
        }
        return this.valueCreatorUtil.someUpdates(this.random, new ValueType[]{type}, false);
    }

    private ValueType[] supportedTypesExcludingNonOrderable() {
        return RandomValues.excluding((ValueType[])this.valueCreatorUtil.supportedTypes(), t -> t.valueGroup == ValueGroup.GEOMETRY || t.valueGroup == ValueGroup.GEOMETRY_ARRAY || t == ValueType.STRING || t == ValueType.STRING_ARRAY);
    }

    private /* synthetic */ void lambda$processMustThrowAfterClose$0(IndexUpdater updater) throws Throwable {
        updater.process(this.simpleUpdate());
    }
}

