/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.neo4j.kernel.impl.locking.DumpLocksVisitor;
import org.neo4j.kernel.impl.locking.LockWorker;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;

public class LockWorkFailureDump {
    private final File file;

    public LockWorkFailureDump(File file) {
        this.file = file;
    }

    public File dumpState(Locks lm, LockWorker ... workers) throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.file, false);){
            FormattedLogProvider logProvider = FormattedLogProvider.withoutAutoFlush().toOutputStream((OutputStream)out);
            lm.accept((Locks.Visitor)new DumpLocksVisitor(logProvider.getLog(LockWorkFailureDump.class)));
            Log log = logProvider.getLog(this.getClass());
            for (LockWorker worker : workers) {
                log.info("Worker %s", new Object[]{worker});
            }
            File file = this.file;
            return file;
        }
    }
}

