/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.lang.reflect.Field;
import java.util.stream.LongStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.FieldSetter;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

class DefaultRelationshipTraversalCursorTest {
    private static final long node = 42L;
    private static final int type = 9999;
    private static final int type2 = 9998;
    private static final long relationship = 100L;
    private static final long relationshipGroup = 313L;
    private final DefaultPooledCursors pool = (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class);
    private static final Rel NO_REL = DefaultRelationshipTraversalCursorTest.rel(-1L, -1L, -1L, -1);

    DefaultRelationshipTraversalCursorTest() {
    }

    @Test
    void regularSparseTraversal() throws NoSuchFieldException {
        this.regularTraversal(100L, false);
    }

    @Test
    void regularSparseTraversalWithTxState() throws NoSuchFieldException {
        this.regularTraversalWithTxState(100L, false);
    }

    @Test
    void regularDenseTraversal() throws NoSuchFieldException {
        this.regularTraversal(313L, true);
    }

    @Test
    void regularDenseTraversalWithTxState() throws NoSuchFieldException {
        this.regularTraversalWithTxState(313L, true);
    }

    @Test
    void sparseTraversalWithTxStateFiltering() throws NoSuchFieldException {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.storeCursor(DefaultRelationshipTraversalCursorTest.rel(100L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(102L, 42L, 51L, 9999), DefaultRelationshipTraversalCursorTest.rel(104L, 42L, 52L, 9999));
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(4L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 42L, 50L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 42L, 52L, 9999));
        cursor.init(42L, 100L, -1, null, true, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 100L, 3L, 7L, 102L, 104L);
    }

    @Test
    void sparseTraversalWithFiltering() throws NoSuchFieldException {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.storeCursor(DefaultRelationshipTraversalCursorTest.rel(100L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(103L, 51L, 42L, 9999));
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(4L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 42L, 50L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 42L, 52L, 9999));
        cursor.init(42L, 100L, -1, null, false, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 100L, 4L, 103L);
    }

    @Test
    void emptyStoreOutgoingOfType() throws NoSuchFieldException {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.emptyStoreCursor();
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(4L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 42L, 50L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 42L, 52L, 9999));
        cursor.init(42L, 100L, 9999, RelationshipDirection.OUTGOING, false, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 3L, 7L);
    }

    @Test
    void emptyStoreIncomingOfType() throws NoSuchFieldException {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.emptyStoreCursor();
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(4L, 50L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 50L, 42L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 56L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(8L, 42L, 52L, 9999));
        cursor.init(42L, 100L, 9999, RelationshipDirection.INCOMING, false, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 4L, 7L);
    }

    @Test
    void emptyStoreLoopsOfType() throws NoSuchFieldException {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.emptyStoreCursor();
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(DefaultRelationshipTraversalCursorTest.rel(3L, 42L, 50L, 9999), DefaultRelationshipTraversalCursorTest.rel(2L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(5L, 50L, 42L, 9998), DefaultRelationshipTraversalCursorTest.rel(6L, 42L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(7L, 56L, 42L, 9999), DefaultRelationshipTraversalCursorTest.rel(8L, 42L, 52L, 9999));
        cursor.init(42L, 100L, 9999, RelationshipDirection.LOOP, false, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 2L, 6L);
    }

    private void regularTraversal(long reference, boolean dense) throws NoSuchFieldException {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.storeCursor(100L, 102L, 104L);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.emptyTxState();
        cursor.init(42L, reference, dense, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 100L, 102L, 104L);
    }

    private void regularTraversalWithTxState(long reference, boolean dense) throws NoSuchFieldException {
        StorageRelationshipTraversalCursor storeCursor = DefaultRelationshipTraversalCursorTest.storeCursor(100L, 102L, 104L);
        DefaultRelationshipTraversalCursor cursor = new DefaultRelationshipTraversalCursor(arg_0 -> ((DefaultPooledCursors)this.pool).accept(arg_0), storeCursor, (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class));
        Read read = DefaultRelationshipTraversalCursorTest.txState(3L, 4L);
        cursor.init(42L, reference, dense, read);
        DefaultRelationshipTraversalCursorTest.assertRelationships(cursor, 3L, 4L, 100L, 102L, 104L);
    }

    private static Read emptyTxState() throws NoSuchFieldException {
        Read read = (Read)Mockito.mock(Read.class);
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        FieldSetter.setField((Object)read, (Field)Read.class.getDeclaredField("ktx"), (Object)ktx);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        return read;
    }

    private static Read txState(long ... ids) throws NoSuchFieldException {
        return DefaultRelationshipTraversalCursorTest.txState((Rel[])LongStream.of(ids).mapToObj(id -> DefaultRelationshipTraversalCursorTest.rel(id, 42L, 42L, 9999)).toArray(Rel[]::new));
    }

    private static Read txState(Rel ... rels) throws NoSuchFieldException {
        Read read = (Read)Mockito.mock(Read.class);
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        FieldSetter.setField((Object)read, (Field)Read.class.getDeclaredField("ktx"), (Object)ktx);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        if (rels.length > 0) {
            TxState txState = new TxState();
            for (Rel rel : rels) {
                txState.relationshipDoCreate(rel.relId, rel.type, rel.sourceId, rel.targetId);
            }
            Mockito.when((Object)read.hasTxStateWithChanges()).thenReturn((Object)true);
            Mockito.when((Object)read.txState()).thenReturn((Object)txState);
        }
        return read;
    }

    private static void assertRelationships(DefaultRelationshipTraversalCursor cursor, long ... expected) {
        for (long expectedId : expected) {
            Assertions.assertTrue((boolean)cursor.next(), (String)("Expected relationship " + expectedId + " but got none"));
            Assertions.assertEquals((long)expectedId, (long)cursor.relationshipReference(), (String)("Expected relationship " + expectedId + " got " + cursor.relationshipReference()));
        }
        Assertions.assertFalse((boolean)cursor.next(), (String)("Expected no more relationships, but got " + cursor.relationshipReference()));
    }

    private static Rel rel(long relId, long startId, long endId, int type) {
        return new Rel(relId, startId, endId, type);
    }

    private static StorageRelationshipTraversalCursor emptyStoreCursor() {
        return DefaultRelationshipTraversalCursorTest.storeCursor(new Rel[0]);
    }

    private static StorageRelationshipTraversalCursor storeCursor(long ... ids) {
        return DefaultRelationshipTraversalCursorTest.storeCursor((Rel[])LongStream.of(ids).mapToObj(id -> DefaultRelationshipTraversalCursorTest.rel(id, -1L, -1L, -1)).toArray(Rel[]::new));
    }

    private static StorageRelationshipTraversalCursor storeCursor(final Rel ... rels) {
        return new StorageRelationshipTraversalCursor(){
            private int i = -1;
            private Rel rel = NO_REL;

            public long neighbourNodeReference() {
                return this.rel.sourceId == 42L ? this.rel.targetId : this.rel.sourceId;
            }

            public long originNodeReference() {
                return 42L;
            }

            public void init(long nodeReference, long reference, boolean nodeIsDense) {
            }

            public void init(long nodeReference, long reference, int type, RelationshipDirection direction, boolean nodeIsDense) {
            }

            public int type() {
                return this.rel.type;
            }

            public long sourceNodeReference() {
                return this.rel.sourceId;
            }

            public long targetNodeReference() {
                return this.rel.targetId;
            }

            public boolean hasProperties() {
                throw new UnsupportedOperationException("not implemented");
            }

            public long propertiesReference() {
                throw new UnsupportedOperationException("not implemented");
            }

            public void properties(StoragePropertyCursor propertyCursor) {
                throw new UnsupportedOperationException("not implemented");
            }

            public long entityReference() {
                return this.rel.relId;
            }

            public boolean next() {
                ++this.i;
                if (this.i < 0 || this.i >= rels.length) {
                    this.rel = NO_REL;
                    return false;
                }
                this.rel = rels[this.i];
                return true;
            }

            public void reset() {
            }

            public void close() {
            }
        };
    }

    private static class Rel {
        final long relId;
        final long sourceId;
        final long targetId;
        final int type;

        Rel(long relId, long sourceId, long targetId, int type) {
            this.relId = relId;
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.type = type;
        }
    }
}

