/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.common.ProgressReporter;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.time.FakeClock;

class VisibleMigrationProgressMonitorTest {
    VisibleMigrationProgressMonitorTest() {
    }

    @Test
    void shouldReportAllPercentageSteps() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.started(1);
        this.monitorSection(monitor, "First", 100, 40, 25, 23, 10, 50);
        monitor.completed();
        this.verifySectionReportedCorrectly(logProvider);
    }

    @Test
    void progressNeverReportMoreThenHundredPercent() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.started(1);
        this.monitorSection(monitor, "First", 100, 1, 10, 99, 170);
        monitor.completed();
        this.verifySectionReportedCorrectly(logProvider);
    }

    @Test
    void reportStartStopOftransactionLogsMigration() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.startTransactionLogsMigration();
        monitor.completeTransactionLogsMigration();
        logProvider.rawMessageMatcher().assertContains("Starting transaction logs migration.");
        logProvider.rawMessageMatcher().assertContains("Transaction logs migration completed.");
    }

    @Test
    void shouldIncludeDurationInCompletionMessage() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        FakeClock clock = new FakeClock();
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log, (Clock)clock);
        monitor.started(1);
        clock.forward(1500L, TimeUnit.MILLISECONDS);
        monitor.completed();
        logProvider.formattedMessageMatcher().assertContains("took 1s 500ms");
    }

    private void verifySectionReportedCorrectly(AssertableLogProvider logProvider) {
        logProvider.formattedMessageMatcher().assertContains("Starting upgrade of database");
        for (int i = 10; i <= 100; i += 10) {
            logProvider.formattedMessageMatcher().assertContains(i + "%");
        }
        logProvider.assertNone(AssertableLogProvider.inLog(VisibleMigrationProgressMonitor.class).info(Matchers.containsString((String)"110%")));
        logProvider.formattedMessageMatcher().assertContains("Successfully finished upgrade of database");
    }

    private void monitorSection(VisibleMigrationProgressMonitor monitor, String name, int max, int ... steps) {
        ProgressReporter progressReporter = monitor.startSection(name);
        progressReporter.start((long)max);
        for (int step : steps) {
            progressReporter.progress((long)step);
        }
        progressReporter.completed();
    }
}

