/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.List;
import java.util.function.IntPredicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.NodeLabelUpdate;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;

class LabelScanViewNodeStoreScanTest {
    private final StubStorageCursors cursors = new StubStorageCursors();
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final LabelScanReader labelScanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
    private final IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private final Visitor<NodeLabelUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final Visitor<EntityUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);

    LabelScanViewNodeStoreScanTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)this.labelScanReader);
    }

    @Test
    void iterateOverLabeledNodeIds() {
        PrimitiveLongResourceIterator labeledNodes = PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L, 2L, 4L, 8L});
        long highId = 15L;
        for (long i = 0L; i < highId; ++i) {
            this.cursors.withNode(i);
        }
        int[] labelIds = new int[]{1, 2};
        Mockito.when((Object)this.labelScanReader.nodesWithAnyOfLabels(labelIds)).thenReturn((Object)labeledNodes);
        LabelScanViewNodeStoreScan<Exception> storeScan = this.getLabelScanViewStoreScan(labelIds);
        EntityIdIterator idIterator = storeScan.getEntityIdIterator();
        List visitedNodeIds = PrimitiveLongCollections.asList((LongIterator)idIterator);
        MatcherAssert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)visitedNodeIds, (Matcher)Matchers.hasItems((Object[])new Long[]{1L, 2L, 4L, 8L}));
    }

    private LabelScanViewNodeStoreScan<Exception> getLabelScanViewStoreScan(int[] labelIds) {
        return new LabelScanViewNodeStoreScan((StorageReader)this.cursors, LockService.NO_LOCK_SERVICE, this.labelScanStore, this.labelUpdateVisitor, this.propertyUpdateVisitor, labelIds, this.propertyKeyIdFilter);
    }
}

