/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.collection.ContinuableArrayCursor;

class ContinuableArrayCursorTest {
    ContinuableArrayCursorTest() {
    }

    @Test
    void shouldNotReturnAnyElementOnEmptySupplier() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(() -> null);
        Assertions.assertFalse((boolean)cursor.next());
    }

    @Test
    void shouldNotReturnAnyElementOnSupplierWithOneEmptyArray() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(new Integer[0]));
        Assertions.assertFalse((boolean)cursor.next());
    }

    @Test
    void shouldMoveCursorOverSingleArray() {
        Integer[] array = new Integer[]{1, 2, 3};
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(array));
        this.assertCursor(cursor, new Object[][]{array});
    }

    @Test
    void shouldMoveCursorOverMultipleArrays() {
        Object[][] arrays = new Integer[][]{{1, 2, 3}, {4, 5, 6}, {7}};
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply((Integer[][])arrays));
        this.assertCursor(cursor, arrays);
    }

    @Test
    void callGetBeforeNextShouldThrowIllegalStateException() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(new Integer[0]));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ContinuableArrayCursor)cursor).get());
    }

    @Test
    void callGetAfterNextReturnsFalseShouldThrowIllegalStateException() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(new Integer[0]));
        Assertions.assertFalse((boolean)cursor.next());
        Assertions.assertThrows(IllegalStateException.class, () -> ((ContinuableArrayCursor)cursor).get());
    }

    private Supplier<Integer[]> supply(Integer[] array) {
        return this.supply(new Integer[][]{array});
    }

    private Supplier<Integer[]> supply(Integer[][] arrays) {
        Iterator iterator = Arrays.asList(arrays).iterator();
        return () -> iterator.hasNext() ? (Integer[])iterator.next() : null;
    }

    private void assertCursor(ContinuableArrayCursor<?> cursor, Object[] ... arrays) {
        Object[][] objectArray = arrays;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] array;
            for (Object obj : array = objectArray[i]) {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertEquals((Object)obj, (Object)cursor.get());
            }
        }
        Assertions.assertFalse((boolean)cursor.next());
    }
}

