/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.dump;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.proc.ProcessUtil;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.dump.DumpProcessInformation;
import org.neo4j.test.rule.dump.DumpableProcess;

@TestDirectoryExtension
class DumpProcessInformationTest {
    private static final String SIGNAL = "here";
    @Inject
    private TestDirectory testDirectory;

    DumpProcessInformationTest() {
    }

    @BeforeEach
    void checkEnvironment() {
        Assumptions.assumeTrue((boolean)DumpProcessInformationTest.commandExists("jps"));
        Assumptions.assumeTrue((boolean)DumpProcessInformationTest.commandExists("jstack -h"));
    }

    private static boolean commandExists(String command) {
        try {
            return Runtime.getRuntime().exec(command).waitFor() == 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Test
    void shouldDumpProcessInformation() throws Exception {
        File directory = this.testDirectory.directory("dump", new String[0]);
        String java = ProcessUtil.getJavaExecutable().toString();
        Process process = Runtime.getRuntime().exec(new String[]{java, "-cp", ProcessUtil.getClassPath(), DumpableProcess.class.getName(), SIGNAL});
        DumpProcessInformationTest.awaitSignal(process);
        DumpProcessInformation dumper = new DumpProcessInformation((LogProvider)NullLogProvider.getInstance(), directory);
        Collection<Pair<Long, String>> pids = dumper.getJPids((Matcher<String>)Matchers.containsString((String)DumpableProcess.class.getSimpleName()));
        Assumptions.assumeTrue((!pids.isEmpty() ? 1 : 0) != 0);
        Pair pid = (Pair)Iterables.single(pids);
        File threaddumpFile = dumper.doThreadDump((Pair<Long, String>)pid);
        process.destroy();
        Assertions.assertTrue((boolean)DumpProcessInformationTest.fileContains(threaddumpFile, "traceableMethod", DumpableProcess.class.getName()));
    }

    private static boolean fileContains(File file, String ... expectedStrings) throws IOException {
        Set expectedStringSet = Iterators.asSet((Object[])expectedStrings);
        try (Stream<String> lines = Files.lines(file.toPath());){
            lines.forEach(line -> expectedStringSet.removeIf(line::contains));
        }
        return expectedStringSet.isEmpty();
    }

    private static void awaitSignal(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            if (!SIGNAL.equals(line)) {
                Assertions.fail((String)("Got weird signal " + line));
            }
        }
    }
}

