/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.state.storeview.DefaultNodePropertyAccessor;
import org.neo4j.lock.ResourceType;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ConstraintIndexCreator {
    private final IndexingService indexingService;
    private final Supplier<Kernel> kernelSupplier;
    private final Log log;

    public ConstraintIndexCreator(Supplier<Kernel> kernelSupplier, IndexingService indexingService, LogProvider logProvider) {
        this.kernelSupplier = kernelSupplier;
        this.indexingService = indexingService;
        this.log = logProvider.getLog(ConstraintIndexCreator.class);
    }

    public IndexDescriptor createUniquenessConstraintIndex(KernelTransactionImplementation transaction, IndexBackedConstraintDescriptor constraint, IndexPrototype prototype) throws TransactionFailureException, CreateConstraintFailureException, UniquePropertyValueValidationException, AlreadyConstrainedException {
        IndexDescriptor index;
        SchemaDescriptor schema = constraint.schema();
        this.log.info("Starting constraint creation: %s.", new Object[]{constraint});
        SchemaRead schemaRead = transaction.schemaRead();
        try {
            index = this.checkAndCreateConstraintIndex(schemaRead, (TokenNameLookup)transaction.tokenRead(), constraint, prototype);
        }
        catch (AlreadyConstrainedException e) {
            throw e;
        }
        catch (KernelException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, (Throwable)e);
        }
        boolean success = false;
        boolean reacquiredLabelLock = false;
        Locks.Client locks = transaction.statementLocks().pessimistic();
        ResourceType keyType = schema.keyType();
        long[] lockingKeys = schema.lockingKeys();
        try {
            locks.acquireShared(transaction.lockTracer(), keyType, lockingKeys);
            IndexProxy proxy = this.indexingService.getIndexProxy(index);
            locks.releaseExclusive(keyType, lockingKeys);
            this.awaitConstraintIndexPopulation(constraint, proxy, transaction);
            this.log.info("Constraint %s populated, starting verification.", new Object[]{constraint.schema()});
            locks.acquireExclusive(transaction.lockTracer(), keyType, lockingKeys);
            reacquiredLabelLock = true;
            try (DefaultNodePropertyAccessor propertyAccessor = new DefaultNodePropertyAccessor(transaction.newStorageReader(), transaction.pageCursorTracer(), transaction.memoryTracker());){
                this.indexingService.getIndexProxy(index).verifyDeferredConstraints(propertyAccessor);
            }
            this.log.info("Constraint %s verified.", new Object[]{constraint.schema()});
            success = true;
            IndexDescriptor indexDescriptor = index;
            return indexDescriptor;
        }
        catch (IndexNotFoundKernelException e) {
            throw new TransactionFailureException(String.format("Index (%s) that we just created does not exist.", schema), (Throwable)e);
        }
        catch (IndexEntryConflictException e) {
            throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VERIFICATION, e, (TokenNameLookup)transaction.tokenRead());
        }
        catch (IOException | InterruptedException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, (Throwable)e);
        }
        finally {
            if (!success) {
                if (!reacquiredLabelLock) {
                    locks.acquireExclusive(transaction.lockTracer(), keyType, lockingKeys);
                }
                if (this.indexStillExists(schemaRead, index)) {
                    this.dropUniquenessConstraintIndex(index);
                }
            }
        }
    }

    private boolean indexStillExists(SchemaRead schemaRead, IndexDescriptor index) {
        IndexDescriptor existingIndex = schemaRead.indexGetForName(index.getName());
        return existingIndex != IndexDescriptor.NO_INDEX && existingIndex.equals((Object)index);
    }

    public void dropUniquenessConstraintIndex(IndexDescriptor index) throws TransactionFailureException {
        try (KernelTransaction transaction = this.kernelSupplier.get().beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)SecurityContext.AUTH_DISABLED);){
            ((KernelTransactionImplementation)transaction).addIndexDoDropToTxState(index);
            transaction.commit();
        }
    }

    private void awaitConstraintIndexPopulation(IndexBackedConstraintDescriptor constraint, IndexProxy proxy, KernelTransactionImplementation transaction) throws InterruptedException, UniquePropertyValueValidationException {
        try {
            boolean stillGoing;
            do {
                stillGoing = proxy.awaitStoreScanCompleted(1L, TimeUnit.SECONDS);
                if (!transaction.isTerminated()) continue;
                Optional<Status> reasonIfTerminated = transaction.getReasonIfTerminated();
                assert (reasonIfTerminated.isPresent());
                throw new TransactionTerminatedException(reasonIfTerminated.get());
            } while (stillGoing);
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VERIFICATION, (IndexEntryConflictException)cause, (TokenNameLookup)transaction.tokenRead());
            }
            throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VERIFICATION, (Throwable)((Object)e), (TokenNameLookup)transaction.tokenRead());
        }
    }

    private IndexDescriptor checkAndCreateConstraintIndex(SchemaRead schemaRead, TokenNameLookup tokenLookup, IndexBackedConstraintDescriptor constraint, IndexPrototype prototype) throws KernelException {
        IndexDescriptor descriptor = schemaRead.indexGetForName(constraint.getName());
        if (descriptor != IndexDescriptor.NO_INDEX) {
            if (descriptor.isUnique()) {
                throw new AlreadyConstrainedException((ConstraintDescriptor)constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, tokenLookup);
            }
            throw new AlreadyIndexedException(constraint.schema(), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, tokenLookup);
        }
        return this.createConstraintIndex(prototype);
    }

    public IndexDescriptor createConstraintIndex(IndexPrototype prototype) throws KernelException {
        try (KernelTransaction transaction = this.kernelSupplier.get().beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)SecurityContext.AUTH_DISABLED);){
            IndexDescriptor index = transaction.indexUniqueCreate(prototype);
            transaction.commit();
            IndexDescriptor indexDescriptor = index;
            return indexDescriptor;
        }
    }
}

