/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnspecifiedKernelException;
import org.neo4j.function.ThrowingIntFunction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.EquivalentSchemaRuleAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedSchemaComponentException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DetachingRelationshipDeleter;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Write,
SchemaWrite {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;
    private final StorageReader storageReader;
    private final CommandCreationContext commandCreationContext;
    private final KernelToken token;
    private final IndexTxStateUpdater updater;
    private final DefaultPooledCursors cursors;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final ConstraintSemantics constraintSemantics;
    private final IndexingProvidersService indexProviders;
    private final Config config;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;
    private DefaultNodeCursor nodeCursor;
    private DefaultNodeCursor restrictedNodeCursor;
    private DefaultPropertyCursor propertyCursor;
    private DefaultPropertyCursor restrictedPropertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;

    public Operations(AllStoreHolder allStoreHolder, StorageReader storageReader, IndexTxStateUpdater updater, CommandCreationContext commandCreationContext, KernelTransactionImplementation ktx, KernelToken token, DefaultPooledCursors cursors, ConstraintIndexCreator constraintIndexCreator, ConstraintSemantics constraintSemantics, IndexingProvidersService indexProviders, Config config, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.storageReader = storageReader;
        this.commandCreationContext = commandCreationContext;
        this.token = token;
        this.allStoreHolder = allStoreHolder;
        this.ktx = ktx;
        this.updater = updater;
        this.cursors = cursors;
        this.constraintIndexCreator = constraintIndexCreator;
        this.constraintSemantics = constraintSemantics;
        this.indexProviders = indexProviders;
        this.config = config;
        this.cursorTracer = cursorTracer;
        this.memoryTracker = memoryTracker;
    }

    public void initialize() {
        this.nodeCursor = this.cursors.allocateFullAccessNodeCursor(this.cursorTracer);
        this.propertyCursor = this.cursors.allocateFullAccessPropertyCursor(this.cursorTracer, this.memoryTracker);
        this.relationshipCursor = this.cursors.allocateRelationshipScanCursor(this.cursorTracer);
        this.restrictedNodeCursor = this.cursors.allocateNodeCursor(this.cursorTracer);
        this.restrictedPropertyCursor = this.cursors.allocatePropertyCursor(this.cursorTracer, this.memoryTracker);
    }

    public long nodeCreate() {
        this.assertAllowsCreateNode(null);
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        long nodeId = this.commandCreationContext.reserveNode();
        txState.nodeDoCreate(nodeId);
        return nodeId;
    }

    public long nodeCreateWithLabels(int[] labels) throws ConstraintValidationException {
        if (labels == null || labels.length == 0) {
            return this.nodeCreate();
        }
        this.assertAllowsCreateNode(labels);
        this.ktx.assertOpen();
        int labelCount = labels.length;
        long[] lockingIds = new long[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            lockingIds[i] = labels[i];
        }
        Arrays.sort(lockingIds);
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), (ResourceType)ResourceTypes.LABEL, lockingIds);
        TransactionState txState = this.ktx.txState();
        long nodeId = this.commandCreationContext.reserveNode();
        txState.nodeDoCreate(nodeId);
        this.nodeCursor.single(nodeId, this.allStoreHolder);
        this.nodeCursor.next();
        int prevLabel = -1;
        for (long lockingId : lockingIds) {
            int label = (int)lockingId;
            if (label == prevLabel) continue;
            this.checkConstraintsAndAddLabelToNode(nodeId, label);
            prevLabel = label;
        }
        return nodeId;
    }

    public boolean nodeDelete(long node) {
        this.ktx.assertOpen();
        return this.nodeDelete(node, true);
    }

    public int nodeDetachDelete(long nodeId) {
        this.ktx.assertOpen();
        DetachingRelationshipDeleter deleter = new DetachingRelationshipDeleter(relId -> this.relationshipDelete(relId, false));
        int deletedRelationships = deleter.lockNodesAndDeleteRelationships(nodeId, this.ktx);
        this.nodeDelete(nodeId, false);
        return deletedRelationships;
    }

    public long relationshipCreate(long sourceNode, int relationshipType, long targetNode) throws EntityNotFoundException {
        this.assertAllowsCreateRelationship(relationshipType);
        this.ktx.assertOpen();
        this.sharedSchemaLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, relationshipType);
        this.lockRelationshipNodes(sourceNode, targetNode);
        this.assertNodeExists(sourceNode);
        this.assertNodeExists(targetNode);
        TransactionState txState = this.ktx.txState();
        long id = this.commandCreationContext.reserveRelationship();
        txState.relationshipDoCreate(id, relationshipType, sourceNode, targetNode);
        return id;
    }

    public boolean relationshipDelete(long relationship) {
        this.ktx.assertOpen();
        return this.relationshipDelete(relationship, true);
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException, ConstraintValidationException {
        this.sharedSchemaLock((ResourceType)ResourceTypes.LABEL, nodeLabel);
        this.acquireExclusiveNodeLock(node);
        this.singleNode(node);
        if (this.nodeCursor.hasLabel(nodeLabel)) {
            return false;
        }
        LongSet removed = this.ktx.txState().nodeStateLabelDiffSets(node).getRemoved();
        if (!removed.contains((long)nodeLabel)) {
            this.assertAllowsSetLabel(nodeLabel);
        }
        this.checkConstraintsAndAddLabelToNode(node, nodeLabel);
        return true;
    }

    private void checkConstraintsAndAddLabelToNode(long node, int nodeLabel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        int[] existingPropertyKeyIds = this.loadSortedPropertyKeyList();
        if (existingPropertyKeyIds.length > 0) {
            for (IndexBackedConstraintDescriptor uniquenessConstraint : this.storageReader.uniquenessConstraintsGetRelated(new long[]{nodeLabel}, existingPropertyKeyIds, EntityType.NODE)) {
                IndexQuery.ExactPredicate[] propertyValues = this.getAllPropertyValues(uniquenessConstraint.schema(), -1, Values.NO_VALUE);
                if (propertyValues == null) continue;
                this.validateNoExistingNodeWithExactValues(uniquenessConstraint, propertyValues, node);
            }
        }
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, existingPropertyKeyIds, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
    }

    private int[] loadSortedPropertyKeyList() {
        this.nodeCursor.properties(this.propertyCursor);
        if (!this.propertyCursor.next()) {
            return EMPTY_INT_ARRAY;
        }
        int[] propertyKeyIds = new int[4];
        int cursor = 0;
        do {
            if (cursor == propertyKeyIds.length) {
                propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor * 2);
            }
            propertyKeyIds[cursor++] = this.propertyCursor.propertyKey();
        } while (this.propertyCursor.next());
        if (cursor != propertyKeyIds.length) {
            propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor);
        }
        Arrays.sort(propertyKeyIds);
        return propertyKeyIds;
    }

    private boolean nodeDelete(long node, boolean lock) {
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            TransactionState state = this.ktx.txState();
            if (state.nodeIsAddedInThisTx(node)) {
                state.nodeDoDelete(node);
                return true;
            }
            if (state.nodeIsDeletedInThisTx(node)) {
                return false;
            }
        }
        if (lock) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.NODE, node);
        }
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (this.nodeCursor.next()) {
            this.acquireSharedNodeLabelLocks();
            this.assertAllowsDeleteNode(this.nodeCursor::labels);
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    private long[] acquireSharedNodeLabelLocks() {
        long[] labels = this.nodeCursor.labels().all();
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), (ResourceType)ResourceTypes.LABEL, labels);
        return labels;
    }

    private boolean relationshipDelete(long relationship, boolean lock) {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (this.relationshipCursor.next()) {
            if (lock) {
                this.lockRelationshipNodes(this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
                this.acquireExclusiveRelationshipLock(relationship);
            }
            if (!this.allStoreHolder.relationshipExists(relationship)) {
                return false;
            }
            this.ktx.assertOpen();
            TransactionState txState = this.ktx.txState();
            if (txState.relationshipIsAddedInThisTx(relationship)) {
                txState.relationshipDoDeleteAddedInThisTx(relationship);
            } else {
                this.assertAllowsDeleteRelationship(this.relationshipCursor.type());
                txState.relationshipDoDelete(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
            }
            return true;
        }
        return false;
    }

    private void singleNode(long node) throws EntityNotFoundException {
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
    }

    private void singleRelationship(long relationship) throws EntityNotFoundException {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
    }

    private IndexQuery.ExactPredicate[] getAllPropertyValues(SchemaDescriptor schema, int changedPropertyKeyId, Value changedValue) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        IndexQuery.ExactPredicate[] values = new IndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        this.nodeCursor.properties(this.propertyCursor);
        while (this.propertyCursor.next()) {
            int nodePropertyId = this.propertyCursor.propertyKey();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)nodePropertyId);
            if (k2 < 0) continue;
            if (nodePropertyId != -1) {
                values[k2] = IndexQuery.exact((int)nodePropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = IndexQuery.exact((int)changedPropertyKeyId, (Object)changedValue);
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(IndexBackedConstraintDescriptor constraint, IndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        IndexDescriptor index = this.allStoreHolder.indexGetForName(constraint.getName());
        try (FullAccessNodeValueIndexCursor valueCursor = this.cursors.allocateFullAccessNodeValueIndexCursor(this.cursorTracer);
             IndexReaders indexReaders = new IndexReaders(index, this.allStoreHolder);){
            this.assertIndexOnline(index);
            SchemaDescriptor schema = index.schema();
            long[] labelIds = schema.lockingKeys();
            if (labelIds.length != 1) {
                throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)((Object)new AssertionError((Object)String.format("Constraint indexes are not expected to be multi-token indexes, but the constraint %s was referencing an index with the following schema: %s.", constraint.userDescription((TokenNameLookup)this.token), schema.userDescription((TokenNameLookup)this.token)))), (TokenNameLookup)this.token);
            }
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.INDEX_ENTRY, ResourceIds.indexEntryResourceId(labelIds[0], propertyValues));
            this.allStoreHolder.nodeIndexSeekWithFreshIndexReader(valueCursor, indexReaders.createReader(), propertyValues);
            if (valueCursor.next() && valueCursor.nodeReference() != modifiedNode) {
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(valueCursor.nodeReference(), -1L, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])propertyValues)), (TokenNameLookup)this.token);
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)e, (TokenNameLookup)this.token);
        }
    }

    private void assertIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.allStoreHolder.indexGetState(descriptor) != InternalIndexState.ONLINE) {
            throw new IndexBrokenKernelException(this.allStoreHolder.indexGetFailure(descriptor));
        }
    }

    public boolean nodeRemoveLabel(long node, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (!this.nodeCursor.hasLabel(labelId)) {
            return false;
        }
        LongSet added = this.ktx.txState().nodeStateLabelDiffSets(node).getAdded();
        if (!added.contains((long)labelId)) {
            this.assertAllowsRemoveLabel(labelId);
        }
        this.sharedSchemaLock((ResourceType)ResourceTypes.LABEL, labelId);
        this.ktx.txState().nodeDoRemoveLabel(labelId, node);
        if (this.storageReader.hasRelatedSchema(labelId, EntityType.NODE)) {
            this.updater.onLabelChange(labelId, this.loadSortedPropertyKeyList(), this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        }
        return true;
    }

    public Value nodeSetProperty(long node, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        long[] labels = this.acquireSharedNodeLabelLocks();
        Value existingValue = this.readNodeProperty(propertyKey);
        int[] existingPropertyKeyIds = null;
        boolean hasRelatedSchema = this.storageReader.hasRelatedSchema(labels, propertyKey, EntityType.NODE);
        if (hasRelatedSchema) {
            existingPropertyKeyIds = this.loadSortedPropertyKeyList();
        }
        if (!existingValue.equals(value)) {
            this.assertAllowsSetProperty(labels, (long)propertyKey);
            Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(labels, propertyKey, EntityType.NODE);
            NodeSchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), propertyKey, existingPropertyKeyIds, constraint -> this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.getAllPropertyValues(constraint.schema(), propertyKey, value), node));
        }
        if (existingValue == Values.NO_VALUE) {
            this.assertAllowsSetProperty(labels, (long)propertyKey);
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyAdd(this.nodeCursor, this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, value);
            }
            return Values.NO_VALUE;
        }
        if (Operations.propertyHasChanged(value, existingValue)) {
            this.assertAllowsSetProperty(labels, (long)propertyKey);
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyChange(this.nodeCursor, this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, existingValue, value);
            }
        }
        return existingValue;
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            long[] labels = this.acquireSharedNodeLabelLocks();
            this.assertAllowsSetProperty(labels, (long)propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey);
            if (this.storageReader.hasRelatedSchema(labels, propertyKey, EntityType.NODE)) {
                this.updater.onPropertyRemove(this.nodeCursor, this.propertyCursor, labels, propertyKey, this.loadSortedPropertyKeyList(), existingValue);
            }
        }
        return existingValue;
    }

    public Value relationshipSetProperty(long relationship, int propertyKey, Value value) throws EntityNotFoundException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.assertAllowsSetProperty(this.relationshipCursor.type(), (long)propertyKey);
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, Values.NO_VALUE, value);
            return Values.NO_VALUE;
        }
        if (Operations.propertyHasChanged(existingValue, value)) {
            this.assertAllowsSetProperty(this.relationshipCursor.type(), (long)propertyKey);
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value relationshipRemoveProperty(long relationship, int propertyKey) throws EntityNotFoundException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.assertAllowsSetProperty(this.relationshipCursor.type(), (long)propertyKey);
            this.ktx.txState().relationshipDoRemoveProperty(relationship, propertyKey);
        }
        return existingValue;
    }

    private Value readNodeProperty(int propertyKey) {
        this.nodeCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    private Value readRelationshipProperty(int propertyKey) {
        this.relationshipCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public Procedures procedures() {
        return this.allStoreHolder;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.restrictedNodeCursor != null) {
            this.restrictedNodeCursor.close();
            this.restrictedNodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
        if (this.restrictedPropertyCursor != null) {
            this.restrictedPropertyCursor.close();
            this.restrictedPropertyCursor = null;
        }
        this.cursors.assertClosed();
        this.cursors.release();
    }

    public Token token() {
        return this.token;
    }

    public SchemaRead schemaRead() {
        return this.allStoreHolder;
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public DefaultNodeCursor nodeCursor() {
        return this.restrictedNodeCursor;
    }

    public DefaultRelationshipScanCursor relationshipCursor() {
        return this.relationshipCursor;
    }

    public DefaultPropertyCursor propertyCursor() {
        return this.restrictedPropertyCursor;
    }

    public IndexProviderDescriptor indexProviderByName(String providerName) {
        this.ktx.assertOpen();
        return this.indexProviders.indexProviderByName(providerName);
    }

    public IndexDescriptor indexCreate(IndexPrototype prototype) throws KernelException {
        this.exclusiveSchemaLock(prototype.schema());
        this.ktx.assertOpen();
        this.assertValidDescriptor(prototype.schema(), SchemaKernelException.OperationContext.INDEX_CREATION);
        prototype = this.ensureIndexPrototypeHasName(prototype);
        prototype = this.ensureIndexPrototypeHasIndexProvider(prototype);
        Optional nameOptional = prototype.getName();
        assert (nameOptional.isPresent());
        String name = (String)nameOptional.get();
        this.exclusiveSchemaNameLock(name);
        this.assertNoBlockingSchemaRulesExists(prototype);
        return this.indexDoCreate(prototype);
    }

    public IndexDescriptor indexCreate(SchemaDescriptor schema, String indexName) throws KernelException {
        return this.indexCreate(schema, (String)this.config.get(GraphDatabaseSettings.default_schema_provider), indexName);
    }

    public IndexDescriptor indexCreate(SchemaDescriptor schema, String provider, String name) throws KernelException {
        IndexProviderDescriptor providerDescriptor = this.indexProviders.indexProviderByName(provider);
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName(name);
        return this.indexCreate(prototype);
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) {
        return this.indexDoCreate(prototype);
    }

    private IndexDescriptor indexDoCreate(IndexPrototype prototype) {
        this.indexProviders.validateIndexPrototype(prototype);
        TransactionState transactionState = this.ktx.txState();
        long schemaRecordId = this.commandCreationContext.reserveSchema();
        IndexDescriptor index = prototype.materialise(schemaRecordId);
        index = this.indexProviders.completeConfiguration(index);
        transactionState.indexDoAdd(index);
        return index;
    }

    private IndexPrototype ensureIndexPrototypeHasName(IndexPrototype prototype) throws KernelException {
        if (prototype.getName().isEmpty()) {
            String[] entityTokenNames;
            SchemaDescriptor schema = prototype.schema();
            int[] entityTokenIds = schema.getEntityTokenIds();
            switch (schema.entityType()) {
                case NODE: {
                    entityTokenNames = this.resolveTokenNames(this.token::nodeLabelName, entityTokenIds);
                    break;
                }
                case RELATIONSHIP: {
                    entityTokenNames = this.resolveTokenNames(this.token::relationshipTypeName, entityTokenIds);
                    break;
                }
                default: {
                    throw new UnspecifiedKernelException((Status)Status.General.UnknownError, "Cannot create index for entity type %s in the schema %s.", new Object[]{schema.entityType(), schema});
                }
            }
            int[] propertyIds = schema.getPropertyIds();
            String[] propertyNames = this.resolveTokenNames(this.token::propertyKeyName, propertyIds);
            prototype = prototype.withName(SchemaRule.generateName((SchemaDescriptorSupplier)prototype, (String[])entityTokenNames, (String[])propertyNames));
        }
        return prototype;
    }

    private <E extends Exception> String[] resolveTokenNames(ThrowingIntFunction<String, E> resolver, int[] tokenIds) throws E {
        String[] names = new String[tokenIds.length];
        for (int i = 0; i < tokenIds.length; ++i) {
            names[i] = (String)resolver.apply(tokenIds[i]);
        }
        return names;
    }

    private IndexPrototype ensureIndexPrototypeHasIndexProvider(IndexPrototype prototype) {
        if (prototype.getIndexProvider() == IndexProviderDescriptor.UNDECIDED) {
            IndexProviderDescriptor provider = prototype.getIndexType() == IndexType.FULLTEXT ? this.indexProviders.getFulltextProvider() : this.indexProviders.getDefaultProvider();
            prototype = prototype.withIndexProvider(provider);
        }
        return prototype;
    }

    public void indexDrop(IndexDescriptor index) throws SchemaKernelException {
        if (index == IndexDescriptor.NO_INDEX) {
            throw new DropIndexFailureException("No index was specified.");
        }
        this.exclusiveSchemaLock(index.schema());
        this.exclusiveSchemaNameLock(index.getName());
        this.assertIndexExistsForDrop(index);
        if (index.isUnique() && this.allStoreHolder.indexGetOwningUniquenessConstraintId(index) != null) {
            IndexBelongsToConstraintException cause = new IndexBelongsToConstraintException(index.schema());
            throw new DropIndexFailureException("Unable to drop index: " + cause.getUserMessage((TokenNameLookup)this.token), (Throwable)((Object)cause));
        }
        this.ktx.txState().indexDoDrop(index);
    }

    private void assertIndexExistsForDrop(IndexDescriptor index) throws DropIndexFailureException {
        try {
            this.allStoreHolder.assertIndexExists(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new DropIndexFailureException("Unable to drop index: " + e.getUserMessage((TokenNameLookup)this.token), e);
        }
    }

    public void indexDrop(SchemaDescriptor schema) throws SchemaKernelException {
        this.exclusiveSchemaLock(schema);
        Iterator iterator = Iterators.filter(index -> index.getIndexType() == IndexType.BTREE, this.allStoreHolder.index(schema));
        if (!iterator.hasNext()) {
            String description = schema.userDescription((TokenNameLookup)this.token);
            throw new DropIndexFailureException("Unable to drop index on " + description + ". There is no such index.");
        }
        do {
            IndexDescriptor existingIndex = (IndexDescriptor)iterator.next();
            this.indexDrop(existingIndex);
        } while (iterator.hasNext());
    }

    public void indexDrop(String indexName) throws SchemaKernelException {
        this.exclusiveSchemaNameLock(indexName);
        IndexDescriptor index = this.allStoreHolder.indexGetForName(indexName);
        if (index == IndexDescriptor.NO_INDEX) {
            throw new DropIndexFailureException("Unable to drop index called `" + indexName + "`. There is no such index.");
        }
        this.exclusiveSchemaLock(index.schema());
        this.assertIndexExistsForDrop(index);
        if (index.isUnique() && this.allStoreHolder.indexGetOwningUniquenessConstraintId(index) != null) {
            IndexBelongsToConstraintException cause = new IndexBelongsToConstraintException(indexName, index.schema());
            throw new DropIndexFailureException("Unable to drop index: " + cause.getUserMessage((TokenNameLookup)this.token), (Throwable)((Object)cause));
        }
        this.ktx.txState().indexDoDrop(index);
    }

    public ConstraintDescriptor uniquePropertyConstraintCreate(IndexPrototype prototype) throws KernelException {
        SchemaDescriptor schema = prototype.schema();
        this.exclusiveSchemaLock(schema);
        this.ktx.assertOpen();
        prototype = this.ensureIndexPrototypeHasIndexProvider(prototype);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
        try {
            this.assertValidDescriptor(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            if (prototype.getName().isEmpty()) {
                constraint = this.ensureConstraintHasName(constraint);
                prototype = prototype.withName(constraint.getName());
            } else {
                constraint = constraint.withName((String)prototype.getName().get());
            }
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
        }
        catch (KernelException e) {
            this.exclusiveSchemaUnlock(schema);
            throw e;
        }
        constraint = this.indexBackedConstraintCreate(constraint, prototype);
        return constraint;
    }

    private void assertNoBlockingSchemaRulesExists(IndexPrototype prototype) throws EquivalentSchemaRuleAlreadyExistsException, IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException, AlreadyIndexedException, AlreadyConstrainedException {
        Optional prototypeName = prototype.getName();
        if (prototypeName.isEmpty()) {
            throw new IllegalStateException("Expected index to always have a name by this point");
        }
        String name = (String)prototypeName.get();
        IndexDescriptor indexWithSameSchema = IndexDescriptor.NO_INDEX;
        Iterator<IndexDescriptor> indexesWithSameSchema = this.allStoreHolder.index(prototype.schema());
        while (indexesWithSameSchema.hasNext()) {
            indexWithSameSchema = indexesWithSameSchema.next();
            if (!indexWithSameSchema.getName().equals(name) || indexWithSameSchema.isUnique() != prototype.isUnique()) continue;
            throw new EquivalentSchemaRuleAlreadyExistsException((SchemaRule)indexWithSameSchema, SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
        this.assertSchemaRuleWithNameDoesNotExist(name);
        Iterator<ConstraintDescriptor> constraintWithSameSchema = this.allStoreHolder.constraintsGetForSchema(prototype.schema());
        while (constraintWithSameSchema.hasNext()) {
            ConstraintDescriptor constraint = constraintWithSameSchema.next();
            if (constraint.type() == ConstraintType.EXISTS) continue;
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
        if (indexWithSameSchema != IndexDescriptor.NO_INDEX) {
            throw new AlreadyIndexedException(prototype.schema(), SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
    }

    private void assertNoBlockingSchemaRulesExists(ConstraintDescriptor constraint) throws EquivalentSchemaRuleAlreadyExistsException, IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException, AlreadyConstrainedException, AlreadyIndexedException {
        Iterator<IndexDescriptor> existingIndexes;
        String name = constraint.getName();
        if (name == null) {
            throw new IllegalStateException("Expected constraint to always have a name by this point");
        }
        List constraintsWithSameSchema = Iterators.asList(this.allStoreHolder.constraintsGetForSchema(constraint.schema()));
        for (ConstraintDescriptor constraintWithSameSchema : constraintsWithSameSchema) {
            if (!constraint.equals(constraintWithSameSchema) || !constraint.getName().equals(constraintWithSameSchema.getName())) continue;
            throw new EquivalentSchemaRuleAlreadyExistsException((SchemaRule)constraintWithSameSchema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
        this.assertSchemaRuleWithNameDoesNotExist(name);
        for (ConstraintDescriptor constraintWithSameSchema : constraintsWithSameSchema) {
            boolean existingIsExistenceConstraint;
            boolean creatingExistenceConstraint = constraint.type() == ConstraintType.EXISTS;
            if (creatingExistenceConstraint != (existingIsExistenceConstraint = constraintWithSameSchema.type() == ConstraintType.EXISTS)) continue;
            throw new AlreadyConstrainedException(constraintWithSameSchema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
        if (constraint.type() != ConstraintType.EXISTS && (existingIndexes = this.allStoreHolder.index(constraint.schema())).hasNext()) {
            IndexDescriptor existingIndex = existingIndexes.next();
            throw new AlreadyIndexedException(existingIndex.schema(), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
    }

    private void assertSchemaRuleWithNameDoesNotExist(String name) throws IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException {
        ConstraintDescriptor constraintWithSameName = this.allStoreHolder.constraintGetForName(name);
        if (constraintWithSameName != null) {
            throw new ConstraintWithNameAlreadyExistsException(name);
        }
        IndexDescriptor indexWithSameName = this.allStoreHolder.indexGetForName(name);
        if (indexWithSameName != IndexDescriptor.NO_INDEX) {
            throw new IndexWithNameAlreadyExistsException(name);
        }
    }

    public ConstraintDescriptor nodeKeyConstraintCreate(IndexPrototype prototype) throws KernelException {
        SchemaDescriptor schema = prototype.schema();
        this.exclusiveSchemaLock(schema);
        this.ktx.assertOpen();
        prototype = this.ensureIndexPrototypeHasIndexProvider(prototype);
        NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)schema);
        try {
            this.assertValidDescriptor(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            if (prototype.getName().isEmpty()) {
                constraint = this.ensureConstraintHasName(constraint);
                prototype = prototype.withName(constraint.getName());
            } else {
                constraint = constraint.withName((String)prototype.getName().get());
            }
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(schema);
            throw e;
        }
        try (DefaultNodeLabelIndexCursor nodes = this.cursors.allocateFullAccessNodeLabelIndexCursor(this.cursorTracer);){
            this.allStoreHolder.nodeLabelScan(schema.getLabelId(), nodes, IndexOrder.NONE);
            this.constraintSemantics.validateNodeKeyConstraint(nodes, this.nodeCursor, this.propertyCursor, schema.asLabelSchemaDescriptor(), (TokenNameLookup)this.token);
        }
        this.indexBackedConstraintCreate(constraint, prototype);
        return constraint;
    }

    public ConstraintDescriptor nodePropertyExistenceConstraintCreate(LabelSchemaDescriptor schema, String name) throws KernelException {
        ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)schema, name);
        try (DefaultNodeLabelIndexCursor nodes = this.cursors.allocateFullAccessNodeLabelIndexCursor(this.cursorTracer);){
            this.allStoreHolder.nodeLabelScan(schema.getLabelId(), nodes, IndexOrder.NONE);
            this.constraintSemantics.validateNodePropertyExistenceConstraint(nodes, this.nodeCursor, this.propertyCursor, schema, (TokenNameLookup)this.token);
        }
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    public ConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor schema, String name) throws KernelException {
        ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)schema, name);
        if (((Boolean)this.config.get(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store)).booleanValue()) {
            try (DefaultRelationshipTypeIndexCursor relationshipsWithType = this.cursors.allocateRelationshipTypeIndexCursor();){
                this.allStoreHolder.relationshipTypeScan(schema.getRelTypeId(), relationshipsWithType);
                this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(relationshipsWithType, this.relationshipCursor, this.propertyCursor, schema, (TokenNameLookup)this.token);
            }
        } else {
            this.allStoreHolder.relationshipTypeScan(schema.getRelTypeId(), this.relationshipCursor);
            this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(this.relationshipCursor, this.propertyCursor, schema, (TokenNameLookup)this.token);
        }
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    private ConstraintDescriptor lockAndValidatePropertyExistenceConstraint(SchemaDescriptor descriptor, String name) throws KernelException {
        this.exclusiveSchemaLock(descriptor);
        this.ktx.assertOpen();
        try {
            this.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            ConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)descriptor).withName(name);
            constraint = this.ensureConstraintHasName(constraint);
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists(constraint);
            return constraint;
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(descriptor);
            throw e;
        }
    }

    public void constraintDrop(SchemaDescriptor schema, ConstraintType type) throws SchemaKernelException {
        ConstraintDescriptor constraint2;
        this.ktx.assertOpen();
        Iterator constraints = this.ktx.schemaRead().constraintsGetForSchema(schema);
        constraints = Iterators.filter(constraint -> constraint.type() == type, (Iterator)constraints);
        if (constraints.hasNext()) {
            constraint2 = (ConstraintDescriptor)constraints.next();
            if (constraints.hasNext()) {
                String schemaDescription = schema.userDescription((TokenNameLookup)this.token);
                String constraintDescription = ((ConstraintDescriptor)constraints.next()).userDescription((TokenNameLookup)this.token);
                throw new DropConstraintFailureException((SchemaDescriptorSupplier)constraint2, (Throwable)new IllegalArgumentException("More than one " + type + " constraint was found with the '" + schemaDescription + "' schema: " + constraintDescription + ", please drop constraint by name instead."));
            }
        } else {
            throw new DropConstraintFailureException((SchemaDescriptorSupplier)schema, (Throwable)((Object)new NoSuchConstraintException((SchemaDescriptorSupplier)schema, (TokenNameLookup)this.token)));
        }
        this.constraintDrop(constraint2);
    }

    public void constraintDrop(String name) throws SchemaKernelException {
        this.exclusiveSchemaNameLock(name);
        ConstraintDescriptor constraint = this.allStoreHolder.constraintGetForName(name);
        if (constraint == null) {
            throw new DropConstraintFailureException(name, (Throwable)((Object)new NoSuchConstraintException(name)));
        }
        this.constraintDrop(constraint);
    }

    public void constraintDrop(ConstraintDescriptor constraint) throws SchemaKernelException {
        IndexDescriptor index;
        SchemaDescriptor schema = constraint.schema();
        this.exclusiveOptimisticLock(schema.keyType(), schema.lockingKeys());
        this.exclusiveSchemaNameLock(constraint.getName());
        this.ktx.assertOpen();
        try {
            this.assertConstraintExists(constraint);
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException((SchemaDescriptorSupplier)constraint, (Throwable)((Object)e));
        }
        TransactionState txState = this.ktx.txState();
        txState.constraintDoDrop(constraint);
        if (constraint.enforcesUniqueness() && (index = this.allStoreHolder.indexGetForName(constraint.getName())) != IndexDescriptor.NO_INDEX) {
            txState.indexDoDrop(index);
        }
    }

    private void exclusiveOptimisticLock(ResourceType resource, long[] resourceIds) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), resource, resourceIds);
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisTx(node)) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.NODE, node);
        }
    }

    private void acquireExclusiveRelationshipLock(long relationshipId) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().relationshipIsAddedInThisTx(relationshipId)) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.RELATIONSHIP, relationshipId);
        }
    }

    private void sharedSchemaLock(ResourceType type, int tokenId) {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), type, tokenId);
    }

    private void exclusiveSchemaLock(SchemaDescriptor schema) {
        long[] lockingIds = schema.lockingKeys();
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), schema.keyType(), lockingIds);
    }

    private void exclusiveSchemaUnlock(SchemaDescriptor schema) {
        long[] lockingIds = schema.lockingKeys();
        this.ktx.statementLocks().optimistic().releaseExclusive(schema.keyType(), lockingIds);
    }

    private void exclusiveSchemaNameLock(String schemaName) {
        long lockingId = ResourceIds.schemaNameResourceId(schemaName);
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.SCHEMA_NAME, lockingId);
    }

    private void lockRelationshipNodes(long startNodeId, long endNodeId) {
        this.acquireExclusiveNodeLock(Math.min(startNodeId, endNodeId));
        if (startNodeId != endNodeId) {
            this.acquireExclusiveNodeLock(Math.max(startNodeId, endNodeId));
        }
    }

    private static boolean propertyHasChanged(Value lhs, Value rhs) {
        return !lhs.isSameValueTypeAs(rhs) || !lhs.equals(rhs);
    }

    private void assertNodeExists(long sourceNode) throws EntityNotFoundException {
        if (!this.allStoreHolder.nodeExists(sourceNode)) {
            throw new EntityNotFoundException(EntityType.NODE, sourceNode);
        }
    }

    public Locks locks() {
        return this.allStoreHolder;
    }

    private void assertConstraintExists(ConstraintDescriptor constraint) throws NoSuchConstraintException {
        if (!this.allStoreHolder.constraintExists(constraint)) {
            throw new NoSuchConstraintException((SchemaDescriptorSupplier)constraint, (TokenNameLookup)this.token);
        }
    }

    private void assertValidDescriptor(SchemaDescriptor descriptor, SchemaKernelException.OperationContext context) throws RepeatedSchemaComponentException {
        long numUniqueProp = Arrays.stream(descriptor.getPropertyIds()).distinct().count();
        long numUniqueEntityTokens = Arrays.stream(descriptor.getEntityTokenIds()).distinct().count();
        if (numUniqueProp != (long)descriptor.getPropertyIds().length) {
            throw new RepeatedPropertyInSchemaException(descriptor, context, (TokenNameLookup)this.token);
        }
        if (numUniqueEntityTokens != (long)descriptor.getEntityTokenIds().length) {
            if (descriptor.entityType() == EntityType.NODE) {
                throw new RepeatedLabelInSchemaException(descriptor, context, (TokenNameLookup)this.token);
            }
            throw new RepeatedRelationshipTypeInSchemaException(descriptor, context, (TokenNameLookup)this.token);
        }
    }

    private <T extends IndexBackedConstraintDescriptor> T indexBackedConstraintCreate(T constraint, IndexPrototype prototype) throws KernelException {
        try {
            if (this.allStoreHolder.constraintExists((ConstraintDescriptor)constraint)) {
                throw new AlreadyConstrainedException((ConstraintDescriptor)constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
            }
            if (prototype.getIndexType() != IndexType.BTREE) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index with index type " + prototype.getIndexType() + ".");
            }
            if (prototype.schema().isFulltextSchemaDescriptor()) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index using a full-text schema: " + prototype.schema().userDescription((TokenNameLookup)this.token));
            }
            if (prototype.schema().isRelationshipTypeSchemaDescriptor()) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index using a relationship type schema: " + prototype.schema().userDescription((TokenNameLookup)this.token));
            }
            if (!prototype.isUnique()) {
                throw new CreateConstraintFailureException(constraint, "Cannot create index backed constraint using an index prototype that is not unique: " + prototype.userDescription((TokenNameLookup)this.token));
            }
            IndexDescriptor index = this.constraintIndexCreator.createUniquenessConstraintIndex(this.ktx, (IndexBackedConstraintDescriptor)constraint, prototype);
            if (!this.allStoreHolder.constraintExists((ConstraintDescriptor)constraint)) {
                constraint = constraint.withOwnedIndexId(index.getId());
                this.ktx.txState().constraintDoAdd((IndexBackedConstraintDescriptor)constraint, index);
            } else {
                constraint = (IndexBackedConstraintDescriptor)this.allStoreHolder.constraintsGetForSchema(constraint.schema());
            }
            return constraint;
        }
        catch (TransactionFailureException | AlreadyConstrainedException | UniquePropertyValueValidationException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
    }

    private <T extends ConstraintDescriptor> T ensureConstraintHasName(T constraint) throws KernelException {
        if (constraint.getName() == null) {
            String[] entityTokenNames;
            SchemaDescriptor schema = constraint.schema();
            int[] entityTokenIds = schema.getEntityTokenIds();
            switch (schema.entityType()) {
                case NODE: {
                    entityTokenNames = this.resolveTokenNames(this.token::nodeLabelName, entityTokenIds);
                    break;
                }
                case RELATIONSHIP: {
                    entityTokenNames = this.resolveTokenNames(this.token::relationshipTypeName, entityTokenIds);
                    break;
                }
                default: {
                    throw new UnspecifiedKernelException((Status)Status.General.UnknownError, "Cannot create constraint for entity type %s in the schema %s.", new Object[]{schema.entityType(), schema});
                }
            }
            int[] propertyIds = schema.getPropertyIds();
            String[] propertyNames = this.resolveTokenNames(this.token::propertyKeyName, propertyIds);
            constraint = constraint.withName(SchemaRule.generateName(constraint, (String[])entityTokenNames, (String[])propertyNames));
        }
        return constraint;
    }

    private void assertAllowsWrites() {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsCreateNode(int[] labelIds) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsCreateNode(labelIds)) {
            String labels = null == labelIds ? "" : Arrays.stream(labelIds).mapToObj(this.token::labelGetName).collect(Collectors.joining(","));
            throw accessMode.onViolation(String.format("Create node with labels '%s' is not allowed for %s.", labels, this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsDeleteNode(Supplier<TokenSet> labelSupplier) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsDeleteNode(labelSupplier)) {
            String labels = Arrays.stream(labelSupplier.get().all()).mapToObj(id -> this.token.labelGetName((int)id)).collect(Collectors.joining(","));
            throw accessMode.onViolation(String.format("Delete node with labels '%s' is not allowed for %s.", labels, this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsCreateRelationship(int relType) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsCreateRelationship(relType)) {
            throw accessMode.onViolation(String.format("Create relationship with type '%s' is not allowed for %s.", this.token.relationshipTypeGetName(relType), this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsDeleteRelationship(int relType) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsDeleteRelationship(relType)) {
            throw accessMode.onViolation(String.format("Delete relationship with type '%s' is not allowed for %s.", this.token.relationshipTypeGetName(relType), this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsSetLabel(long labelId) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSetLabel(labelId)) {
            throw accessMode.onViolation(String.format("Set label for label '%s' is not allowed for %s.", this.token.labelGetName((int)labelId), this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsRemoveLabel(long labelId) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsRemoveLabel(labelId)) {
            throw accessMode.onViolation(String.format("Remove label for label '%s' is not allowed for %s.", this.token.labelGetName((int)labelId), this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsSetProperty(long[] labelIds, long propertyKey) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSetProperty(() -> Labels.from(labelIds), (int)propertyKey)) {
            throw accessMode.onViolation(String.format("Set property for property '%s' is not allowed for %s.", this.resolvePropertyKey(propertyKey), this.ktx.securityContext().description()));
        }
    }

    private void assertAllowsSetProperty(long relType, long propertyKey) {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSetProperty(() -> (int)relType, (int)propertyKey)) {
            throw accessMode.onViolation(String.format("Set property for property '%s' is not allowed for %s.", this.resolvePropertyKey(propertyKey), this.ktx.securityContext().description()));
        }
    }

    private String resolvePropertyKey(long propertyKey) {
        String propKeyName;
        try {
            propKeyName = this.token.propertyKeyName((int)propertyKey);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            propKeyName = "<unknown>";
        }
        return propKeyName;
    }
}

