/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.eclipse.collections.api.factory.Sets;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsKey;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsLayout;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsValue;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsVisitor;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class IndexStatisticsStore
extends LifecycleAdapter
implements IndexStatisticsVisitor.Visitable,
ConsistencyCheckable {
    private static final ImmutableIndexStatistics EMPTY_STATISTICS = new ImmutableIndexStatistics(0L, 0L, 0L, 0L);
    private static final IndexStatisticsKey LOWEST_KEY = new IndexStatisticsKey(Long.MIN_VALUE);
    private static final IndexStatisticsKey HIGHEST_KEY = new IndexStatisticsKey(Long.MAX_VALUE);
    private static final String INIT_TAG = "Initialize IndexStatisticsStore";
    private final PageCache pageCache;
    private final File file;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final PageCacheTracer pageCacheTracer;
    private final IndexStatisticsLayout layout;
    private final boolean readOnly;
    private GBPTree<IndexStatisticsKey, IndexStatisticsValue> tree;
    private final ConcurrentHashMap<Long, ImmutableIndexStatistics> cache = new ConcurrentHashMap();

    public IndexStatisticsStore(PageCache pageCache, File file, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, PageCacheTracer pageCacheTracer) {
        this.pageCache = pageCache;
        this.file = file;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.pageCacheTracer = pageCacheTracer;
        this.layout = new IndexStatisticsLayout();
        this.readOnly = readOnly;
    }

    public IndexStatisticsStore(PageCache pageCache, DatabaseLayout databaseLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, PageCacheTracer pageCacheTracer) {
        this(pageCache, databaseLayout.indexStatisticsStore(), recoveryCleanupWorkCollector, readOnly, pageCacheTracer);
    }

    public void init() throws IOException {
        try {
            this.tree = new GBPTree(this.pageCache, this.file, (Layout)this.layout, 0, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, this.recoveryCleanupWorkCollector, this.readOnly, this.pageCacheTracer, Sets.immutable.empty());
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Index statistics store file could not be found, most likely this database needs to be recovered, file:" + this.file, e);
        }
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(INIT_TAG);){
            this.scanTree((key, value) -> this.cache.put(key.getIndexId(), new ImmutableIndexStatistics((IndexStatisticsValue)value)), cursorTracer);
        }
    }

    public IndexSample indexSample(long indexId) {
        ImmutableIndexStatistics value = this.cache.getOrDefault(indexId, EMPTY_STATISTICS);
        return new IndexSample(value.indexSize, value.sampleUniqueValues, value.sampleSize, value.updatesCount);
    }

    public void replaceStats(long indexId, IndexSample sample) {
        this.cache.put(indexId, new ImmutableIndexStatistics(sample.uniqueValues(), sample.sampleSize(), sample.updates(), sample.indexSize()));
    }

    public void removeIndex(long indexId) {
        this.cache.remove(indexId);
    }

    public void incrementIndexUpdates(long indexId, long delta) {
        this.cache.computeIfPresent(indexId, (id, existing) -> new ImmutableIndexStatistics(existing.sampleUniqueValues, existing.sampleSize, existing.updatesCount + delta, existing.indexSize));
    }

    @Override
    public void visit(IndexStatisticsVisitor visitor, PageCursorTracer cursorTracer) {
        try {
            this.scanTree((key, value) -> visitor.visitIndexStatistics(key.getIndexId(), value.getSampleUniqueValues(), value.getSampleSize(), value.getUpdatesCount(), value.getIndexSize()), cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void checkpoint(IOLimiter ioLimiter, PageCursorTracer cursorTracer) throws IOException {
        if (!this.readOnly) {
            this.clearTree(cursorTracer);
            this.writeCacheContentsIntoTree(cursorTracer);
            this.tree.checkpoint(ioLimiter, cursorTracer);
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<IndexStatisticsKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)), cursorTracer);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<IndexStatisticsKey> visitor, PageCursorTracer cursorTracer) {
        try {
            return this.tree.consistencyCheck(visitor, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void scanTree(BiConsumer<IndexStatisticsKey, IndexStatisticsValue> consumer, PageCursorTracer cursorTracer) throws IOException {
        try (Seeker seek = this.tree.seek((Object)LOWEST_KEY, (Object)HIGHEST_KEY, cursorTracer);){
            while (seek.next()) {
                IndexStatisticsKey key = this.layout.copyKey((IndexStatisticsKey)seek.key(), new IndexStatisticsKey());
                IndexStatisticsValue value = (IndexStatisticsValue)seek.value();
                consumer.accept(key, value);
            }
        }
    }

    private void clearTree(PageCursorTracer cursorTracer) throws IOException {
        ArrayList keys = new ArrayList(this.cache.size());
        this.scanTree((key, value) -> keys.add(key), cursorTracer);
        try (Writer writer = this.tree.writer(cursorTracer);){
            for (IndexStatisticsKey key2 : keys) {
                writer.remove((Object)key2);
            }
        }
    }

    private void writeCacheContentsIntoTree(PageCursorTracer cursorTracer) throws IOException {
        try (Writer writer = this.tree.writer(cursorTracer);){
            for (Map.Entry<Long, ImmutableIndexStatistics> entry : this.cache.entrySet()) {
                ImmutableIndexStatistics stats = entry.getValue();
                writer.put((Object)new IndexStatisticsKey(entry.getKey()), (Object)new IndexStatisticsValue(stats.sampleUniqueValues, stats.sampleSize, stats.updatesCount, stats.indexSize));
            }
        }
    }

    public File storeFile() {
        return this.file;
    }

    public void shutdown() throws IOException {
        this.tree.close();
    }

    private static class ImmutableIndexStatistics {
        private final long sampleUniqueValues;
        private final long sampleSize;
        private final long updatesCount;
        private final long indexSize;

        ImmutableIndexStatistics(long sampleUniqueValues, long sampleSize, long updatesCount, long indexSize) {
            this.sampleUniqueValues = sampleUniqueValues;
            this.sampleSize = sampleSize;
            this.updatesCount = updatesCount;
            this.indexSize = indexSize;
        }

        ImmutableIndexStatistics(IndexStatisticsValue value) {
            this(value.getSampleUniqueValues(), value.getSampleSize(), value.getUpdatesCount(), value.getIndexSize());
        }
    }
}

