/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;

public class PhysicalLogVersionedStoreChannel
extends DelegatingStoreChannel
implements LogVersionedStoreChannel {
    private final long version;
    private final byte formatVersion;
    private long position;
    private final File file;
    private final ChannelNativeAccessor nativeChannelAccessor;

    public PhysicalLogVersionedStoreChannel(StoreChannel delegateChannel, long version, byte formatVersion, File file, ChannelNativeAccessor nativeChannelAccessor) throws IOException {
        super(delegateChannel);
        this.version = version;
        this.formatVersion = formatVersion;
        this.position = delegateChannel.position();
        this.file = file;
        this.nativeChannelAccessor = nativeChannelAccessor;
    }

    public File getFile() {
        return this.file;
    }

    public void writeAll(ByteBuffer src, long position) {
        throw new UnsupportedOperationException("Not needed");
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.advance(src.remaining());
        super.writeAll(src);
    }

    public int read(ByteBuffer dst, long position) {
        throw new UnsupportedOperationException("Not needed");
    }

    public StoreChannel position(long newPosition) throws IOException {
        this.position = newPosition;
        return super.position(newPosition);
    }

    public int read(ByteBuffer dst) throws IOException {
        return (int)this.advance(super.read(dst));
    }

    private long advance(long bytes) {
        if (bytes != -1L) {
            this.position += bytes;
        }
        return bytes;
    }

    public int write(ByteBuffer src) throws IOException {
        return (int)this.advance(super.write(src));
    }

    public long position() {
        return this.position;
    }

    public void close() throws IOException {
        this.nativeChannelAccessor.evictFromSystemCache((StoreChannel)this, this.version);
        super.close();
    }

    public long write(ByteBuffer[] sources, int offset, int length) throws IOException {
        return this.advance(super.write(sources, offset, length));
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.advance(super.write(srcs));
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.advance(super.read(dsts, offset, length));
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.advance(super.read(dsts));
    }

    public long getVersion() {
        return this.version;
    }

    public byte getLogFormatVersion() {
        return this.formatVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PhysicalLogVersionedStoreChannel that = (PhysicalLogVersionedStoreChannel)((Object)o);
        return this.version == that.version && this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }
}

