/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.io.IOUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.state.SchemaAndIndexingFileIndexListing;
import org.neo4j.kernel.impl.util.MultiResource;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class DatabaseFileListing {
    private final DatabaseLayout databaseLayout;
    private final LogFiles logFiles;
    private final StorageEngine storageEngine;
    private final IdGeneratorFactory idGeneratorFactory;
    private static final Function<File, StoreFileMetadata> logFileMapper = file -> new StoreFileMetadata(file, 1, true);
    private final SchemaAndIndexingFileIndexListing fileIndexListing;
    private final Collection<StoreFileProvider> additionalProviders;

    public DatabaseFileListing(DatabaseLayout databaseLayout, LogFiles logFiles, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, IndexingService indexingService, StorageEngine storageEngine, IdGeneratorFactory idGeneratorFactory) {
        this.databaseLayout = databaseLayout;
        this.logFiles = logFiles;
        this.storageEngine = storageEngine;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileIndexListing = new SchemaAndIndexingFileIndexListing(labelScanStore, relationshipTypeScanStore, indexingService);
        this.additionalProviders = new CopyOnWriteArraySet<StoreFileProvider>();
    }

    public StoreFileListingBuilder builder() {
        return new StoreFileListingBuilder();
    }

    public void registerStoreFileProvider(StoreFileProvider provider) {
        this.additionalProviders.add(provider);
    }

    private void placeMetaDataStoreLast(List<StoreFileMetadata> files) {
        int index = 0;
        for (StoreFileMetadata file : files) {
            if (this.databaseLayout.metadataStore().equals(file.file())) break;
            ++index;
        }
        if (index < files.size() - 1) {
            StoreFileMetadata metaDataStoreFile = files.remove(index);
            files.add(metaDataStoreFile);
        }
    }

    private void gatherLogFiles(Collection<StoreFileMetadata> files) {
        File[] list;
        for (File logFile : list = this.logFiles.logFiles()) {
            files.add(logFileMapper.apply(logFile));
        }
    }

    private void gatherIdFiles(List<StoreFileMetadata> targetFiles) {
        targetFiles.addAll(this.idGeneratorFactory.listIdFiles().stream().map(file -> new StoreFileMetadata(file, 0)).collect(Collectors.toList()));
    }

    private void gatherNeoStoreFiles(Collection<StoreFileMetadata> targetFiles) {
        targetFiles.addAll(this.storageEngine.listStorageFiles());
    }

    public class StoreFileListingBuilder {
        private boolean excludeLogFiles;
        private boolean excludeNeoStoreFiles;
        private boolean excludeLabelScanStoreFiles;
        private boolean excludeRelationshipTypeScanStoreFiles;
        private boolean excludeSchemaIndexStoreFiles;
        private boolean excludeAdditionalProviders;
        private boolean excludeIdFiles;

        private StoreFileListingBuilder() {
        }

        private void excludeAll(boolean initiateInclusive) {
            this.excludeLogFiles = initiateInclusive;
            this.excludeNeoStoreFiles = initiateInclusive;
            this.excludeLabelScanStoreFiles = initiateInclusive;
            this.excludeRelationshipTypeScanStoreFiles = initiateInclusive;
            this.excludeSchemaIndexStoreFiles = initiateInclusive;
            this.excludeAdditionalProviders = initiateInclusive;
            this.excludeIdFiles = initiateInclusive;
        }

        public StoreFileListingBuilder excludeAll() {
            this.excludeAll(true);
            return this;
        }

        public StoreFileListingBuilder includeAll() {
            this.excludeAll(false);
            return this;
        }

        public StoreFileListingBuilder excludeLogFiles() {
            this.excludeLogFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeNeoStoreFiles() {
            this.excludeNeoStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeLabelScanStoreFiles() {
            this.excludeLabelScanStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeRelationshipTypeScanStoreFiles() {
            this.excludeRelationshipTypeScanStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeSchemaIndexStoreFiles() {
            this.excludeSchemaIndexStoreFiles = true;
            return this;
        }

        public StoreFileListingBuilder excludeAdditionalProviders() {
            this.excludeAdditionalProviders = true;
            return this;
        }

        public StoreFileListingBuilder excludeIdFiles() {
            this.excludeIdFiles = true;
            return this;
        }

        public StoreFileListingBuilder includeLogFiles() {
            this.excludeLogFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeNeoStoreFiles() {
            this.excludeNeoStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeLabelScanStoreFiles() {
            this.excludeLabelScanStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeRelationshipTypeScanStoreFiles() {
            this.excludeRelationshipTypeScanStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeSchemaIndexStoreFiles() {
            this.excludeSchemaIndexStoreFiles = false;
            return this;
        }

        public StoreFileListingBuilder includeAdditionalProviders() {
            this.excludeAdditionalProviders = false;
            return this;
        }

        public StoreFileListingBuilder includeIdFiles() {
            this.excludeIdFiles = false;
            return this;
        }

        public ResourceIterator<StoreFileMetadata> build() throws IOException {
            ArrayList<StoreFileMetadata> files = new ArrayList<StoreFileMetadata>();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            try {
                if (!this.excludeLogFiles) {
                    DatabaseFileListing.this.gatherLogFiles(files);
                }
                if (!this.excludeNeoStoreFiles) {
                    DatabaseFileListing.this.gatherNeoStoreFiles(files);
                }
                if (!this.excludeIdFiles) {
                    DatabaseFileListing.this.gatherIdFiles(files);
                }
                if (!this.excludeLabelScanStoreFiles) {
                    resources.add(DatabaseFileListing.this.fileIndexListing.gatherLabelScanStoreFiles(files));
                }
                if (!this.excludeRelationshipTypeScanStoreFiles) {
                    resources.add(DatabaseFileListing.this.fileIndexListing.gatherRelationshipTypeScanStoreFiles(files));
                }
                if (!this.excludeSchemaIndexStoreFiles) {
                    resources.add(DatabaseFileListing.this.fileIndexListing.gatherSchemaIndexFiles(files));
                }
                if (!this.excludeAdditionalProviders) {
                    for (StoreFileProvider additionalProvider : DatabaseFileListing.this.additionalProviders) {
                        resources.add(additionalProvider.addFilesTo(files));
                    }
                }
                DatabaseFileListing.this.placeMetaDataStoreLast(files);
            }
            catch (IOException e) {
                try {
                    IOUtils.closeAll(resources);
                }
                catch (IOException e1) {
                    e = (IOException)Exceptions.chain((Throwable)e, (Throwable)e1);
                }
                throw e;
            }
            return Iterators.resourceIterator(files.iterator(), (Resource)new MultiResource(resources));
        }
    }

    public static interface StoreFileProvider {
        public Resource addFilesTo(Collection<StoreFileMetadata> var1) throws IOException;
    }
}

