/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.concurrent.ThreadingExtension;
import org.neo4j.test.rule.concurrent.ThreadingRule;

@EphemeralPageCacheExtension
@ExtendWith(value={ThreadingExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class DatabaseCompositeIndexAccessorTest {
    private static final int PROP_ID1 = 1;
    private static final int PROP_ID2 = 2;
    private static final Config CONFIG = Config.defaults();
    private static final IndexSamplingConfig SAMPLING_CONFIG = new IndexSamplingConfig(CONFIG);
    private static final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Inject
    private ThreadingRule threading;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    private final long nodeId = 1L;
    private final long nodeId2 = 2L;
    private final Object[] values = new Object[]{"value1", "values2"};
    private final Object[] values2 = new Object[]{40, 42};
    private DirectoryFactory.InMemoryDirectoryFactory dirFactory;
    private static final IndexPrototype SCHEMA_INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1, 2}));
    private static final IndexPrototype UNIQUE_SCHEMA_INDEX_DESCRIPTOR = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1, 2}));
    private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
    private Iterable<IndexProvider> providers;

    @BeforeAll
    public void prepareProviders() throws IOException {
        this.dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
        this.providers = DatabaseCompositeIndexAccessorTest.getIndexProviders(this.pageCache, this.jobScheduler, this.fileSystem, this.testDirectory);
    }

    @AfterAll
    public void after() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.dirFactory, this.jobScheduler});
    }

    private static Iterable<IndexProvider> getIndexProviders(PageCache pageCache, JobScheduler jobScheduler, FileSystemAbstraction fileSystem, TestDirectory testDirectory) throws IOException {
        List<ExtensionFactory> indexProviderFactories = Arrays.asList(new GenericNativeIndexProviderFactory(), new NativeLuceneFusionIndexProviderFactory30());
        Dependencies deps = new Dependencies();
        deps.satisfyDependencies(new Object[]{pageCache, jobScheduler, fileSystem, new SimpleLogService((LogProvider)logProvider), new Monitors(), CONFIG, RecoveryCleanupWorkCollector.ignore()});
        testDirectory.prepareDirectory(DatabaseCompositeIndexAccessorTest.class, "null");
        Config config = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)testDirectory.homePath());
        DatabaseExtensionContext context = new DatabaseExtensionContext(DatabaseLayout.of((Config)config), DbmsInfo.UNKNOWN, (DependencySatisfier)deps);
        DatabaseExtensions extensions = new DatabaseExtensions(context, indexProviderFactories, deps, ExtensionFailureStrategies.fail());
        extensions.init();
        return deps.resolveTypeDependencies(IndexProvider.class);
    }

    private static IndexAccessor indexAccessor(IndexProvider provider, IndexDescriptor descriptor) throws IOException {
        IndexPopulator populator = provider.getPopulator(descriptor, SAMPLING_CONFIG, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        populator.create();
        populator.close(true, PageCursorTracer.NULL);
        return provider.getOnlineAccessor(descriptor, SAMPLING_CONFIG, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
    }

    private Set<Long> resultSet(IndexReader reader, IndexQuery ... queries) throws IndexNotApplicableKernelException {
        try (NodeValueIterator results = new NodeValueIterator();){
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)results, IndexQueryConstraints.unconstrained(), queries);
            Set set = PrimitiveLongCollections.toSet((LongIterator)results);
            return set;
        }
    }

    private IndexEntryUpdate<?> add(long nodeId, Object ... values) {
        return IndexQueryHelper.add((long)nodeId, (SchemaDescriptor)SCHEMA_INDEX_DESCRIPTOR.schema(), (Object[])values);
    }

    private IndexEntryUpdate<?> remove(long nodeId, Object ... values) {
        return IndexQueryHelper.remove((long)nodeId, (SchemaDescriptor)SCHEMA_INDEX_DESCRIPTOR.schema(), (Object[])values);
    }

    private IndexEntryUpdate<?> change(long nodeId, Object[] valuesBefore, Object[] valuesAfter) {
        return IndexQueryHelper.change((long)nodeId, (SchemaDescriptor)SCHEMA_INDEX_DESCRIPTOR.schema(), (Object[])valuesBefore, (Object[])valuesAfter);
    }

    private void updateAndCommit(IndexAccessor accessor, List<IndexEntryUpdate<?>> nodePropertyUpdates) throws IndexEntryConflictException {
        try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
            for (IndexEntryUpdate<?> update : nodePropertyUpdates) {
                updater.process(update);
            }
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class CompositeTests {
        CompositeTests() {
        }

        private List<IndexAccessor> indexAccessors() throws IOException {
            ArrayList<IndexAccessor> accessors = new ArrayList<IndexAccessor>();
            for (IndexProvider p : DatabaseCompositeIndexAccessorTest.this.providers) {
                accessors.add(DatabaseCompositeIndexAccessorTest.indexAccessor(p, p.completeConfiguration(SCHEMA_INDEX_DESCRIPTOR.withName("index_0").materialise(0L))));
                accessors.add(DatabaseCompositeIndexAccessorTest.indexAccessor(p, p.completeConfiguration(UNIQUE_SCHEMA_INDEX_DESCRIPTOR.withName("constraint_1").materialise(1L))));
            }
            return accessors;
        }

        @ParameterizedTest
        @MethodSource(value={"indexAccessors"})
        void indexReaderShouldSupportScan(IndexAccessor accessor) throws Exception {
            try (IndexAccessor indexAccessor = accessor;){
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Arrays.asList(DatabaseCompositeIndexAccessorTest.this.add(1L, DatabaseCompositeIndexAccessorTest.this.values), DatabaseCompositeIndexAccessorTest.this.add(2L, DatabaseCompositeIndexAccessorTest.this.values2)));
                try (IndexReader reader = accessor.newReader();){
                    Set<Long> results = DatabaseCompositeIndexAccessorTest.this.resultSet(reader, new IndexQuery[]{IndexQuery.exists((int)1), IndexQuery.exists((int)2)});
                    Set<Long> results2 = DatabaseCompositeIndexAccessorTest.this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values[1])});
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), results);
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), results2);
                }
            }
        }

        @ParameterizedTest
        @MethodSource(value={"indexAccessors"})
        void multipleIndexReadersFromDifferentPointsInTimeCanSeeDifferentResults(IndexAccessor accessor) throws Exception {
            try (IndexAccessor indexAccessor = accessor;){
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Collections.singletonList(DatabaseCompositeIndexAccessorTest.this.add(1L, DatabaseCompositeIndexAccessorTest.this.values)));
                IndexReader firstReader = accessor.newReader();
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Collections.singletonList(DatabaseCompositeIndexAccessorTest.this.add(2L, DatabaseCompositeIndexAccessorTest.this.values2)));
                IndexReader secondReader = accessor.newReader();
                org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), DatabaseCompositeIndexAccessorTest.this.resultSet(firstReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values[1])}));
                Assertions.assertThat(DatabaseCompositeIndexAccessorTest.this.resultSet(firstReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values2[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values2[1])})).is(Assertions.anyOf((Condition[])new Condition[]{new Condition(s -> s.equals(Iterators.asSet((Object[])new Object[0])), "empty set", new Object[0]), new Condition(s -> s.equals(Iterators.asSet((Object[])new Long[]{2L})), "one element", new Object[0])}));
                org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), DatabaseCompositeIndexAccessorTest.this.resultSet(secondReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values[1])}));
                org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), DatabaseCompositeIndexAccessorTest.this.resultSet(secondReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values2[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values2[1])}));
                firstReader.close();
                secondReader.close();
            }
        }

        @ParameterizedTest
        @MethodSource(value={"indexAccessors"})
        void canAddNewData(IndexAccessor accessor) throws Exception {
            try (IndexAccessor indexAccessor = accessor;){
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Arrays.asList(DatabaseCompositeIndexAccessorTest.this.add(1L, DatabaseCompositeIndexAccessorTest.this.values), DatabaseCompositeIndexAccessorTest.this.add(2L, DatabaseCompositeIndexAccessorTest.this.values2)));
                try (IndexReader reader = accessor.newReader();){
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), DatabaseCompositeIndexAccessorTest.this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values[1])}));
                }
            }
        }

        @ParameterizedTest
        @MethodSource(value={"indexAccessors"})
        void canChangeExistingData(IndexAccessor accessor) throws Exception {
            try (IndexAccessor indexAccessor = accessor;){
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Collections.singletonList(DatabaseCompositeIndexAccessorTest.this.add(1L, DatabaseCompositeIndexAccessorTest.this.values)));
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Collections.singletonList(DatabaseCompositeIndexAccessorTest.this.change(1L, DatabaseCompositeIndexAccessorTest.this.values, DatabaseCompositeIndexAccessorTest.this.values2)));
                try (IndexReader reader = accessor.newReader();){
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), DatabaseCompositeIndexAccessorTest.this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values2[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values2[1])}));
                    org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), DatabaseCompositeIndexAccessorTest.this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values[1])}));
                }
            }
        }

        @ParameterizedTest
        @MethodSource(value={"indexAccessors"})
        void canRemoveExistingData(IndexAccessor accessor) throws Exception {
            try (IndexAccessor indexAccessor = accessor;){
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Arrays.asList(DatabaseCompositeIndexAccessorTest.this.add(1L, DatabaseCompositeIndexAccessorTest.this.values), DatabaseCompositeIndexAccessorTest.this.add(2L, DatabaseCompositeIndexAccessorTest.this.values2)));
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Collections.singletonList(DatabaseCompositeIndexAccessorTest.this.remove(1L, DatabaseCompositeIndexAccessorTest.this.values)));
                try (IndexReader reader = accessor.newReader();){
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), DatabaseCompositeIndexAccessorTest.this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values2[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values2[1])}));
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), DatabaseCompositeIndexAccessorTest.this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)DatabaseCompositeIndexAccessorTest.this.values[0]), IndexQuery.exact((int)2, (Object)DatabaseCompositeIndexAccessorTest.this.values[1])}));
                }
            }
        }

        @ParameterizedTest
        @MethodSource(value={"indexAccessors"})
        void shouldStopSamplingWhenIndexIsDropped(IndexAccessor accessor) throws Exception {
            try (IndexAccessor indexAccessor = accessor;){
                DatabaseCompositeIndexAccessorTest.this.updateAndCommit(accessor, Arrays.asList(DatabaseCompositeIndexAccessorTest.this.add(1L, DatabaseCompositeIndexAccessorTest.this.values), DatabaseCompositeIndexAccessorTest.this.add(2L, DatabaseCompositeIndexAccessorTest.this.values2)));
                IndexReader indexReader = accessor.newReader();
                IndexSampler indexSampler = indexReader.createSampler();
                AtomicBoolean droppedLatch = new AtomicBoolean();
                AtomicReference dropper = new AtomicReference();
                Predicate awaitCompletion = ThreadingRule.waitingWhileIn(TaskCoordinator.class, (String)"awaitCompletion");
                Future drop = DatabaseCompositeIndexAccessorTest.this.threading.execute(nothing -> {
                    dropper.set(Thread.currentThread());
                    try {
                        accessor.drop();
                    }
                    finally {
                        droppedLatch.set(true);
                    }
                    return null;
                }, null);
                IndexNotFoundKernelException e = (IndexNotFoundKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotFoundKernelException.class, () -> {
                    try (IndexReader reader = indexReader;
                         IndexSampler sampler = indexSampler;){
                        while (!droppedLatch.get() && !awaitCompletion.test((Thread)dropper.get())) {
                            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                        }
                        sampler.sampleIndex(PageCursorTracer.NULL);
                    }
                    finally {
                        drop.get();
                    }
                });
                Assertions.assertThat((Throwable)e).hasMessage("Index dropped while sampling.");
            }
        }
    }
}

