/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.diagnostics.providers.TransactionRangeDiagnostics;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.TransactionLogVersionSelector;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;

class TransactionRangeDiagnosticsTest {
    TransactionRangeDiagnosticsTest() {
    }

    @Test
    void shouldLogCorrectTransactionLogDiagnosticsForNoTransactionLogs() {
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.noLogs());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Transaction log files stored on file store:"}).containsMessages(new String[]{"No transactions"});
    }

    @Test
    void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.logWithTransactions(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"transaction " + (prevLogLastTxId + 1L), "version " + logVersion});
    }

    @Test
    void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInSecondOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.logWithTransactionsInNextToOldestLog(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"transaction " + (prevLogLastTxId + 1L), "version " + (logVersion + 1L)});
    }

    private static Database databaseWithLogFilesContainingLowestTxId(LogFiles files) {
        Dependencies dependencies = (Dependencies)Mockito.mock(Dependencies.class);
        Mockito.when((Object)((LogFiles)dependencies.resolveDependency(LogFiles.class))).thenReturn((Object)files);
        Database database = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)database.getDependencyResolver()).thenReturn((Object)dependencies);
        return database;
    }

    private static LogFiles logWithTransactionsInNextToOldestLog(long logVersion, long prevLogLastTxId) throws IOException {
        LogFiles files = TransactionRangeDiagnosticsTest.logWithTransactions(logVersion + 1L, prevLogLastTxId);
        LogFile logFile = files.getLogFile();
        Mockito.when((Object)logFile.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)logFile.hasAnyEntries(logVersion)).thenReturn((Object)false);
        Mockito.when((Object)logFile.versionExists(logVersion)).thenReturn((Object)true);
        return files;
    }

    private static LogFiles logWithTransactions(long logVersion, long headerTxId) throws IOException {
        LogFiles files = (LogFiles)Mockito.mock(TransactionLogFiles.class);
        LogFile file = (LogFile)Mockito.mock(TransactionLogFile.class);
        Mockito.when((Object)files.getLogFile()).thenReturn((Object)file);
        Mockito.when((Object)files.logFilesDirectory()).thenReturn((Object)Path.of(".", new String[0]));
        Mockito.when((Object)file.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)file.hasAnyEntries(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)file.versionExists(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)file.extractHeader(logVersion)).thenReturn((Object)new LogHeader(TransactionLogVersionSelector.LATEST.versionByte(), logVersion, headerTxId, 64L));
        return files;
    }

    private static LogFiles noLogs() {
        LogFiles files = (LogFiles)Mockito.mock(TransactionLogFiles.class);
        LogFile file = (LogFile)Mockito.mock(TransactionLogFile.class);
        Mockito.when((Object)files.getLogFile()).thenReturn((Object)file);
        Mockito.when((Object)file.getLowestLogVersion()).thenReturn((Object)-1L);
        Mockito.when((Object)files.logFilesDirectory()).thenReturn((Object)Path.of(".", new String[0]));
        return files;
    }
}

