/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
class GenericAccessorPointsTest {
    private static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    private static final Config config = Config.defaults();
    private static final IndexSpecificSpaceFillingCurveSettings indexSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
    private static final SpaceFillingCurve curve = indexSettings.forCrs(crs);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    private PageCache pageCache;
    @Inject
    private RandomRule random;
    private NativeIndexAccessor accessor;
    private IndexDescriptor descriptor;

    GenericAccessorPointsTest() {
    }

    @BeforeEach
    void setup() {
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.directory.homePath()).forProvider(GenericNativeIndexProvider.DESCRIPTOR);
        this.descriptor = TestIndexDescriptorFactory.forLabel(1, 1);
        IndexFiles indexFiles = new IndexFiles(this.fs, directoryStructure, this.descriptor.getId());
        GenericLayout layout = new GenericLayout(1, indexSettings);
        RecoveryCleanupWorkCollector collector = RecoveryCleanupWorkCollector.ignore();
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs).build();
        StandardConfiguration configuration = new StandardConfiguration();
        this.accessor = new GenericNativeIndexAccessor(databaseIndexContext, indexFiles, (IndexLayout)layout, collector, this.descriptor, indexSettings, (SpaceFillingCurveConfiguration)configuration, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
    }

    @AfterEach
    void tearDown() {
        this.accessor.close();
    }

    @Test
    void mustHandlePointsWithinSameTile() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Value> pointValues = new ArrayList<Value>();
        ArrayList updates = new ArrayList();
        long nodeId = 1L;
        for (int i = 0; i < nbrOfValues / 4; ++i) {
            double x1 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
            double x2 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
            double y1 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
            double y2 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
            PointValue value11 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y1});
            PointValue value12 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y2});
            PointValue value21 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y1});
            PointValue value22 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y2});
            GenericAccessorPointsTest.assertDerivedValue(derivedValueForCenterPoint, value11, value12, value21, value22);
            nodeId = this.addPointsToLists(pointValues, updates, nodeId, value11, value12, value21, value22);
        }
        this.processAll(updates);
        this.exactMatchOnAllValues(pointValues);
    }

    @Test
    void mustHandlePointArraysWithinSameTile() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Value> pointArrays = new ArrayList<Value>();
        ArrayList updates = new ArrayList();
        for (int i = 0; i < nbrOfValues; ++i) {
            int arrayLength = this.random.nextInt(5) + 1;
            PointValue[] pointValues = new PointValue[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                double x = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                double y = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x, centerPoint[1] + y});
                GenericAccessorPointsTest.assertDerivedValue(derivedValueForCenterPoint, value);
                pointValues[j] = value;
            }
            PointArray array = Values.pointArray((PointValue[])pointValues);
            pointArrays.add((Value)array);
            updates.add(IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{array}));
        }
        this.processAll(updates);
        this.exactMatchOnAllValues(pointArrays);
    }

    @Test
    void shouldNotGetRoundingErrorsWithPointsJustWithinTheTileUpperBound() {
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint);
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        double[] faultyCoords = new double[]{1.874410632171803E-8, 1.6763806281859016E-7};
        Assertions.assertTrue((centerPoint[0] + xWidthMultiplier > faultyCoords[0] ? 1 : 0) != 0, (String)"inside upper x limit");
        Assertions.assertTrue((centerPoint[0] - xWidthMultiplier < faultyCoords[0] ? 1 : 0) != 0, (String)"inside lower x limit");
        Assertions.assertTrue((centerPoint[1] + yWidthMultiplier > faultyCoords[1] ? 1 : 0) != 0, (String)"inside upper y limit");
        Assertions.assertTrue((centerPoint[1] - yWidthMultiplier < faultyCoords[1] ? 1 : 0) != 0, (String)"inside lower y limit");
        long derivedValueForFaultyCoords = curve.derivedValueFor(faultyCoords);
        Assertions.assertEquals((long)derivedValueForCenterPoint, (long)derivedValueForFaultyCoords, (String)"expected same derived value");
    }

    private long addPointsToLists(List<Value> pointValues, List<IndexEntryUpdate<?>> updates, long nodeId, PointValue ... values) {
        for (PointValue value : values) {
            pointValues.add((Value)value);
            updates.add(IndexEntryUpdate.add((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value}));
        }
        return nodeId;
    }

    private static void assertDerivedValue(Long targetDerivedValue, PointValue ... values) {
        for (PointValue value : values) {
            Long derivedValueForValue = curve.derivedValueFor(value.coordinate());
            Assertions.assertEquals((Long)targetDerivedValue, (Long)derivedValueForValue, (String)"expected random value to belong to same tile as center point");
        }
    }

    private void processAll(List<IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
            for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
    }

    private void exactMatchOnAllValues(List<Value> values) throws IndexNotApplicableKernelException {
        try (IndexReader indexReader = this.accessor.newReader();){
            SimpleNodeValueClient client = new SimpleNodeValueClient();
            for (Value value : values) {
                IndexQuery.ExactPredicate exact = IndexQuery.exact((int)this.descriptor.schema().getPropertyId(), (Object)value);
                indexReader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)client, IndexQueryConstraints.unorderedValues(), new IndexQuery[]{exact});
                Assertions.assertTrue((boolean)client.next());
                Assertions.assertEquals((Object)value, (Object)client.values[0]);
                Assertions.assertFalse((boolean)client.next());
            }
        }
    }
}

