/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.time.Clocks;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class ConfiguringPageCacheFactoryTest {
    @Inject
    private FileSystemAbstraction fs;
    private JobScheduler jobScheduler;

    ConfiguringPageCacheFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void shouldFitAsManyPagesAsItCan() {
        long pageCount = 60L;
        long memory = MuninnPageCache.memoryRequiredForPages((long)pageCount);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)Long.toString(memory));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, this.jobScheduler, Clocks.nanoClock(), new MemoryPools());
        try (PageCache cache = factory.getOrCreatePageCache();){
            Assertions.assertThat((int)cache.pageSize()).isEqualTo(8192);
            Assertions.assertThat((long)cache.maxCachedPages()).isEqualTo(pageCount);
        }
    }
}

