/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class SimpleMetaDataProvider
implements MetadataProvider {
    private final SimpleTransactionIdStore transactionIdStore;
    private final SimpleLogVersionRepository logVersionRepository;
    private final ExternalStoreId externalStoreId = new ExternalStoreId(UUID.randomUUID());

    public SimpleMetaDataProvider() {
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logVersionRepository = new SimpleLogVersionRepository();
    }

    public void close() throws IOException {
    }

    public long getCurrentLogVersion() {
        return this.logVersionRepository.getCurrentLogVersion();
    }

    public void setCurrentLogVersion(long version, PageCursorTracer cursorTracer) {
        this.logVersionRepository.setCurrentLogVersion(version, cursorTracer);
    }

    public long incrementAndGetVersion(PageCursorTracer cursorTracer) {
        return this.logVersionRepository.incrementAndGetVersion(cursorTracer);
    }

    public long getCheckpointLogVersion() {
        return this.logVersionRepository.getCheckpointLogVersion();
    }

    public void setCheckpointLogVersion(long version, PageCursorTracer cursorTracer) {
        this.logVersionRepository.setCheckpointLogVersion(version, cursorTracer);
    }

    public long incrementAndGetCheckpointLogVersion(PageCursorTracer cursorTracer) {
        return this.logVersionRepository.incrementAndGetCheckpointLogVersion(cursorTracer);
    }

    public StoreId getStoreId() {
        return StoreId.UNKNOWN;
    }

    public Optional<ExternalStoreId> getExternalStoreId() {
        return Optional.of(this.externalStoreId);
    }

    public long nextCommittingTransactionId() {
        return this.transactionIdStore.nextCommittingTransactionId();
    }

    public long committingTransactionId() {
        return this.transactionIdStore.committingTransactionId();
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, PageCursorTracer cursorTracer) {
        this.transactionIdStore.transactionCommitted(transactionId, checksum, commitTimestamp, cursorTracer);
    }

    public long getLastCommittedTransactionId() {
        return this.transactionIdStore.getLastCommittedTransactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.transactionIdStore.getLastCommittedTransaction();
    }

    public TransactionId getUpgradeTransaction() {
        return this.transactionIdStore.getUpgradeTransaction();
    }

    public long getLastClosedTransactionId() {
        return this.transactionIdStore.getLastClosedTransactionId();
    }

    public long[] getLastClosedTransaction() {
        return this.transactionIdStore.getLastClosedTransaction();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long byteOffset, long logVersion, PageCursorTracer cursorTracer) {
        this.transactionIdStore.setLastCommittedAndClosedTransactionId(transactionId, checksum, commitTimestamp, byteOffset, logVersion, cursorTracer);
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset, PageCursorTracer cursorTracer) {
        this.transactionIdStore.transactionClosed(transactionId, logVersion, byteOffset, cursorTracer);
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, boolean missingLogs, PageCursorTracer cursorTracer) {
        this.transactionIdStore.resetLastClosedTransaction(transactionId, logVersion, byteOffset, missingLogs, cursorTracer);
    }

    public void flush(PageCursorTracer cursorTracer) {
        this.transactionIdStore.flush(cursorTracer);
    }
}

