/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelViewNodeStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;

class LabelViewNodeStoreScanTest {
    private final StubStorageCursors cursors = new StubStorageCursors();
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final TokenScanReader labelScanReader = (TokenScanReader)Mockito.mock(TokenScanReader.class);
    private final IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private final Visitor<EntityTokenUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final Visitor<EntityUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);

    LabelViewNodeStoreScanTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)this.labelScanReader);
    }

    @Test
    void iterateOverLabeledNodeIds() {
        PrimitiveLongResourceIterator labeledNodes = PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{1L, 2L, 4L, 8L});
        long highId = 15L;
        for (long i = 0L; i < highId; ++i) {
            this.cursors.withNode(i);
        }
        int[] labelIds = new int[]{1, 2};
        Mockito.when((Object)this.labelScanReader.entitiesWithAnyOfTokens((int[])ArgumentMatchers.eq((Object)labelIds), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)labeledNodes);
        LabelViewNodeStoreScan<Exception> storeScan = this.getLabelScanViewStoreScan(labelIds);
        EntityIdIterator idIterator = storeScan.getEntityIdIterator();
        Assertions.assertThat((long)idIterator.next()).isEqualTo(1L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(2L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(4L);
        Assertions.assertThat((long)idIterator.next()).isEqualTo(8L);
        Assertions.assertThat((boolean)idIterator.hasNext()).isEqualTo(false);
    }

    private LabelViewNodeStoreScan<Exception> getLabelScanViewStoreScan(int[] labelIds) {
        return new LabelViewNodeStoreScan((StorageReader)this.cursors, LockService.NO_LOCK_SERVICE, this.labelScanStore, this.labelUpdateVisitor, this.propertyUpdateVisitor, labelIds, this.propertyKeyIdFilter, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }
}

