/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ConvertersTest {
    @Inject
    private TestDirectory directory;

    ConvertersTest() {
    }

    @Test
    void shouldSortFilesByNumberCleverly() throws Exception {
        Path file1 = this.existenceOfFile("file1");
        Path file123 = this.existenceOfFile("file123");
        Path file12 = this.existenceOfFile("file12");
        Path file2 = this.existenceOfFile("file2");
        Path file32 = this.existenceOfFile("file32");
        Object[] files = (Path[])Converters.regexFiles((boolean)true).apply(this.directory.file("file").toAbsolutePath().toString() + ".*");
        Assertions.assertArrayEquals((Object[])new Path[]{file1, file2, file12, file32, file123}, (Object[])files);
    }

    private Path existenceOfFile(String name) throws IOException {
        Path file = this.directory.file(name);
        Files.createFile(file, new FileAttribute[0]);
        return file;
    }
}

