/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public final class LogTestUtils {
    private LogTestUtils() {
    }

    public static Path[] filterNeostoreLogicalLog(LogFiles logFiles, FileSystemAbstraction fileSystem, LogHook<LogEntry> filter) throws IOException {
        Path[] files;
        for (Path file : files = logFiles.logFiles()) {
            LogTestUtils.filterTransactionLogFile(fileSystem, file, filter, ChannelNativeAccessor.EMPTY_ACCESSOR);
        }
        return files;
    }

    private static void filterTransactionLogFile(FileSystemAbstraction fileSystem, Path file, LogHook<LogEntry> filter, ChannelNativeAccessor channelNativeAccessor) throws IOException {
        filter.file(file);
        try (StoreChannel in = fileSystem.read(file);){
            LogEntry entry;
            LogHeader logHeader = LogHeaderReader.readLogHeader((ByteBuffer)ByteBuffers.allocate((int)64, (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ReadableByteChannel)in, (boolean)true, (Path)file);
            assert (logHeader != null) : "Looks like we tried to read a log header of an empty pre-allocated file.";
            PhysicalLogVersionedStoreChannel inChannel = new PhysicalLogVersionedStoreChannel(in, logHeader.getLogVersion(), logHeader.getLogFormatVersion(), file, channelNativeAccessor);
            ReadAheadLogChannel inBuffer = new ReadAheadLogChannel((LogVersionedStoreChannel)inChannel, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory());
            while ((entry = entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)inBuffer)) != null) {
                filter.test(entry);
            }
        }
    }

    public static class CountingLogHook<RECORD>
    extends LogHookAdapter<RECORD> {
        private int count;

        @Override
        public boolean test(RECORD item) {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static abstract class LogHookAdapter<RECORD>
    implements LogHook<RECORD> {
        @Override
        public void file(Path file) {
        }

        @Override
        public void done(Path file) {
        }
    }

    public static interface LogHook<RECORD>
    extends Predicate<RECORD> {
        public void file(Path var1);

        public void done(Path var1);
    }
}

