/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Objects;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class PortUtils {
    private PortUtils() {
    }

    public static int getBoltPort(GraphDatabaseService db) {
        return PortUtils.getConnectorAddress((GraphDatabaseAPI)db, "bolt").getPort();
    }

    public static HostnamePort getConnectorAddress(GraphDatabaseAPI db, String connectorKey) {
        ConnectorPortRegister portRegister = (ConnectorPortRegister)db.getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return Objects.requireNonNull(portRegister.getLocalAddress(connectorKey), "Connector not found: " + connectorKey);
    }
}

