/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.query.CompilerInfo;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;
import org.neo4j.kernel.api.query.PageCounterValues;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.api.query.SimpleState;
import org.neo4j.kernel.api.query.WaitingOnLockEvent;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.OptionalMemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class ExecutingQuery {
    private static final AtomicLongFieldUpdater<ExecutingQuery> WAIT_TIME = AtomicLongFieldUpdater.newUpdater(ExecutingQuery.class, "waitTimeNanos");
    private final long queryId;
    private final LockTracer lockTracer = this::waitForLock;
    private final String username;
    private final ClientConnectionInfo clientConnection;
    private final String rawQueryText;
    private final MapValue rawQueryParameters;
    private final long startTimeNanos;
    private final long startTimestampMillis;
    private final Map<String, Object> transactionAnnotationData;
    private final long threadExecutingTheQueryId;
    private final String threadExecutingTheQueryName;
    private final SystemNanoClock clock;
    private final CpuClock cpuClock;
    private final long cpuTimeNanosWhenQueryStarted;
    private CompilerInfo compilerInfo;
    private long compilationCompletedNanos;
    private String obfuscatedQueryText;
    private MapValue obfuscatedQueryParameters;
    private QueryExecutionType.QueryType queryType;
    private Supplier<ExecutionPlanDescription> planDescriptionSupplier;
    private volatile ExecutingQueryStatus status = SimpleState.parsing();
    private volatile ExecutingQuery previousQuery;
    private volatile long waitTimeNanos;
    private OptionalMemoryTracker memoryTracker;
    private TransactionBinding transactionBinding = TransactionBinding.EMPTY;

    public ExecutingQuery(long queryId, ClientConnectionInfo clientConnection, String username, String queryText, MapValue queryParameters, Map<String, Object> transactionAnnotationData, long threadExecutingTheQueryId, String threadExecutingTheQueryName, SystemNanoClock clock, CpuClock cpuClock, boolean trackQueryAllocations) {
        this.cpuTimeNanosWhenQueryStarted = cpuClock.cpuTimeNanos(threadExecutingTheQueryId);
        this.startTimeNanos = clock.nanos();
        this.startTimestampMillis = clock.millis();
        this.queryId = queryId;
        this.clientConnection = clientConnection;
        this.username = username;
        this.rawQueryText = queryText;
        this.rawQueryParameters = queryParameters;
        this.transactionAnnotationData = transactionAnnotationData;
        this.threadExecutingTheQueryId = threadExecutingTheQueryId;
        this.threadExecutingTheQueryName = threadExecutingTheQueryName;
        this.clock = clock;
        this.cpuClock = cpuClock;
        this.memoryTracker = trackQueryAllocations ? OptionalMemoryTracker.ZERO : OptionalMemoryTracker.NONE;
    }

    public ExecutingQuery(long queryId, ClientConnectionInfo clientConnection, NamedDatabaseId namedDatabaseId, String username, String queryText, MapValue queryParameters, Map<String, Object> transactionAnnotationData, LongSupplier activeLockCount, LongSupplier hitsSupplier, LongSupplier faultsSupplier, long threadExecutingTheQueryId, String threadExecutingTheQueryName, SystemNanoClock clock, CpuClock cpuClock, boolean trackQueryAllocations) {
        this(queryId, clientConnection, username, queryText, queryParameters, transactionAnnotationData, threadExecutingTheQueryId, threadExecutingTheQueryName, clock, cpuClock, trackQueryAllocations);
        this.onTransactionBound(new TransactionBinding(namedDatabaseId, hitsSupplier, faultsSupplier, activeLockCount));
    }

    public void onTransactionBound(TransactionBinding transactionBinding) {
        this.transactionBinding = transactionBinding;
    }

    public void onObfuscatorReady(QueryObfuscator queryObfuscator) {
        if (this.status != SimpleState.parsing()) {
            return;
        }
        try {
            this.obfuscatedQueryText = queryObfuscator.obfuscateText(this.rawQueryText);
            this.obfuscatedQueryParameters = queryObfuscator.obfuscateParameters(this.rawQueryParameters);
        }
        catch (Exception ignore) {
            this.obfuscatedQueryText = null;
            this.obfuscatedQueryParameters = null;
        }
        this.status = SimpleState.planning();
    }

    public void onCompilationCompleted(CompilerInfo compilerInfo, QueryExecutionType.QueryType queryType, Supplier<ExecutionPlanDescription> planDescriptionSupplier) {
        this.assertExpectedStatus(SimpleState.planning());
        this.compilerInfo = compilerInfo;
        this.compilationCompletedNanos = this.clock.nanos();
        this.planDescriptionSupplier = planDescriptionSupplier;
        this.queryType = queryType;
        this.status = SimpleState.planned();
    }

    public void onExecutionStarted(OptionalMemoryTracker memoryTracker) {
        this.assertExpectedStatus(SimpleState.planned());
        this.memoryTracker = memoryTracker;
        this.status = SimpleState.running();
    }

    public void onRetryAttempted() {
        this.assertExpectedStatus(SimpleState.running());
        this.compilerInfo = null;
        this.compilationCompletedNanos = 0L;
        this.planDescriptionSupplier = null;
        this.queryType = null;
        this.memoryTracker = OptionalMemoryTracker.NONE;
        this.obfuscatedQueryParameters = null;
        this.obfuscatedQueryText = null;
        this.status = SimpleState.parsing();
    }

    public LockTracer lockTracer() {
        return this.lockTracer;
    }

    public QuerySnapshot snapshot() {
        MapValue queryParameters;
        String queryText;
        long currentTimeNanos;
        long cpuTimeNanos;
        ExecutingQueryStatus status;
        do {
            status = this.status;
            long waitTimeNanos = this.waitTimeNanos;
            cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.threadExecutingTheQueryId);
            currentTimeNanos = this.clock.nanos();
            queryText = this.obfuscatedQueryText;
            queryParameters = this.obfuscatedQueryParameters;
        } while (this.status != status);
        long compilationCompletedNanos = this.compilationCompletedNanos;
        CompilerInfo planner = status.isParsingOrPlanning() ? null : this.compilerInfo;
        List<ActiveLock> waitingOnLocks = status.isWaitingOnLocks() ? status.waitingOnLocks() : Collections.emptyList();
        long totalActiveLocks = this.transactionBinding.activeLockCount.getAsLong();
        PageCounterValues pageCounters = new PageCounterValues(this.transactionBinding.hitsSupplier, this.transactionBinding.faultsSupplier);
        long compilationTimeNanos = (status.isParsingOrPlanning() ? currentTimeNanos : compilationCompletedNanos) - this.startTimeNanos;
        long elapsedTimeNanos = currentTimeNanos - this.startTimeNanos;
        return new QuerySnapshot(this, planner, pageCounters, TimeUnit.NANOSECONDS.toMicros(compilationTimeNanos), TimeUnit.NANOSECONDS.toMicros(elapsedTimeNanos), (cpuTimeNanos -= this.cpuTimeNanosWhenQueryStarted) == 0L && this.cpuTimeNanosWhenQueryStarted == -1L ? -1L : TimeUnit.NANOSECONDS.toMicros(cpuTimeNanos), TimeUnit.NANOSECONDS.toMicros(waitTimeNanos += status.waitTimeNanos(currentTimeNanos)), status.name(), status.toMap(currentTimeNanos), waitingOnLocks, totalActiveLocks - this.transactionBinding.initialActiveLocks, this.memoryTracker.totalAllocatedMemory(), Optional.ofNullable(queryText), Optional.ofNullable(queryParameters));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingQuery that = (ExecutingQuery)o;
        return this.queryId == that.queryId;
    }

    public int hashCode() {
        return (int)(this.queryId ^ this.queryId >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public long internalQueryId() {
        return this.queryId;
    }

    public String id() {
        return Long.toString(this.internalQueryId());
    }

    public String username() {
        return this.username;
    }

    public String rawQueryText() {
        return this.rawQueryText;
    }

    public MapValue rawQueryParameters() {
        return this.rawQueryParameters;
    }

    Supplier<ExecutionPlanDescription> planDescriptionSupplier() {
        return this.planDescriptionSupplier;
    }

    public Optional<NamedDatabaseId> databaseId() {
        return Optional.ofNullable(this.transactionBinding.namedDatabaseId);
    }

    public long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public long elapsedNanos() {
        return this.clock.nanos() - this.startTimeNanos;
    }

    public Map<String, Object> transactionAnnotationData() {
        return this.transactionAnnotationData;
    }

    public long reportedWaitingTimeNanos() {
        return this.waitTimeNanos;
    }

    public long totalWaitingTimeNanos(long currentTimeNanos) {
        return this.waitTimeNanos + this.status.waitTimeNanos(currentTimeNanos);
    }

    ClientConnectionInfo clientConnection() {
        return this.clientConnection;
    }

    private LockWaitEvent waitForLock(LockType lockType, ResourceType resourceType, long userTransactionId, long[] resourceIds) {
        WaitingOnLockEvent event = new WaitingOnLockEvent(lockType, resourceType, userTransactionId, resourceIds, this, this.clock.nanos(), this.status);
        this.status = event;
        return event;
    }

    void doneWaitingOnLock(WaitingOnLockEvent waiting) {
        if (this.status != waiting) {
            return;
        }
        WAIT_TIME.addAndGet(this, waiting.waitTimeNanos(this.clock.nanos()));
        this.status = waiting.previousStatus();
    }

    private void assertExpectedStatus(ExecutingQueryStatus expectedStatus) {
        if (this.status != expectedStatus) {
            throw new IllegalStateException(String.format("Expected query in '%s' state, actual state is '%s'.", expectedStatus.name(), this.status.name()));
        }
    }

    public ExecutingQuery getPreviousQuery() {
        return this.previousQuery;
    }

    public void setPreviousQuery(ExecutingQuery previousQuery) {
        this.previousQuery = previousQuery;
    }

    public static class TransactionBinding {
        private final NamedDatabaseId namedDatabaseId;
        private final LongSupplier hitsSupplier;
        private final LongSupplier faultsSupplier;
        private final LongSupplier activeLockCount;
        private final long initialActiveLocks;
        public static final TransactionBinding EMPTY = new TransactionBinding(null, () -> 0L, () -> 0L, () -> 0L);

        public TransactionBinding(NamedDatabaseId namedDatabaseId, LongSupplier hitsSupplier, LongSupplier faultsSupplier, LongSupplier activeLockCount) {
            this.namedDatabaseId = namedDatabaseId;
            this.hitsSupplier = hitsSupplier;
            this.faultsSupplier = faultsSupplier;
            this.activeLockCount = activeLockCount;
            this.initialActiveLocks = activeLockCount.getAsLong();
        }
    }
}

