/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.FailedJobRunsStore;
import org.neo4j.kernel.impl.scheduler.ThreadPool;
import org.neo4j.scheduler.Group;
import org.neo4j.time.SystemNanoClock;

final class ThreadPoolManager {
    private final ConcurrentHashMap<Group, ThreadPool> pools;
    private final ThreadGroup topLevelGroup;
    private final SystemNanoClock clock;
    private final FailedJobRunsStore failedJobRunsStore;
    private final LongSupplier jobIdSupplier;
    private boolean shutdown;

    ThreadPoolManager(ThreadGroup topLevelGroup, SystemNanoClock clock, FailedJobRunsStore failedJobRunsStore, LongSupplier jobIdSupplier) {
        this.topLevelGroup = topLevelGroup;
        this.pools = new ConcurrentHashMap();
        this.clock = clock;
        this.failedJobRunsStore = failedJobRunsStore;
        this.jobIdSupplier = jobIdSupplier;
    }

    ThreadPool getThreadPool(Group group) {
        return this.getThreadPool(group, null);
    }

    ThreadPool getThreadPool(Group group, ThreadPool.ThreadPoolParameters parameters) {
        return this.pools.computeIfAbsent(group, g -> this.createThreadPool((Group)g, parameters));
    }

    boolean isStarted(Group group) {
        return this.pools.containsKey(group);
    }

    void assumeNotStarted(Group group) {
        if (this.isStarted(group)) {
            throw new IllegalStateException(group.groupName() + " is already been started. ");
        }
    }

    synchronized void forEachStarted(BiConsumer<Group, ThreadPool> consumer) {
        this.assertNotShutDown();
        this.pools.forEach(consumer);
    }

    private synchronized ThreadPool createThreadPool(Group group, ThreadPool.ThreadPoolParameters parameters) {
        this.assertNotShutDown();
        return new ThreadPool(group, this.topLevelGroup, Objects.requireNonNullElseGet(parameters, ThreadPool.ThreadPoolParameters::new), this.clock, this.failedJobRunsStore, this.jobIdSupplier);
    }

    private void assertNotShutDown() {
        if (this.shutdown) {
            throw new IllegalStateException("ThreadPoolManager is shutdown.");
        }
    }

    synchronized InterruptedException shutDownAll() {
        this.shutdown = true;
        this.pools.forEach((group, pool) -> pool.cancelAllJobs());
        this.pools.forEach((group, pool) -> pool.shutDown());
        return this.pools.values().stream().map(ThreadPool::getShutdownException).reduce(null, Exceptions::chain);
    }
}

