/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJobFactory;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
class LuceneIndexSamplerReleaseTaskControlUnderFusionTest {
    private static final int indexId = 1;
    private static final IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("index_1").materialise(1L);
    private static final IndexProviderDescriptor providerDescriptor = IndexProviderDescriptor.UNDECIDED;
    private static final DirectoryFactory.InMemoryDirectoryFactory luceneDirectoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private static final Config config = Config.defaults();
    private static final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
    private static final RuntimeException sampleException = new RuntimeException("Killroy messed with your index sample.");
    private static final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory dir;
    private IndexDirectoryStructure.Factory directoryFactory;

    LuceneIndexSamplerReleaseTaskControlUnderFusionTest() {
    }

    @BeforeEach
    void setup() {
        this.directoryFactory = IndexDirectoryStructure.directoriesByProvider((Path)this.dir.homePath());
    }

    @Test
    void failedIndexSamplingMustNotPreventIndexDrop() throws IOException, IndexEntryConflictException {
        LuceneIndexProvider luceneProvider = this.luceneProvider();
        this.makeSureIndexHasSomeData((IndexProvider)luceneProvider);
        IndexProvider failingProvider = this.failingProvider();
        FusionIndexProvider fusionProvider = this.createFusionProvider(luceneProvider, failingProvider);
        try (IndexAccessor fusionAccessor = fusionProvider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);){
            IndexSamplingJob indexSamplingJob = this.createIndexSamplingJob(fusionAccessor);
            try {
                indexSamplingJob.run();
            }
            catch (RuntimeException e) {
                Assertions.assertSame((Object)sampleException, (Object)e);
            }
            fusionAccessor.drop();
        }
    }

    private void makeSureIndexHasSomeData(IndexProvider provider) throws IOException, IndexEntryConflictException {
        try (IndexAccessor accessor = provider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);
             IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
            updater.process(IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)"some string")}));
        }
    }

    private FusionIndexProvider createFusionProvider(LuceneIndexProvider luceneProvider, IndexProvider failingProvider) {
        SlotSelector slotSelector = SlotSelector.nullInstance;
        return new FusionIndexProvider(failingProvider, (IndexProvider)luceneProvider, slotSelector, providerDescriptor, this.directoryFactory, this.fs, false);
    }

    private IndexSamplingJob createIndexSamplingJob(final IndexAccessor fusionAccessor) {
        IndexProxyAdapter indexProxy = new IndexProxyAdapter(){

            @Override
            public IndexDescriptor getDescriptor() {
                return descriptor;
            }

            @Override
            public IndexReader newReader() {
                return fusionAccessor.newReader();
            }
        };
        OnlineIndexSamplingJobFactory onlineIndexSamplingJobFactory = new OnlineIndexSamplingJobFactory(null, SchemaTestUtil.SIMPLE_NAME_LOOKUP, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL);
        return onlineIndexSamplingJobFactory.create(1L, (IndexProxy)indexProxy);
    }

    private LuceneIndexProvider luceneProvider() {
        return new LuceneIndexProvider(this.fs, (DirectoryFactory)luceneDirectoryFactory, this.directoryFactory, IndexProvider.Monitor.EMPTY, config, true);
    }

    private IndexProvider failingProvider() {
        return new IndexProvider.Adaptor(providerDescriptor, this.directoryFactory){

            public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) {
                return LuceneIndexSamplerReleaseTaskControlUnderFusionTest.this.failingIndexAccessor();
            }
        };
    }

    private IndexAccessor failingIndexAccessor() {
        return new IndexAccessor.Adapter(){

            public IndexReader newReader() {
                return new IndexReader.Adaptor(){

                    public IndexSampler createSampler() {
                        return cursorTracer -> {
                            throw sampleException;
                        };
                    }
                };
            }
        };
    }
}

