/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class EntityUpdatesTest {
    private static final long nodeId = 0L;
    private static final int labelId1 = 0;
    private static final int labelId2 = 1;
    private static final int unusedLabelId = 2;
    private static final int propertyKeyId1 = 0;
    private static final int propertyKeyId2 = 1;
    private static final int propertyKeyId3 = 2;
    private static final long[] label = new long[]{0L};
    private static final long[] allLabels = new long[]{0L, 1L};
    private static final long[] empty = new long[0];
    private static final LabelSchemaDescriptor index1 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
    private static final LabelSchemaDescriptor index2 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
    private static final LabelSchemaDescriptor index3 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{2});
    private static final LabelSchemaDescriptor index123 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0, 1, 2});
    private static final List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index123);
    private static final SchemaDescriptor nonSchemaIndex = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{0, 1}, (int[])new int[]{0, 1, 2});
    private static final StorageProperty property1 = new PropertyKeyValue(0, Values.of((Object)"Neo"));
    private static final StorageProperty property2 = new PropertyKeyValue(1, Values.of((Object)100L));
    private static final StorageProperty property3 = new PropertyKeyValue(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
    private static final Value[] values123 = new Value[]{property1.value(), property2.value(), property3.value()};

    EntityUpdatesTest() {
    }

    @Test
    void shouldNotGenerateUpdatesForEmptyNodeUpdates() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void useProvidedCursorForPropertiesOnNodesLoad() {
        PageCursorTracer cursorTracer = (PageCursorTracer)Mockito.mock(PageCursorTracer.class);
        StorageNodeCursor nodeCursor = (StorageNodeCursor)Mockito.mock(StorageNodeCursor.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)nodeCursor.hasProperties()).thenReturn((Object)true);
        Mockito.when((Object)nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)storageReader.allocateNodeCursor((PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)nodeCursor);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        updates.forIndexKeys(indexes, storageReader, EntityType.NODE, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocateNodeCursor(cursorTracer);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocatePropertyCursor(cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Test
    void useProvidedCursorForPropertiesOnRelationshipLoad() {
        PageCursorTracer cursorTracer = (PageCursorTracer)Mockito.mock(PageCursorTracer.class);
        StorageRelationshipScanCursor relationshipCursor = (StorageRelationshipScanCursor)Mockito.mock(StorageRelationshipScanCursor.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)relationshipCursor.hasProperties()).thenReturn((Object)true);
        Mockito.when((Object)relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)storageReader.allocateRelationshipScanCursor((PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)relationshipCursor);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        updates.forIndexKeys(indexes, storageReader, EntityType.RELATIONSHIP, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocateRelationshipScanCursor(cursorTracer);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocatePropertyCursor(cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Test
    void shouldNotGenerateUpdateForMultipleExistingPropertiesAndLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotGenerateUpdatesForLabelAdditionWithNoProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateForLabelAdditionWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})});
    }

    @Test
    void shouldGenerateUpdatesForLabelAdditionWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)});
    }

    @Test
    void shouldNotGenerateUpdateForPartialCompositeSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(index123), EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateForWhenCompletingCompositeSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(index123), EntityUpdatesTest.propertyLoader(property2), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)});
    }

    @Test
    void shouldNotGenerateUpdatesForLabelRemovalWithNoProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateForLabelRemovalWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})});
    }

    @Test
    void shouldGenerateUpdatesForLabelRemovalWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)});
    }

    @Test
    void shouldNotGenerateUpdatesForPropertyAdditionWithNoLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).added(property1.propertyKeyId(), property1.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdatesForSinglePropertyAdditionWithLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).added(property1.propertyKeyId(), property1.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})});
    }

    @Test
    void shouldGenerateUpdatesForMultiplePropertyAdditionWithLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)});
    }

    @Test
    void shouldNotGenerateUpdatesForLabelAddAndPropertyRemove() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).removed(property1.propertyKeyId(), property1.value()).removed(property2.propertyKeyId(), property2.value()).removed(property3.propertyKeyId(), property3.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotGenerateUpdatesForLabelRemoveAndPropertyAdd() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotLoadPropertyForLabelsAndNoPropertyChanges() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(index1), EntityUpdatesTest.assertNoLoading(), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotLoadPropertyForNoLabelsAndButPropertyAddition() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).added(property1.propertyKeyId(), property1.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(index1), EntityUpdatesTest.assertNoLoading(), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateForPartialNonSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])new Value[]{property1.value(), null, null})});
    }

    @Test
    void shouldGenerateUpdateForFullNonSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)});
    }

    @Test
    void shouldGenerateUpdateForSingleChangeNonSchemaIndex() {
        Value newValue2 = Values.of((Object)10L);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).changed(property2.propertyKeyId(), property2.value(), newValue2).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{property1.value(), newValue2, property3.value()})});
    }

    @Test
    void shouldGenerateUpdateForAllChangedNonSchemaIndex() {
        Value newValue1 = Values.of((Object)"Nio");
        Value newValue2 = Values.of((Object)10L);
        PointValue newValue3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{32.3, 15.6});
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).changed(property1.propertyKeyId(), property1.value(), newValue1).changed(property2.propertyKeyId(), property2.value(), newValue2).changed(property3.propertyKeyId(), property3.value(), (Value)newValue3).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{newValue1, newValue2, newValue3})});
    }

    @Test
    void shouldGenerateUpdateWhenRemovingLastPropForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).removed(property2.propertyKeyId(), property2.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property2), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])new Value[]{null, property2.value(), null})});
    }

    @Test
    void shouldGenerateUpdateWhenRemovingOnePropertyForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).removed(property2.propertyKeyId(), property2.value()).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{property1.value(), null, property3.value()})});
    }

    @Test
    void shouldGenerateUpdateWhenAddingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)});
    }

    @Test
    void shouldGenerateUpdateWhenAddingMultipleTokensForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(allLabels).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)});
    }

    @Test
    void shouldNotGenerateUpdateWhenAddingAnotherTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(allLabels).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotGenerateUpdateWhenAddingAnotherUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(new long[]{0L, 2L}).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateWhenSwitchingToUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(new long[]{2L}).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)});
    }

    @Test
    void shouldNotGenerateUpdateWhenRemovingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(allLabels).withTokensAfter(label).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateWhenRemovingLastTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        Assertions.assertThat((Iterable)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)});
    }

    private static StorageReader propertyLoader(StorageProperty ... properties) {
        StubStorageCursors stub = new StubStorageCursors();
        for (StorageProperty property : properties) {
            stub.propertyKeyTokenHolder().addToken(new NamedToken(String.valueOf(property.propertyKeyId()), property.propertyKeyId()));
        }
        HashMap<String, Value> propertyMap = new HashMap<String, Value>();
        for (StorageProperty p : properties) {
            propertyMap.put(String.valueOf(p.propertyKeyId()), p.value());
        }
        stub.withNode(0L).properties(propertyMap);
        return stub;
    }

    private static StorageReader assertNoLoading() {
        StorageReader reader = (StorageReader)Mockito.mock(StorageReader.class);
        IllegalStateException exception = new IllegalStateException("Should never attempt to load properties!");
        Mockito.when((Object)reader.allocateNodeCursor((PageCursorTracer)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocateRelationshipScanCursor((PageCursorTracer)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocateRelationshipTraversalCursor((PageCursorTracer)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocatePropertyCursor((PageCursorTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        return reader;
    }
}

