/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssert;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class DbmsDiagnosticsManagerTest {
    private static final NamedDatabaseId DEFAULT_DATABASE_ID = TestDatabaseIdRepository.randomNamedDatabaseId();
    private static final String DEFAULT_DATABASE_NAME = DEFAULT_DATABASE_ID.name();
    @Inject
    private TestDirectory directory;
    private DbmsDiagnosticsManager diagnosticsManager;
    private AssertableLogProvider logProvider;
    private DatabaseManager<StandaloneDatabaseContext> databaseManager;
    private StorageEngine storageEngine;
    private StorageEngineFactory storageEngineFactory;
    private Database defaultDatabase;
    private StandaloneDatabaseContext defaultContext;
    private Dependencies dependencies;

    DbmsDiagnosticsManagerTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.logProvider = new AssertableLogProvider();
        this.databaseManager = (DatabaseManager)Mockito.mock(DatabaseManager.class);
        this.storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        this.storageEngineFactory = (StorageEngineFactory)Mockito.mock(StorageEngineFactory.class);
        this.defaultContext = (StandaloneDatabaseContext)Mockito.mock(StandaloneDatabaseContext.class);
        this.defaultDatabase = this.prepareDatabase();
        Mockito.when((Object)this.storageEngineFactory.listStorageFiles((FileSystemAbstraction)ArgumentMatchers.any(), (DatabaseLayout)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        this.dependencies = new Dependencies();
        this.dependencies.satisfyDependency((Object)Config.defaults());
        this.dependencies.satisfyDependency(this.databaseManager);
        Mockito.when((Object)this.defaultContext.database()).thenReturn((Object)this.defaultDatabase);
        Mockito.when((Object)this.databaseManager.getDatabaseContext(DEFAULT_DATABASE_ID)).thenReturn(Optional.of(this.defaultContext));
        Mockito.when((Object)this.databaseManager.registeredDatabases()).thenReturn(new TreeMap<NamedDatabaseId, StandaloneDatabaseContext>(Collections.singletonMap(DEFAULT_DATABASE_ID, this.defaultContext)));
        this.diagnosticsManager = new DbmsDiagnosticsManager(this.dependencies, (LogService)new SimpleLogService((LogProvider)this.logProvider));
    }

    @Test
    void dumpSystemDiagnostics() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
        this.diagnosticsManager.dumpSystemDiagnostics();
        this.assertContainsSystemDiagnostics();
    }

    @Test
    void dumpDatabaseDiagnostics() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
        this.diagnosticsManager.dumpDatabaseDiagnostics(this.defaultDatabase);
        this.assertContainsDatabaseDiagnostics();
    }

    @Test
    void dumpDatabaseDiagnosticsNotInterleavedWithEachother() throws Throwable {
        Database secondDatabase = this.prepareDatabase(DatabaseIdFactory.from((String)"second", (UUID)UUID.randomUUID()));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
        Race race = new Race();
        race.addContestant(() -> this.diagnosticsManager.dumpDatabaseDiagnostics(this.defaultDatabase));
        race.addContestant(() -> this.diagnosticsManager.dumpDatabaseDiagnostics(secondDatabase));
        race.go();
        LogAssertions.assertThat((String)this.logProvider.serialize()).containsSubsequence(new CharSequence[]{"Database: ", "Version", "Store files", "Transaction log", "Database: ", "Version", "Store files", "Transaction log"});
    }

    @Test
    void dumpDatabaseDiagnosticsNotInterleaved() throws Throwable {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
        Race race = new Race().withRandomStartDelays();
        race.addContestant(() -> this.diagnosticsManager.dumpDatabaseDiagnostics(this.defaultDatabase));
        race.addContestant(() -> this.logProvider.getLog("test").info("Testlog message"));
        race.go();
        LogAssertions.assertThat((String)this.logProvider.serialize()).satisfiesAnyOf(string -> LogAssertions.assertThat((String)string).containsSubsequence(new CharSequence[]{"Database: ", "Version", "Store files", "Transaction log", "Testlog message"}), string -> LogAssertions.assertThat((String)string).containsSubsequence(new CharSequence[]{"Testlog message", "Database: ", "Version", "Store files", "Transaction log"}));
    }

    @Test
    void dumpDatabaseDiagnosticsContainsDbName() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
        this.diagnosticsManager.dumpDatabaseDiagnostics(this.defaultDatabase);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).eachMessageContains(this.defaultDatabase.getNamedDatabaseId().logPrefix());
    }

    @Test
    void dumpDiagnosticsEvenOnFailure() {
        DiagnosticsProvider diagnosticsProvider = new DiagnosticsProvider(){

            public String getDiagnosticsName() {
                return "foo";
            }

            public void dump(DiagnosticsLogger logger) {
                throw new RuntimeException("error during dump");
            }
        };
        this.dependencies.satisfyDependency((Object)diagnosticsProvider);
        this.diagnosticsManager.dumpAll();
        LogAssertions.assertThat((String)this.logProvider.serialize()).containsSubsequence(new CharSequence[]{"Failure while logging diagnostics", "error during dump", "System diagnostics", "foo", "Database: "});
    }

    @Test
    void dumpDiagnosticOfStoppedDatabase() {
        Mockito.when((Object)this.defaultDatabase.isStarted()).thenReturn((Object)false);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
        this.diagnosticsManager.dumpAll();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Database: " + DEFAULT_DATABASE_NAME.toLowerCase(), "Database is stopped."});
    }

    @Test
    void dumpDiagnosticsInConciseForm() {
        HashMap<NamedDatabaseId, StandaloneDatabaseContext> databaseMap = new HashMap<NamedDatabaseId, StandaloneDatabaseContext>();
        int numberOfDatabases = 1000;
        for (int i = 0; i < numberOfDatabases; ++i) {
            Database database = (Database)Mockito.mock(Database.class);
            NamedDatabaseId namedDatabaseId = TestDatabaseIdRepository.randomNamedDatabaseId();
            Mockito.when((Object)database.getNamedDatabaseId()).thenReturn((Object)namedDatabaseId);
            databaseMap.put(namedDatabaseId, new StandaloneDatabaseContext(database));
        }
        Mockito.when((Object)this.databaseManager.registeredDatabases()).thenReturn(new TreeMap(databaseMap));
        this.diagnosticsManager.dumpAll();
        LogAssert logAssertions = LogAssertions.assertThat((AssertableLogProvider)this.logProvider);
        String[] databaseNames = (String[])databaseMap.keySet().stream().map(NamedDatabaseId::name).toArray(String[]::new);
        logAssertions.containsMessagesOnce(databaseNames);
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void dumpNativeAccessProviderOnLinux() {
        this.diagnosticsManager.dumpAll();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Linux native access is available."});
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void dumpNativeAccessProviderOnNonLinux() {
        this.diagnosticsManager.dumpAll();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Native access is not available for current platform."});
    }

    @Test
    void dumpAllDiagnostics() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
        this.diagnosticsManager.dumpAll();
        this.assertContainsSystemDiagnostics();
        this.assertContainsDatabaseDiagnostics();
    }

    @Test
    void dumpAdditionalDiagnosticsIfPresent() {
        this.diagnosticsManager.dumpAll();
        this.assertNoAdditionalDiagnostics();
        DiagnosticsProvider diagnosticsProvider = new DiagnosticsProvider(){

            public String getDiagnosticsName() {
                return "foo";
            }

            public void dump(DiagnosticsLogger logger) {
            }
        };
        this.dependencies.satisfyDependency((Object)diagnosticsProvider);
        this.logProvider.clear();
        this.diagnosticsManager.dumpAll();
        this.assertContainingAdditionalDiagnostics(diagnosticsProvider);
    }

    private void assertContainsSystemDiagnostics() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"System diagnostics", "System memory information", "JVM memory information", "(IANA) TimeZone database version", "Operating system information", "System properties", "JVM information", "Java classpath", "Library path", "Network information", "DBMS config", "Container heuristics"});
    }

    private void assertContainingAdditionalDiagnostics(DiagnosticsProvider diagnosticsProvider) {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{diagnosticsProvider.getDiagnosticsName()});
    }

    private void assertNoAdditionalDiagnostics() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Additional diagnostics");
    }

    private void assertContainsDatabaseDiagnostics() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Database: " + DEFAULT_DATABASE_NAME.toLowerCase(), "Version", "Store files", "Transaction log"});
    }

    private Database prepareDatabase() throws IOException {
        return this.prepareDatabase(DEFAULT_DATABASE_ID);
    }

    private Database prepareDatabase(NamedDatabaseId databaseId) throws IOException {
        Database database = (Database)Mockito.mock(Database.class);
        Dependencies databaseDependencies = new Dependencies();
        databaseDependencies.satisfyDependency((Object)DbmsInfo.COMMUNITY);
        databaseDependencies.satisfyDependency((Object)this.storageEngine);
        databaseDependencies.satisfyDependency((Object)this.storageEngineFactory);
        databaseDependencies.satisfyDependency((Object)new DefaultFileSystemAbstraction());
        databaseDependencies.satisfyDependency((Object)LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.directory.homePath(), (FileSystemAbstraction)this.directory.getFileSystem()).withLogEntryReader((LogEntryReader)Mockito.mock(LogEntryReader.class)).build());
        Mockito.when((Object)database.getDependencyResolver()).thenReturn((Object)databaseDependencies);
        Mockito.when((Object)database.getNamedDatabaseId()).thenReturn((Object)databaseId);
        Mockito.when((Object)database.isStarted()).thenReturn((Object)true);
        Mockito.when((Object)database.getDatabaseLayout()).thenReturn((Object)DatabaseLayout.ofFlat((Path)this.directory.homePath()));
        return database;
    }
}

