/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.diagnostics.providers.TransactionRangeDiagnostics;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryDetachedCheckpoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.TransactionLogVersionSelector;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;
import org.neo4j.storageengine.api.StoreId;

class TransactionRangeDiagnosticsTest {
    TransactionRangeDiagnosticsTest() {
    }

    @Test
    void shouldLogCorrectTransactionLogDiagnosticsForNoTransactionLogs() throws IOException {
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.noLogs());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Transaction log files stored on file store:"}).containsMessages(new String[]{" - no transactions found"}).containsMessages(new String[]{" - no checkpoints found"});
    }

    @Test
    void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.logWithTransactions(logVersion, logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"oldest transaction " + (prevLogLastTxId + 1L), "version " + logVersion}).containsMessages(new String[]{" - existing transaction log versions "}).containsMessages(new String[]{" - no checkpoints found"});
    }

    @Test
    void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInSecondOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.logWithTransactionsInNextToOldestLog(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"oldest transaction " + (prevLogLastTxId + 1L), "version " + (logVersion + 1L)}).containsMessages(new String[]{" - no checkpoints found"});
    }

    @Test
    void shouldLogCorrectTransactionLogDiagnosticsForTransactionsAndCheckpointLogs() throws Exception {
        long txLogLowVersion = 2L;
        long txLogHighVersion = 10L;
        long checkpointLogLowVersion = 0L;
        long checkpointLogHighVersion = 3L;
        StoreId storeId = new StoreId(12345L);
        LogPosition checkpointLogPosition = new LogPosition(checkpointLogHighVersion, 34L);
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.logs(TransactionRangeDiagnosticsTest.transactionLogsWithTransaction(txLogLowVersion, txLogHighVersion, 42L), this.checkpointLogsWithLastCheckpoint(checkpointLogLowVersion, checkpointLogHighVersion, new CheckpointInfo(new LogEntryDetachedCheckpoint(0, checkpointLogPosition, 1234L, storeId, "testing"), checkpointLogPosition))));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{" - existing transaction log versions " + txLogLowVersion + "-" + txLogHighVersion}).containsMessages(new String[]{" - existing checkpoint log versions " + checkpointLogLowVersion + "-" + checkpointLogHighVersion});
    }

    @Test
    void shouldLogNoCheckpointFoundForEmptyPresentCheckpointLog() throws IOException {
        Database database = TransactionRangeDiagnosticsTest.databaseWithLogFilesContainingLowestTxId(TransactionRangeDiagnosticsTest.logs((ThrowingConsumer<LogFile, IOException>)((ThrowingConsumer)transactionLogs -> {}), this.checkpointLogsWithLastCheckpoint(0L, 0L, null)));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log logger = logProvider.getLog(this.getClass());
        new TransactionRangeDiagnostics(database).dump(arg_0 -> ((Log)logger).info(arg_0));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{" - no transactions found"}).containsMessages(new String[]{" - existing checkpoint log versions 0-0"}).containsMessages(new String[]{" - no checkpoints found"});
    }

    private static Database databaseWithLogFilesContainingLowestTxId(LogFiles files) {
        Dependencies dependencies = (Dependencies)Mockito.mock(Dependencies.class);
        Mockito.when((Object)((LogFiles)dependencies.resolveDependency(LogFiles.class))).thenReturn((Object)files);
        Database database = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)database.getDependencyResolver()).thenReturn((Object)dependencies);
        return database;
    }

    private static LogFiles logWithTransactionsInNextToOldestLog(long logVersion, long prevLogLastTxId) throws IOException {
        LogFiles files = TransactionRangeDiagnosticsTest.logWithTransactions(logVersion, logVersion + 1L, prevLogLastTxId);
        LogFile logFile = files.getLogFile();
        Mockito.when((Object)logFile.hasAnyEntries(logVersion)).thenReturn((Object)false);
        return files;
    }

    private ThrowingConsumer<CheckpointFile, IOException> checkpointLogsWithLastCheckpoint(long lowVersion, long highVersion, CheckpointInfo lastCheckpoint) {
        return checkpointLogs -> {
            Mockito.when((Object)checkpointLogs.getLowestLogVersion()).thenReturn((Object)lowVersion);
            Mockito.when((Object)checkpointLogs.getHighestLogVersion()).thenReturn((Object)highVersion);
            Mockito.when((Object)checkpointLogs.findLatestCheckpoint()).thenReturn(Optional.ofNullable(lastCheckpoint));
        };
    }

    private static LogFiles logWithTransactions(long lowVersion, long highVersion, long headerTxId) throws IOException {
        return TransactionRangeDiagnosticsTest.logs(TransactionRangeDiagnosticsTest.transactionLogsWithTransaction(lowVersion, highVersion, headerTxId), (ThrowingConsumer<CheckpointFile, IOException>)((ThrowingConsumer)checkpointLogs -> {}));
    }

    private static ThrowingConsumer<LogFile, IOException> transactionLogsWithTransaction(long lowVersion, long highVersion, long headerTxId) {
        return transactionLogs -> {
            Mockito.when((Object)transactionLogs.getLowestLogVersion()).thenReturn((Object)lowVersion);
            Mockito.when((Object)transactionLogs.getHighestLogVersion()).thenReturn((Object)highVersion);
            for (long version = lowVersion; version <= highVersion; ++version) {
                Mockito.when((Object)transactionLogs.hasAnyEntries(version)).thenReturn((Object)true);
                Mockito.when((Object)transactionLogs.versionExists(version)).thenReturn((Object)true);
                Mockito.when((Object)transactionLogs.extractHeader(version)).thenReturn((Object)new LogHeader(TransactionLogVersionSelector.LATEST.versionByte(), version, headerTxId, 64L));
            }
        };
    }

    private static LogFiles noLogs() throws IOException {
        return TransactionRangeDiagnosticsTest.logs((ThrowingConsumer<LogFile, IOException>)((ThrowingConsumer)transactionLogs -> Mockito.when((Object)transactionLogs.getLowestLogVersion()).thenReturn((Object)-1L)), (ThrowingConsumer<CheckpointFile, IOException>)((ThrowingConsumer)checkpointFiles -> Mockito.when((Object)checkpointFiles.getLowestLogVersion()).thenReturn((Object)-1L)));
    }

    private static LogFiles logs(ThrowingConsumer<LogFile, IOException> transactionLogs, ThrowingConsumer<CheckpointFile, IOException> checkpointLogs) throws IOException {
        LogFiles files = (LogFiles)Mockito.mock(TransactionLogFiles.class);
        Mockito.when((Object)files.logFilesDirectory()).thenReturn((Object)Path.of(".", new String[0]));
        LogFile transactionFiles = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)files.getLogFile()).thenReturn((Object)transactionFiles);
        transactionLogs.accept((Object)transactionFiles);
        CheckpointFile checkpointFiles = (CheckpointFile)Mockito.mock(CheckpointFile.class);
        Mockito.when((Object)files.getCheckpointFile()).thenReturn((Object)checkpointFiles);
        checkpointLogs.accept((Object)checkpointFiles);
        return files;
    }
}

