/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseException;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.DoubleLatch;

class KernelTransactionImplementationTest
extends KernelTransactionTestBase {
    KernelTransactionImplementationTest() {
    }

    private static Stream<Arguments> parameters() {
        Consumer<KernelTransaction> readTxInitializer = tx -> {};
        Consumer<KernelTransaction> writeTxInitializer = tx -> ((KernelTransactionImplementation)tx).txState().nodeDoCreate(42L);
        return Stream.of(Arguments.arguments((Object[])new Object[]{"readOperationsInNewTransaction", false, readTxInitializer}), Arguments.arguments((Object[])new Object[]{"write", true, writeTxInitializer}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void changeTransactionTracingWithoutRestart(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            transactionInitializer.accept((KernelTransaction)transaction);
            Assertions.assertSame((Object)TransactionInitializationTrace.NONE, (Object)transaction.getInitializationTrace());
            transaction.success();
        }
        this.config.setDynamic(GraphDatabaseSettings.transaction_tracing_level, (Object)GraphDatabaseSettings.TransactionTracingLevel.ALL, this.getClass().getSimpleName());
        transaction = this.newTransaction(this.loginContext(isWriteTx));
        try {
            transactionInitializer.accept((KernelTransaction)transaction);
            Assertions.assertNotSame((Object)TransactionInitializationTrace.NONE, (Object)transaction.getInitializationTrace());
            transaction.success();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void emptyMetadataReturnedWhenMetadataIsNotSet(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            Map metaData = transaction.getMetaData();
            Assertions.assertTrue((boolean)metaData.isEmpty());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void accessSpecifiedTransactionMetadata(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            Map externalMetadata = MapUtil.map((Object[])new Object[]{"Robot", "Bender", "Human", "Fry"});
            transaction.setMetaData(externalMetadata);
            Map transactionMetadata = transaction.getMetaData();
            Assertions.assertFalse((boolean)transactionMetadata.isEmpty());
            Assertions.assertEquals((Object)"Bender", transactionMetadata.get("Robot"));
            Assertions.assertEquals((Object)"Fry", transactionMetadata.get("Human"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldCommitSuccessfulTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            transactionInitializer.accept((KernelTransaction)transaction);
            transaction.commit();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(true, isWriteTx);
        this.verifyTransactionSizeInteractionWithMonitor();
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldRollbackUnsuccessfulTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            transactionInitializer.accept((KernelTransaction)transaction);
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldRollbackFailedTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            transactionInitializer.accept((KernelTransaction)transaction);
            transaction.rollback();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldRollbackAndThrowOnFailedAndSuccess(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        Assertions.assertThrows(NotInTransactionException.class, () -> {
            try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
                transactionInitializer.accept((KernelTransaction)transaction);
                transaction.rollback();
                transaction.commit();
            }
        });
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldRollbackOnClosingTerminatedTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        Assertions.assertThrows(TransactionTerminatedException.class, () -> ((KernelTransaction)transaction).commit());
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldRollbackOnClosingSuccessfulButTerminatedTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            transactionInitializer.accept((KernelTransaction)transaction);
            transaction.markForTermination((Status)Status.General.UnknownError);
            Assertions.assertEquals((Object)Status.General.UnknownError, transaction.getReasonIfTerminated().get());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldRollbackOnClosingTerminatedButSuccessfulTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        Assertions.assertEquals((Object)Status.General.UnknownError, transaction.getReasonIfTerminated().get());
        Assertions.assertThrows(TransactionTerminatedException.class, () -> ((KernelTransaction)transaction).commit());
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldNotDowngradeFailureState(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            transactionInitializer.accept((KernelTransaction)transaction);
            transaction.markForTermination((Status)Status.General.UnknownError);
            Assertions.assertEquals((Object)Status.General.UnknownError, transaction.getReasonIfTerminated().get());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldIgnoreTerminateAfterCommit(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        transactionInitializer.accept((KernelTransaction)transaction);
        transaction.commit();
        transaction.markForTermination((Status)Status.General.UnknownError);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(true, isWriteTx);
        this.verifyTransactionSizeInteractionWithMonitor();
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldIgnoreTerminateAfterRollback(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        transactionInitializer.accept((KernelTransaction)transaction);
        transaction.close();
        transaction.markForTermination((Status)Status.General.UnknownError);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldThrowOnTerminationInCommit(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        Assertions.assertThrows(TransactionTerminatedException.class, () -> ((KernelTransaction)transaction).commit());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldIgnoreTerminationDuringRollback(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        transaction.close();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldAllowTerminatingFromADifferentThread(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        DoubleLatch latch = new DoubleLatch(1);
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        transactionInitializer.accept((KernelTransaction)transaction);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<?> terminationFuture = executorService.submit(() -> KernelTransactionImplementationTest.lambda$shouldAllowTerminatingFromADifferentThread$3(latch, (KernelTransaction)transaction));
            latch.startAndWaitForAllToStartAndFinish();
            Assertions.assertNull(terminationFuture.get(1L, TimeUnit.MINUTES));
            Assertions.assertThrows(TransactionTerminatedException.class, () -> ((KernelTransaction)transaction).commit());
        }
        finally {
            executorService.shutdownNow();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionFinished(false, isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldUseStartTimeAndTxIdFromWhenStartingTxAsHeader(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        long startingTime = this.clock.millis();
        ((StorageEngine)Mockito.doAnswer(invocation -> {
            Collection commands = (Collection)invocation.getArgument(0);
            commands.add((StorageCommand)Mockito.mock(StorageCommand.class));
            return null;
        }).when((Object)this.storageEngine)).createCommands((Collection)ArgumentMatchers.any(Collection.class), (ReadableTransactionState)ArgumentMatchers.any(TransactionState.class), (StorageReader)ArgumentMatchers.any(StorageReader.class), (CommandCreationContext)ArgumentMatchers.any(CommandCreationContext.class), (ResourceLocker)ArgumentMatchers.any(ResourceLocker.class), ArgumentMatchers.anyLong(), (TxStateVisitor.Decorator)ArgumentMatchers.any(TxStateVisitor.Decorator.class), (PageCursorTracer)ArgumentMatchers.any(PageCursorTracer.class), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        try (KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));){
            SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)Mockito.mock(Locks.Client.class));
            transaction.initialize(5L, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.IMPLICIT, SecurityContext.AUTH_DISABLED, 0L, 1L, ClientConnectionInfo.EMBEDDED_CONNECTION);
            transaction.txState().nodeDoCreate(1L);
            this.clock.forward(5L, TimeUnit.MILLISECONDS);
            Mockito.when((Object)this.metadataProvider.getLastCommittedTransactionId()).thenReturn((Object)7L);
            transaction.success();
        }
        Assertions.assertEquals((long)5L, (long)this.getObservedFirstTransaction().getLatestCommittedTxWhenStarted());
        Assertions.assertEquals((long)startingTime, (long)this.getObservedFirstTransaction().getTimeStarted());
        Assertions.assertEquals((long)(startingTime + 5L), (long)this.getObservedFirstTransaction().getTimeCommitted());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void successfulTxShouldNotifyKernelTransactionsThatItIsClosed(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx));
        tx.success();
        tx.close();
        ((Pool)Mockito.verify((Object)this.txPool)).release((Object)tx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void failedTxShouldNotifyKernelTransactionsThatItIsClosed(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx));
        tx.failure();
        tx.close();
        ((Pool)Mockito.verify((Object)this.txPool)).release((Object)tx);
    }

    private void verifyExtraInteractionWithTheMonitor(TransactionMonitor transactionMonitor, boolean isWriteTx) {
        if (isWriteTx) {
            ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).upgradeToWriteTransaction();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{transactionMonitor});
    }

    private void verifyTransactionSizeInteractionWithMonitor() {
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).addHeapTransactionSize(ArgumentMatchers.anyLong());
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).addNativeTransactionSize(ArgumentMatchers.anyLong());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldIncrementReuseCounterOnReuse(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.loginContext(isWriteTx));
        int reuseCount = transaction.getReuseCount();
        transaction.close();
        SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
        transaction.initialize(1L, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.IMPLICIT, this.loginContext(isWriteTx).authorize(LoginContext.IdLookup.EMPTY, "neo4j"), 0L, 1L, ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertEquals((int)(reuseCount + 1), (int)transaction.getReuseCount());
    }

    @Test
    void markForTerminationNotInitializedTransaction() {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        tx.markForTermination((Status)Status.General.UnknownError);
        Assertions.assertEquals((Object)Status.General.UnknownError, tx.getReasonIfTerminated().get());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void markForTerminationInitializedTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx), locksClient);
        tx.markForTermination((Status)Status.General.UnknownError);
        Assertions.assertEquals((Object)Status.General.UnknownError, tx.getReasonIfTerminated().get());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void markForTerminationTerminatedTransaction(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx), locksClient);
        transactionInitializer.accept((KernelTransaction)tx);
        tx.markForTermination((Status)Status.Transaction.Terminated);
        tx.markForTermination((Status)Status.Transaction.Outdated);
        tx.markForTermination((Status)Status.Transaction.LockClientStopped);
        Assertions.assertEquals((Object)Status.Transaction.Terminated, tx.getReasonIfTerminated().get());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void terminatedTxMarkedNeitherSuccessNorFailureClosesWithoutThrowing(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx), locksClient);
        transactionInitializer.accept((KernelTransaction)tx);
        tx.markForTermination((Status)Status.General.UnknownError);
        tx.close();
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void terminatedTxMarkedForSuccessThrowsOnClose(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx), locksClient);
        transactionInitializer.accept((KernelTransaction)tx);
        tx.success();
        tx.markForTermination((Status)Status.General.UnknownError);
        Assertions.assertThrows(TransactionTerminatedException.class, () -> ((KernelTransactionImplementation)tx).close());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void terminatedTxMarkedForFailureClosesWithoutThrowing(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx), locksClient);
        transactionInitializer.accept((KernelTransaction)tx);
        tx.failure();
        tx.markForTermination((Status)Status.General.UnknownError);
        tx.close();
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(isWriteTx);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void terminatedTxMarkedForBothSuccessAndFailureThrowsOnClose(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx), locksClient);
        transactionInitializer.accept((KernelTransaction)tx);
        tx.success();
        tx.failure();
        tx.markForTermination((Status)Status.General.UnknownError);
        Assertions.assertThrows(TransactionTerminatedException.class, () -> ((KernelTransactionImplementation)tx).close());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void txMarkedForBothSuccessAndFailureThrowsOnClose(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx), locksClient);
        tx.success();
        tx.failure();
        Assertions.assertThrows(TransactionFailureException.class, () -> ((KernelTransactionImplementation)tx).close());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void initializedTransactionShouldHaveNoTerminationReason(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx));
        Assertions.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldReportCorrectTerminationReason(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) {
        Status.Transaction status = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx));
        tx.markForTermination((Status)status);
        Assertions.assertSame((Object)status, tx.getReasonIfTerminated().get());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void closedTransactionShouldHaveNoTerminationReason(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        KernelTransactionImplementation tx = this.newTransaction(this.loginContext(isWriteTx));
        tx.markForTermination((Status)Status.Transaction.Terminated);
        tx.close();
        Assertions.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
    }

    @Test
    void transactionWithCustomTimeout() {
        long transactionTimeout = 5L;
        KernelTransactionImplementation transaction = this.newTransaction(transactionTimeout);
        Assertions.assertEquals((long)transactionTimeout, (long)transaction.timeout(), (String)"Transaction should have custom configured timeout.");
    }

    @Test
    void transactionStartTime() {
        long startTime = this.clock.forward(5L, TimeUnit.MINUTES).millis();
        KernelTransactionImplementation transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        Assertions.assertEquals((long)startTime, (long)transaction.startTime(), (String)"Transaction start time should be the same as clock time.");
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void markForTerminationWithCorrectReuseCount(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        int reuseCount = 10;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        this.initializeAndClose(tx, reuseCount, isWriteTx);
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locksClient);
        tx.initialize(42L, 42L, (StatementLocks)statementLocks, KernelTransaction.Type.IMPLICIT, this.loginContext(isWriteTx).authorize(LoginContext.IdLookup.EMPTY, "neo4j"), 0L, 0L, ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertTrue((boolean)tx.markForTermination((long)reuseCount, (Status)terminationReason));
        Assertions.assertEquals((Object)terminationReason, tx.getReasonIfTerminated().get());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void markForTerminationWithIncorrectReuseCount(String name, boolean isWriteTx, Consumer<KernelTransaction> transactionInitializer) throws Exception {
        int reuseCount = 13;
        int nextReuseCount = reuseCount + 2;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        this.initializeAndClose(tx, reuseCount, isWriteTx);
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locksClient);
        tx.initialize(42L, 42L, (StatementLocks)statementLocks, KernelTransaction.Type.IMPLICIT, this.loginContext(isWriteTx).authorize(LoginContext.IdLookup.EMPTY, "neo4j"), 0L, 0L, ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertFalse((boolean)tx.markForTermination((long)nextReuseCount, (Status)terminationReason));
        Assertions.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
        ((Locks.Client)Mockito.verify((Object)locksClient, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    void resetTransactionStatisticsOnRelease() throws TransactionFailureException {
        KernelTransactionImplementation transaction = this.newTransaction(1000L);
        transaction.getStatistics().addWaitingTime(1L);
        transaction.getStatistics().addWaitingTime(1L);
        Assertions.assertEquals((long)2L, (long)transaction.getStatistics().getWaitingTimeNanos(0L));
        transaction.close();
        Assertions.assertEquals((long)0L, (long)transaction.getStatistics().getWaitingTimeNanos(0L));
    }

    @Test
    void reportTransactionStatistics() {
        KernelTransactionImplementation transaction = this.newTransaction(100L);
        transaction.memoryTracker().allocateHeap(13L);
        transaction.memoryTracker().allocateNative(14L);
        KernelTransactionImplementation.Statistics statistics = new KernelTransactionImplementation.Statistics(transaction, new AtomicReference<ThreadBasedCpuClock>(new ThreadBasedCpuClock()));
        PredictablePageCursorTracer tracer = new PredictablePageCursorTracer();
        statistics.init(2L, (PageCursorTracer)tracer);
        Assertions.assertEquals((long)2L, (long)statistics.cpuTimeMillis());
        Assertions.assertEquals((long)13L, (long)statistics.estimatedHeapMemory());
        Assertions.assertEquals((long)14L, (long)statistics.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)statistics.heapAllocatedBytes());
        Assertions.assertEquals((long)1L, (long)statistics.totalTransactionPageCacheFaults());
        Assertions.assertEquals((long)4L, (long)statistics.totalTransactionPageCacheHits());
        statistics.addWaitingTime(1L);
        Assertions.assertEquals((long)1L, (long)statistics.getWaitingTimeNanos(0L));
        transaction.memoryTracker().releaseNative(14L);
        statistics.reset();
        transaction.memoryTracker().reset();
        statistics.init(4L, (PageCursorTracer)tracer);
        Assertions.assertEquals((long)4L, (long)statistics.cpuTimeMillis());
        Assertions.assertEquals((long)0L, (long)statistics.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)statistics.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)statistics.heapAllocatedBytes());
        Assertions.assertEquals((long)2L, (long)statistics.totalTransactionPageCacheFaults());
        Assertions.assertEquals((long)6L, (long)statistics.totalTransactionPageCacheHits());
        Assertions.assertEquals((long)0L, (long)statistics.getWaitingTimeNanos(0L));
    }

    @Test
    void includeLeaseInToString() {
        final int leaseId = 11;
        LeaseService leaseClient = (LeaseService)Mockito.mock(LeaseService.class);
        Mockito.when((Object)leaseClient.newClient()).thenReturn((Object)new LeaseClient(){

            public int leaseId() {
                return leaseId;
            }

            public void ensureValid() throws LeaseException {
            }
        });
        KernelTransactionImplementation transaction = this.newNotInitializedTransaction(leaseClient);
        transaction.initialize(0L, 0L, (StatementLocks)Mockito.mock(StatementLocks.class), KernelTransaction.Type.IMPLICIT, (SecurityContext)Mockito.mock(SecurityContext.class), 0L, 1L, ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertEquals((Object)("KernelTransaction[lease:" + leaseId + "]"), (Object)transaction.toString());
    }

    @Test
    void dynamicChangeTransactionHeapLimit() throws TransactionFailureException {
        this.config.set(GraphDatabaseSettings.memory_transaction_max_size, (Object)ByteUnit.mebiBytes((long)2L));
        try (KernelTransactionImplementation transaction = this.newTransaction(1000L);){
            Assertions.assertThrows(MemoryLimitExceededException.class, () -> transaction.memoryTracker().allocateHeap(ByteUnit.mebiBytes((long)3L)));
            transaction.closeTransaction();
            this.config.setDynamic(GraphDatabaseSettings.memory_transaction_max_size, (Object)ByteUnit.mebiBytes((long)4L), "test");
            transaction.initialize(5L, 0L, (StatementLocks)new SimpleStatementLocks((Locks.Client)new NoOpClient()), KernelTransaction.Type.IMPLICIT, SecurityContext.AUTH_DISABLED, 0L, 1L, ClientConnectionInfo.EMBEDDED_CONNECTION);
            transaction.memoryTracker().allocateHeap(ByteUnit.mebiBytes((long)3L));
        }
    }

    private LoginContext loginContext(boolean isWriteTx) {
        return isWriteTx ? AnonymousContext.write() : AnonymousContext.read();
    }

    private void initializeAndClose(KernelTransactionImplementation tx, int times, boolean isWriteTx) throws Exception {
        for (int i = 0; i < times; ++i) {
            SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
            tx.initialize((long)(i + 10), (long)(i + 10), (StatementLocks)statementLocks, KernelTransaction.Type.IMPLICIT, this.loginContext(isWriteTx).authorize(LoginContext.IdLookup.EMPTY, "neo4j"), 0L, 0L, ClientConnectionInfo.EMBEDDED_CONNECTION);
            tx.close();
        }
    }

    private TransactionRepresentation getObservedFirstTransaction() {
        return this.commitProcess.transactions.get(0);
    }

    private static /* synthetic */ void lambda$shouldAllowTerminatingFromADifferentThread$3(DoubleLatch latch, KernelTransaction transaction) {
        latch.waitForAllToStart();
        transaction.markForTermination((Status)Status.General.UnknownError);
        latch.finish();
    }

    private static class PredictablePageCursorTracer
    extends DefaultPageCursorTracer {
        private long iteration = 1L;

        PredictablePageCursorTracer() {
            super((PageCacheTracer)new DefaultPageCacheTracer(), "ktxTest");
        }

        public long hits() {
            ++this.iteration;
            return this.iteration * 2L;
        }

        public long faults() {
            return this.iteration;
        }
    }

    private static class ThreadBasedCpuClock
    implements CpuClock {
        private long iteration;

        private ThreadBasedCpuClock() {
        }

        public long cpuTimeNanos(long threadId) {
            ++this.iteration;
            return TimeUnit.MILLISECONDS.toNanos(this.iteration * threadId);
        }
    }
}

