/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class ConstraintIndexCreatorTest {
    private static final int PROPERTY_KEY_ID = 456;
    private static final int LABEL_ID = 123;
    private static final long INDEX_ID = 0L;
    private final IndexProviderDescriptor providerDescriptor = GenericNativeIndexProvider.DESCRIPTOR;
    private final LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)123, (int[])new int[]{456});
    private final UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint");
    private final IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint").withIndexProvider(this.providerDescriptor);
    private final IndexDescriptor index = this.prototype.materialise(0L);
    private final SchemaRead schemaRead = this.schemaRead();
    private final SchemaWrite schemaWrite = (SchemaWrite)Mockito.mock(SchemaWrite.class);
    private final TokenRead tokenRead = (TokenRead)Mockito.mock(TokenRead.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private StubKernel kernel;

    ConstraintIndexCreatorTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.kernel = new StubKernel();
        Mockito.when((Object)this.tokenRead.nodeLabelName(123)).thenReturn((Object)"Label");
        Mockito.when((Object)this.tokenRead.labelGetName(123)).thenReturn((Object)"Label");
        Mockito.when((Object)this.tokenRead.propertyKeyName(456)).thenReturn((Object)"prop");
        Mockito.when((Object)this.tokenRead.propertyKeyGetName(456)).thenReturn((Object)"prop");
    }

    @Test
    void shouldCreateIndexInAnotherTransaction() throws Exception {
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)indexingService.getIndexProxy(this.index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)this.index);
        Mockito.when((Object)this.schemaRead.indexGetForName(this.constraint.getName())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        IndexDescriptor constraintIndex = creator.createUniquenessConstraintIndex(this.createTransaction(), (IndexBackedConstraintDescriptor)this.constraint, this.prototype);
        Assertions.assertEquals((long)0L, (long)constraintIndex.getId());
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetForName(this.constraint.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    @Test
    void shouldDropIndexIfPopulationFails() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(this.index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)this.index);
        Mockito.when((Object)this.schemaRead.indexGetForName(this.constraint.getName())).thenReturn((Object)IndexDescriptor.NO_INDEX, (Object[])new IndexDescriptor[]{this.index});
        IndexEntryConflictException cause = new IndexEntryConflictException(2L, 1L, new Value[]{Values.of((Object)"a")});
        ((IndexProxy)Mockito.doThrow((Throwable[])new Throwable[]{new IndexPopulationFailedKernelException("some index", (Throwable)cause)}).when((Object)indexProxy)).awaitStoreScanCompleted(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class))).thenReturn((Object)Iterators.emptyResourceIterator()).thenReturn((Object)Iterators.iterator((Object)this.index));
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        UniquePropertyValueValidationException exception = (UniquePropertyValueValidationException)Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> creator.createUniquenessConstraintIndex(transaction, (IndexBackedConstraintDescriptor)this.constraint, this.prototype));
        Assertions.assertEquals((Object)"Existing data does not satisfy Constraint( name='constraint', type='UNIQUENESS', schema=(:Label {prop}) ): Both node 2 and node 1 share the property value ( String(\"a\") )", (Object)exception.getMessage());
        Assertions.assertEquals((int)2, (int)this.kernel.transactions.size());
        KernelTransactionImplementation tx1 = this.kernel.transactions.get(0);
        ((KernelTransactionImplementation)Mockito.verify((Object)tx1)).indexUniqueCreate(this.prototype);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead, (VerificationMode)Mockito.times((int)2))).indexGetForName(this.constraint.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        KernelTransactionImplementation kti2 = this.kernel.transactions.get(1);
        ((KernelTransactionImplementation)Mockito.verify((Object)kti2)).addIndexDoDropToTxState(this.index);
    }

    @Test
    void shouldDropIndexInAnotherTransaction() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        creator.dropUniquenessConstraintIndex(this.index);
        Assertions.assertEquals((int)1, (int)this.kernel.transactions.size());
        ((KernelTransactionImplementation)Mockito.verify((Object)this.kernel.transactions.get(0))).addIndexDoDropToTxState(this.index);
        Mockito.verifyNoInteractions((Object[])new Object[]{indexingService});
    }

    @Test
    void shouldReleaseLabelLockWhileAwaitingIndexPopulation() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(this.index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)this.schema)).thenReturn((Object)Iterators.emptyResourceIterator());
        Mockito.when((Object)this.schemaRead.indexGetForName(this.constraint.getName())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (IndexBackedConstraintDescriptor)this.constraint, this.prototype);
        ((Locks.Client)Mockito.verify((Object)transaction.statementLocks().pessimistic())).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
        ((Locks.Client)Mockito.verify((Object)transaction.statementLocks().pessimistic())).acquireExclusive(transaction.lockTracer(), (ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
    }

    @Test
    void shouldThrowOnExistingOrphanedConstraintIndexWithSameName() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        long orphanedConstraintIndexId = 111L;
        String orphanedName = "constraint";
        IndexDescriptor orphanedIndex = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName(orphanedName).materialise(orphanedConstraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(orphanedIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)this.schema)).thenReturn((Object)Iterators.iterator((Object)orphanedIndex));
        Mockito.when((Object)this.schemaRead.indexGetForName(orphanedName)).thenReturn((Object)orphanedIndex);
        Mockito.when((Object)this.schemaRead.indexGetOwningUniquenessConstraintId(orphanedIndex)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        Assertions.assertThrows(AlreadyConstrainedException.class, () -> creator.createUniquenessConstraintIndex(transaction, (IndexBackedConstraintDescriptor)this.constraint, this.prototype));
        Assertions.assertEquals((int)0, (int)this.kernel.transactions.size(), (String)"There should have been no need to acquire a statement to create the constraint index");
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetForName(this.constraint.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    void shouldIgnoreExistingOrphanedConstraintIndexWithDifferentName() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        long orphanedConstraintIndexId = 111L;
        String orphanedName = "blabla";
        IndexDescriptor orphanedIndex = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName(orphanedName).materialise(orphanedConstraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(orphanedIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy(this.index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)this.schema)).thenReturn((Object)Iterators.iterator((Object)orphanedIndex));
        Mockito.when((Object)this.schemaRead.indexGetForName(this.constraint.getName())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        Mockito.when((Object)this.schemaRead.indexGetForName(orphanedName)).thenReturn((Object)orphanedIndex);
        Mockito.when((Object)this.schemaRead.indexGetOwningUniquenessConstraintId(orphanedIndex)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (IndexBackedConstraintDescriptor)this.constraint, this.prototype);
        Assertions.assertEquals((int)1, (int)this.kernel.transactions.size());
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetForName(this.constraint.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    void shouldFailOnExistingOwnedConstraintIndex() {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        long constraintIndexOwnerId = 222L;
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)this.schema)).thenReturn((Object)Iterators.iterator((Object)this.index));
        Mockito.when((Object)this.schemaRead.indexGetForName(this.constraint.getName())).thenReturn((Object)this.index);
        Mockito.when((Object)this.schemaRead.indexGetOwningUniquenessConstraintId(this.index)).thenReturn((Object)constraintIndexOwnerId);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        Assertions.assertThrows(AlreadyConstrainedException.class, () -> {
            KernelTransactionImplementation transaction = this.createTransaction();
            creator.createUniquenessConstraintIndex(transaction, (IndexBackedConstraintDescriptor)this.constraint, this.prototype);
        });
        Assertions.assertEquals((int)0, (int)this.kernel.transactions.size(), (String)"There should have been no need to acquire a statement to create the constraint index");
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetForName(this.constraint.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    void shouldCreateConstraintIndexForSpecifiedProvider() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("Groovy", "1.2");
        IndexPrototype prototype = this.prototype.withIndexProvider(providerDescriptor);
        IndexDescriptor index = prototype.materialise(this.index.getId());
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(index)).thenReturn((Object)indexProxy);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        Mockito.when((Object)this.schemaRead.indexGetForName(this.constraint.getName())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (IndexBackedConstraintDescriptor)this.constraint, prototype);
        Assertions.assertEquals((int)1, (int)this.kernel.transactions.size());
        KernelTransactionImplementation transactionInstance = this.kernel.transactions.get(0);
        ((KernelTransactionImplementation)Mockito.verify((Object)transactionInstance)).indexUniqueCreate(prototype);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetForName(this.constraint.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    void logMessagesAboutConstraintCreation() throws SchemaKernelException, UniquePropertyValueValidationException, TransactionFailureException, IndexNotFoundKernelException {
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)indexingService.getIndexProxy(this.index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)this.index);
        Mockito.when((Object)this.schemaRead.indexGetForName(this.constraint.getName())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, indexingService, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (IndexBackedConstraintDescriptor)this.constraint, this.prototype);
        String constraintString = this.constraint.userDescription((TokenNameLookup)this.tokenRead);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{String.format("Starting constraint creation: %s.", constraintString), String.format("Constraint %s populated, starting verification.", constraintString), String.format("Constraint %s verified.", constraintString)});
    }

    private SchemaRead schemaRead() {
        SchemaRead schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
        Mockito.when((Object)schemaRead.index((SchemaDescriptor)this.schema)).thenReturn((Object)Iterators.emptyResourceIterator());
        return schemaRead;
    }

    private KernelTransactionImplementation createTransaction() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
            Mockito.when((Object)storageEngine.newReader()).thenReturn((Object)storageReader);
            SimpleStatementLocks locks = new SimpleStatementLocks((Locks.Client)Mockito.mock(Locks.Client.class));
            Mockito.when((Object)transaction.statementLocks()).thenReturn((Object)locks);
            Mockito.when((Object)transaction.tokenRead()).thenReturn((Object)this.tokenRead);
            Mockito.when((Object)transaction.schemaRead()).thenReturn((Object)this.schemaRead);
            Mockito.when((Object)transaction.schemaWrite()).thenReturn((Object)this.schemaWrite);
            TransactionState transactionState = (TransactionState)Mockito.mock(TransactionState.class);
            Mockito.when((Object)transaction.txState()).thenReturn((Object)transactionState);
            Mockito.when((Object)transaction.indexUniqueCreate((IndexPrototype)ArgumentMatchers.any(IndexPrototype.class))).thenAnswer(i -> ((IndexPrototype)i.getArgument(0)).materialise(0L));
            Mockito.when((Object)transaction.newStorageReader()).thenReturn((Object)((StorageReader)Mockito.mock(StorageReader.class)));
        }
        catch (InvalidTransactionTypeKernelException e) {
            Assertions.fail((String)"Expected write transaction");
        }
        return transaction;
    }

    private class StubKernel
    implements Kernel {
        private final List<KernelTransactionImplementation> transactions = new ArrayList<KernelTransactionImplementation>();

        private StubKernel() {
        }

        private KernelTransaction remember(KernelTransactionImplementation kernelTransaction) {
            this.transactions.add(kernelTransaction);
            return kernelTransaction;
        }

        public KernelTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, long timeout) {
            return this.remember(ConstraintIndexCreatorTest.this.createTransaction());
        }

        public KernelTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo) {
            return this.remember(ConstraintIndexCreatorTest.this.createTransaction());
        }

        public KernelTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) {
            return this.remember(ConstraintIndexCreatorTest.this.createTransaction());
        }

        public void registerProcedure(CallableProcedure procedure) {
        }

        public void registerUserFunction(CallableUserFunction function) {
        }

        public void registerUserAggregationFunction(CallableUserAggregationFunction function) {
        }

        public CursorFactory cursors() {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

