/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;

class RelationshipChangesForNodeTest {
    RelationshipChangesForNodeTest() {
    }

    @Test
    void shouldGetRelationships() {
        RelationshipChangesForNode changes = RelationshipChangesForNode.createRelationshipChangesForNode((RelationshipChangesForNode.DiffStrategy)RelationshipChangesForNode.DiffStrategy.ADD, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int TYPE = 2;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        LongIterator rawRelationships = changes.getRelationships();
        Assertions.assertThat((long[])PrimitiveLongCollections.asArray((LongIterator)rawRelationships)).containsExactly(new long[]{1L, 2L, 3L, 4L, 5L, 6L});
    }

    @Test
    void shouldGetRelationshipsByTypeAndDirection() {
        RelationshipChangesForNode changes = RelationshipChangesForNode.createRelationshipChangesForNode((RelationshipChangesForNode.DiffStrategy)RelationshipChangesForNode.DiffStrategy.ADD, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int TYPE = 2;
        int DECOY_TYPE = 666;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(10L, 666, RelationshipDirection.INCOMING);
        changes.addRelationship(11L, 666, RelationshipDirection.OUTGOING);
        changes.addRelationship(12L, 666, RelationshipDirection.LOOP);
        LongIterator rawIncoming = changes.getRelationships(Direction.INCOMING, 2);
        Assertions.assertThat((long[])PrimitiveLongCollections.asArray((LongIterator)rawIncoming)).containsExactly(new long[]{1L, 4L, 5L, 6L});
        LongIterator rawOutgoing = changes.getRelationships(Direction.OUTGOING, 2);
        Assertions.assertThat((long[])PrimitiveLongCollections.asArray((LongIterator)rawOutgoing)).containsExactly(new long[]{2L, 3L, 4L, 5L, 6L});
    }
}

