/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.ReadOnly;

class AccessCapabilityFactoryTest {
    private final TestDatabaseIdRepository databaseIdRepository = new TestDatabaseIdRepository();
    private final NamedDatabaseId namedDatabaseId = this.databaseIdRepository.getRaw("foo");
    private final DatabaseConfig readWriteConfig = new DatabaseConfig(Config.defaults((Setting)GraphDatabaseSettings.read_only, (Object)false), this.namedDatabaseId);
    private final DatabaseConfig readOnlyConfig = new DatabaseConfig(Config.defaults((Setting)GraphDatabaseSettings.read_only, (Object)true), this.namedDatabaseId);

    AccessCapabilityFactoryTest() {
    }

    @Test
    void shouldCreateConfigDependentFactoryForReadWriteConfig() {
        AccessCapabilityFactory factory = AccessCapabilityFactory.configDependent();
        AccessCapability accessCapability = factory.newAccessCapability(this.readWriteConfig);
        Assertions.assertThat((Object)accessCapability).isInstanceOf(CanWrite.class);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((AccessCapability)accessCapability).assertCanWrite());
    }

    @Test
    void shouldCreateConfigDependentFactoryForReadOnlyConfig() {
        AccessCapabilityFactory factory = AccessCapabilityFactory.configDependent();
        AccessCapability accessCapability = factory.newAccessCapability(this.readOnlyConfig);
        Assertions.assertThat((Object)accessCapability).isInstanceOf(ReadOnly.class);
        org.junit.jupiter.api.Assertions.assertThrows(WriteOperationsNotAllowedException.class, () -> ((AccessCapability)accessCapability).assertCanWrite());
    }

    @Test
    void shouldCreateFixedFactory() {
        CanWrite accessCapability1 = new CanWrite();
        ReadOnly accessCapability2 = new ReadOnly();
        AccessCapabilityFactory factory1 = AccessCapabilityFactory.fixed((AccessCapability)accessCapability1);
        AccessCapabilityFactory factory2 = AccessCapabilityFactory.fixed((AccessCapability)accessCapability2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability1, (Object)factory1.newAccessCapability(this.readWriteConfig));
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability1, (Object)factory1.newAccessCapability(this.readOnlyConfig));
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability2, (Object)factory2.newAccessCapability(this.readWriteConfig));
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability2, (Object)factory2.newAccessCapability(this.readOnlyConfig));
    }
}

