/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.storageengine.api.StorageEngine;

class CommunityCommitProcessFactoryTest {
    CommunityCommitProcessFactoryTest() {
    }

    @Test
    void createReadOnlyCommitProcess() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.read_only, (Object)true);
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), config);
        Assertions.assertThat((Object)commitProcess).isInstanceOf(ReadOnlyTransactionCommitProcess.class);
    }

    @Test
    void createRegularCommitProcess() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), Config.defaults());
        Assertions.assertThat((Object)commitProcess).isInstanceOf(TransactionRepresentationCommitProcess.class);
    }
}

