/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongPredicate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferAllocator;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ThreadSafePeakMemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.Barrier;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.actors.Actor;
import org.neo4j.test.extension.actors.ActorsExtension;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.JobSchedulerAdapter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ActorsExtension
@EphemeralPageCacheExtension
class BlockBasedIndexPopulatorTest {
    private static final LabelSchemaDescriptor SCHEMA_DESCRIPTOR = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SCHEMA_DESCRIPTOR).withName("index").materialise(1L);
    public static final int SUFFICIENTLY_LARGE_BUFFER_SIZE = (int)ByteUnit.kibiBytes((long)50L);
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    Actor merger;
    @Inject
    Actor closer;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    TestDirectory testDir;
    @Inject
    PageCache pageCache;
    private IndexFiles indexFiles;
    private DatabaseIndexContext databaseIndexContext;
    private JobScheduler jobScheduler;
    private IndexPopulator.PopulationWorkScheduler populationWorkScheduler;

    BlockBasedIndexPopulatorTest() {
    }

    @BeforeEach
    void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.testDir.homePath()).forProvider(providerDescriptor);
        this.indexFiles = new IndexFiles(this.fs, directoryStructure, INDEX_DESCRIPTOR.getId());
        this.databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs).build();
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.populationWorkScheduler = this.wrapScheduler(this.jobScheduler);
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.shutdown();
    }

    private IndexPopulator.PopulationWorkScheduler wrapScheduler(final JobScheduler jobScheduler) {
        return new IndexPopulator.PopulationWorkScheduler(){

            public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                return jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAwaitMergeToBeFullyAbortedBeforeLeavingCloseMethod() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates(), PageCursorTracer.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Future closeFuture = this.closer.submit(() -> populator.close(false, PageCursorTracer.NULL));
            this.closer.untilWaiting();
            monitor.barrier.release();
            closeFuture.get();
            closed = true;
            Assertions.assertTrue((boolean)mergeFuture.isDone());
        }
        finally {
            if (!closed) {
                populator.close(true, PageCursorTracer.NULL);
            }
        }
    }

    private Callable<Object> scanCompletedTask(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator) {
        return () -> {
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleBeingAbortedWhileMerging() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 2L);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates(), PageCursorTracer.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.await();
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Future closeFuture = this.closer.submit(() -> populator.close(false, PageCursorTracer.NULL));
            this.closer.untilWaiting();
            monitor.mergeFinishedBarrier.release();
            closeFuture.get();
            closed = true;
            mergeFuture.get();
        }
        finally {
            if (!closed) {
                populator.close(false, PageCursorTracer.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReportAccurateProgressThroughoutThePhases() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 1L);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates(), PageCursorTracer.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Assertions.assertEquals((float)0.5f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Assertions.assertEquals((float)0.7f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.mergeFinishedBarrier.release();
            mergeFuture.get();
            Assertions.assertEquals((float)1.0f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.0f);
        }
        finally {
            populator.close(true, PageCursorTracer.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCorrectlyDecideToAwaitMergeDependingOnProgress() throws Throwable {
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates(), PageCursorTracer.NULL);
            Race race = new Race();
            race.addContestant(Race.throwing(() -> populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL)));
            race.addContestant(Race.throwing(() -> populator.close(false, PageCursorTracer.NULL)));
            race.go();
            closed = true;
            EphemeralFileSystemAbstraction ephemeralFileSystem = (EphemeralFileSystemAbstraction)this.fs;
            ephemeralFileSystem.assertNoOpenFiles();
        }
        finally {
            if (!closed) {
                populator.close(true, PageCursorTracer.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeleteDirectoryOnDrop() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates(), PageCursorTracer.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Assertions.assertTrue((boolean)this.fs.fileExists(this.indexFiles.getBase()));
            Assertions.assertTrue((boolean)this.fs.isDirectory(this.indexFiles.getBase()));
            Assertions.assertTrue((this.fs.listFiles(this.indexFiles.getBase()).length > 0 ? 1 : 0) != 0);
            Future dropFuture = this.closer.submit(() -> populator.drop());
            this.closer.untilWaiting();
            monitor.barrier.release();
            dropFuture.get();
            closed = true;
            Assertions.assertTrue((boolean)mergeFuture.isDone());
            Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getBase()));
        }
        finally {
            if (!closed) {
                populator.close(true, PageCursorTracer.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeallocateAllAllocatedMemoryOnClose() throws IndexEntryConflictException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR, bufferFactory, (MemoryTracker)memoryTracker);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = BlockBasedIndexPopulatorTest.batchOfUpdates();
            populator.add(updates, PageCursorTracer.NULL);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedNativeMemory();
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assertions.assertTrue((memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0, (String)"expected some memory to have been temporarily allocated in scanCompleted");
            populator.close(true, PageCursorTracer.NULL);
            closed = true;
            bufferFactory.close();
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            if (!closed) {
                populator.close(true, PageCursorTracer.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeallocateAllAllocatedMemoryOnDrop() throws IndexEntryConflictException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR, bufferFactory, (MemoryTracker)memoryTracker);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = BlockBasedIndexPopulatorTest.batchOfUpdates();
            populator.add(updates, PageCursorTracer.NULL);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedNativeMemory();
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assertions.assertTrue((memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0, (String)"expected some memory to have been temporarily allocated in scanCompleted");
            populator.drop();
            closed = true;
            bufferFactory.close();
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            if (!closed) {
                populator.close(true, PageCursorTracer.NULL);
            }
        }
    }

    @Test
    void shouldBuildNonUniqueSampleAsPartOfScanCompleted() throws IndexEntryConflictException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR, bufferFactory, (MemoryTracker)memoryTracker);
        Collection<IndexEntryUpdate<?>> populationUpdates = BlockBasedIndexPopulatorTest.batchOfUpdates();
        populator.add(populationUpdates, PageCursorTracer.NULL);
        populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
        int numberOfUpdatesAfterCompleted = 4;
        try (IndexUpdater updater = populator.newPopulatingUpdater(PageCursorTracer.NULL);){
            for (int i = 0; i < numberOfUpdatesAfterCompleted; ++i) {
                updater.process(IndexEntryUpdate.add((long)(10000 + i), (SchemaDescriptorSupplier)SCHEMA_DESCRIPTOR, (Value[])new Value[]{Values.intValue((int)i)}));
            }
        }
        populator.close(true, PageCursorTracer.NULL);
        IndexSample sample = populator.sample(PageCursorTracer.NULL);
        Assertions.assertEquals((long)populationUpdates.size(), (long)sample.indexSize());
        Assertions.assertEquals((long)populationUpdates.size(), (long)sample.sampleSize());
        Assertions.assertEquals((long)populationUpdates.size(), (long)sample.uniqueValues());
        Assertions.assertEquals((long)numberOfUpdatesAfterCompleted, (long)sample.updates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldFlushTreeOnScanCompleted() throws IndexEntryConflictException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        final AtomicInteger checkpoints = new AtomicInteger();
        GBPTree.Monitor.Adaptor treeMonitor = new GBPTree.Monitor.Adaptor(){

            public void checkpointCompleted() {
                checkpoints.incrementAndGet();
            }
        };
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, (GBPTree.Monitor)treeMonitor, bufferFactory, (MemoryTracker)memoryTracker);
        try {
            int numberOfCheckPointsBeforeScanCompleted = checkpoints.get();
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
            Assertions.assertEquals((int)(numberOfCheckPointsBeforeScanCompleted + 1), (int)checkpoints.get());
        }
        finally {
            populator.close(true, PageCursorTracer.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScheduleMergeOnJobSchedulerWithCorrectGroup() throws IndexEntryConflictException {
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates(), PageCursorTracer.NULL);
            final MutableBoolean called = new MutableBoolean();
            JobSchedulerAdapter trackingJobScheduler = new JobSchedulerAdapter(){

                public <T> JobHandle<T> schedule(Group group, JobMonitoringParams jobMonitoringParams, Callable<T> job) {
                    called.setTrue();
                    AssertionsForInterfaceTypes.assertThat((Comparable)group).isSameAs((Object)Group.INDEX_POPULATION_WORK);
                    return BlockBasedIndexPopulatorTest.this.jobScheduler.schedule(group, jobMonitoringParams, job);
                }
            };
            populator.scanCompleted(PhaseTracker.nullInstance, this.wrapScheduler((JobScheduler)trackingJobScheduler), PageCursorTracer.NULL);
            Assertions.assertTrue((boolean)called.booleanValue());
            populator.close(true, PageCursorTracer.NULL);
            closed = true;
        }
        finally {
            if (!closed) {
                populator.close(true, PageCursorTracer.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAcceptBatchAddedMaxSizeValue() throws IndexEntryConflictException, IOException {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap();
            GenericLayout layout = this.layout();
            Value value = BlockBasedIndexPopulatorTest.generateStringResultingInSize(layout, size);
            List<IndexEntryUpdate> data = Collections.singletonList(IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{value}));
            populator.add(data, PageCursorTracer.NULL);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
            try (Seeker<GenericKey, NativeIndexValue> seek = this.seek((GBPTree<GenericKey, NativeIndexValue>)populator.tree, (Layout<GenericKey, NativeIndexValue>)layout);){
                Assertions.assertTrue((boolean)seek.next());
                Assertions.assertEquals((Object)value, (Object)((GenericKey)seek.key()).asValue());
                Assertions.assertFalse((boolean)seek.next());
            }
        }
        finally {
            populator.close(true, PageCursorTracer.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldFailOnBatchAddedTooLargeValue() {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap() + 1;
            Assertions.assertThrows(IllegalArgumentException.class, () -> populator.add(Collections.singletonList(IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{BlockBasedIndexPopulatorTest.generateStringResultingInSize(this.layout(), size)})), PageCursorTracer.NULL));
        }
        finally {
            populator.close(false, PageCursorTracer.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldAcceptUpdatedMaxSizeValue(boolean updateBeforeScanCompleted) throws Throwable {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap();
            GenericLayout layout = this.layout();
            Value value = BlockBasedIndexPopulatorTest.generateStringResultingInSize(layout, size);
            IndexEntryUpdate update = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{value});
            Race.ThrowingRunnable updateAction = () -> {
                try (IndexUpdater updater = populator.newPopulatingUpdater(PageCursorTracer.NULL);){
                    updater.process(update);
                }
            };
            if (updateBeforeScanCompleted) {
                updateAction.run();
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
            } else {
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
                updateAction.run();
            }
            try (Seeker<GenericKey, NativeIndexValue> seek = this.seek((GBPTree<GenericKey, NativeIndexValue>)populator.tree, (Layout<GenericKey, NativeIndexValue>)layout);){
                Assertions.assertTrue((boolean)seek.next());
                Assertions.assertEquals((Object)value, (Object)((GenericKey)seek.key()).asValue());
                Assertions.assertFalse((boolean)seek.next());
            }
        }
        finally {
            populator.close(true, PageCursorTracer.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldFailOnUpdatedTooLargeValue(boolean updateBeforeScanCompleted) throws IndexEntryConflictException {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap() + 1;
            if (!updateBeforeScanCompleted) {
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, PageCursorTracer.NULL);
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                try (IndexUpdater updater = populator.newPopulatingUpdater(PageCursorTracer.NULL);){
                    updater.process(IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{BlockBasedIndexPopulatorTest.generateStringResultingInSize(this.layout(), size)}));
                }
            });
        }
        finally {
            populator.close(false, PageCursorTracer.NULL);
        }
    }

    private Seeker<GenericKey, NativeIndexValue> seek(GBPTree<GenericKey, NativeIndexValue> tree, Layout<GenericKey, NativeIndexValue> layout) throws IOException {
        GenericKey low = (GenericKey)layout.newKey();
        low.initialize(Long.MIN_VALUE);
        low.initValuesAsLowest();
        GenericKey high = (GenericKey)layout.newKey();
        high.initialize(Long.MAX_VALUE);
        high.initValuesAsHighest();
        return tree.seek((Object)low, (Object)high, PageCursorTracer.NULL);
    }

    private void externalUpdates(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, int firstId, int lastId) throws IndexEntryConflictException {
        try (IndexUpdater updater = populator.newPopulatingUpdater(PageCursorTracer.NULL);){
            for (int i = firstId; i < lastId; ++i) {
                updater.process(BlockBasedIndexPopulatorTest.add(i));
            }
        }
    }

    private BlockBasedIndexPopulator<GenericKey, NativeIndexValue> instantiatePopulator(BlockStorage.Monitor monitor) {
        return this.instantiatePopulator(monitor, GBPTree.NO_MONITOR, ByteBufferFactory.heapBufferFactory((int)100), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private BlockBasedIndexPopulator<GenericKey, NativeIndexValue> instantiatePopulator(BlockStorage.Monitor monitor, GBPTree.Monitor treeMonitor, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker) {
        GenericLayout layout = this.layout();
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = new BlockBasedIndexPopulator<GenericKey, NativeIndexValue>(this.databaseIndexContext, this.indexFiles, (IndexLayout)layout, INDEX_DESCRIPTOR, false, bufferFactory, memoryTracker, 2, monitor, treeMonitor){

            NativeIndexReader<GenericKey, NativeIndexValue> newReader() {
                throw new UnsupportedOperationException("Not needed in this test");
            }

            protected IndexValueValidator instantiateValueValidator() {
                return new GenericIndexKeyValidator(this.tree.keyValueSizeCap(), this.descriptor, (Layout)this.layout, BlockBasedIndexPopulatorTest.this.tokenNameLookup);
            }
        };
        populator.create();
        return populator;
    }

    private GenericLayout layout() {
        IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
        return new GenericLayout(1, spatialSettings);
    }

    private static Collection<IndexEntryUpdate<?>> batchOfUpdates() {
        ArrayList updates = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            updates.add(BlockBasedIndexPopulatorTest.add(i));
        }
        return updates;
    }

    private static IndexEntryUpdate<IndexDescriptor> add(int i) {
        return IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{Values.stringValue((String)("Value" + i))});
    }

    static <KEY extends NativeIndexKey<KEY>> Value generateStringResultingInSize(Layout<KEY, ?> layout, int size) {
        TextValue value;
        NativeIndexKey key = (NativeIndexKey)layout.newKey();
        key.initialize(0L);
        int stringLength = size;
        do {
            value = Values.stringValue((String)"A".repeat(stringLength--));
            key.initFromValue(0, (Value)value, NativeIndexKey.Inclusion.NEUTRAL);
        } while (layout.keySize((Object)key) > size);
        Assertions.assertEquals((int)size, (int)layout.keySize((Object)key));
        return value;
    }

    private static class TrappingMonitor
    extends BlockStorage.Monitor.Adapter {
        private final Barrier.Control barrier = new Barrier.Control();
        private final Barrier.Control mergeFinishedBarrier = new Barrier.Control();
        private final LongPredicate trapForMergeIterationFinished;

        TrappingMonitor(LongPredicate trapForMergeIterationFinished) {
            this.trapForMergeIterationFinished = trapForMergeIterationFinished;
        }

        public void mergedBlocks(long resultingBlockSize, long resultingEntryCount, long numberOfBlocks) {
            this.barrier.reached();
        }

        public void mergeIterationFinished(long numberOfBlocksBefore, long numberOfBlocksAfter) {
            if (this.trapForMergeIterationFinished.test(numberOfBlocksAfter)) {
                this.mergeFinishedBarrier.reached();
            }
        }
    }
}

