/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProviderFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class FailingGenericNativeIndexProviderFactory
extends ExtensionFactory<AbstractIndexProviderFactory.Dependencies> {
    public static final String INITIAL_STATE_FAILURE_MESSAGE = "Override initial state as failed";
    public static final String POPULATION_FAILURE_MESSAGE = "Fail on update during population";
    private final GenericNativeIndexProviderFactory actual;
    private final EnumSet<FailureType> failureTypes;

    public FailingGenericNativeIndexProviderFactory(FailureType ... failureTypes) {
        this(new GenericNativeIndexProviderFactory(), failureTypes);
    }

    private FailingGenericNativeIndexProviderFactory(GenericNativeIndexProviderFactory actual, FailureType ... failureTypes) {
        super(ExtensionType.DATABASE, actual.getName());
        if (failureTypes.length == 0) {
            throw new IllegalArgumentException("At least one failure type, otherwise there's no point in this provider");
        }
        this.actual = actual;
        this.failureTypes = EnumSet.of(failureTypes[0], Arrays.copyOfRange(failureTypes, 1, failureTypes.length));
    }

    public Lifecycle newInstance(ExtensionContext context, AbstractIndexProviderFactory.Dependencies dependencies) {
        final IndexProvider actualProvider = this.actual.newInstance(context, dependencies);
        return new IndexProvider.Delegating(actualProvider){

            public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
                IndexPopulator actualPopulator = actualProvider.getPopulator(descriptor, samplingConfig, bufferFactory, memoryTracker, tokenNameLookup);
                if (FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.POPULATION)) {
                    return new IndexPopulator.Delegating(actualPopulator){

                        public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) {
                            throw new RuntimeException(FailingGenericNativeIndexProviderFactory.POPULATION_FAILURE_MESSAGE);
                        }
                    };
                }
                return actualPopulator;
            }

            public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
                final IndexAccessor actualAccessor = actualProvider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);
                return new IndexAccessor.Delegating(actualAccessor){

                    public IndexUpdater newUpdater(IndexUpdateMode mode, PageCursorTracer cursorTracer) {
                        IndexUpdater actualUpdater = actualAccessor.newUpdater(mode, cursorTracer);
                        return new DelegatingIndexUpdater(actualUpdater){

                            public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                                if (!FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.SKIP_ONLINE_UPDATES)) {
                                    super.process(update);
                                }
                            }
                        };
                    }
                };
            }

            public String getPopulationFailure(IndexDescriptor descriptor, PageCursorTracer cursorTracer) {
                return FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? FailingGenericNativeIndexProviderFactory.INITIAL_STATE_FAILURE_MESSAGE : actualProvider.getPopulationFailure(descriptor, cursorTracer);
            }

            public InternalIndexState getInitialState(IndexDescriptor descriptor, PageCursorTracer cursorTracer) {
                return FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? InternalIndexState.FAILED : actualProvider.getInitialState(descriptor, cursorTracer);
            }
        };
    }

    public static enum FailureType {
        POPULATION,
        INITIAL_STATE,
        SKIP_ONLINE_UPDATES;

    }
}

